/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import org.apache.hop.ui.hopgui.HopGui;

@ExtensionPoint(id="HopImportConnections", description="Import relational database connections into a Hop project", extensionPointId="HopImportConnections")
public class HopImportDbConnections
implements IExtensionPoint<Object[]> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables variables, Object[] connectionObject) throws HopException {
        String projectName = (String)connectionObject[0];
        List connectionList = (List)connectionObject[1];
        TreeMap connectionFileMap = (TreeMap)connectionObject[2];
        HopGui hopGui = HopGui.getInstance();
        ILogChannel log = hopGui.getLog();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        Project project = projectConfig.loadProject(hopGui.getVariables());
        ProjectsUtil.enableProject(hopGui.getLog(), projectName, project, variables, Collections.emptyList(), null, (IHasHopMetadataProvider)hopGui);
        MultiMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        IHopMetadataSerializer databaseSerializer = metadataProvider.getSerializer(DatabaseMeta.class);
        projectConfig.getProjectHome();
        for (DatabaseMeta databaseMeta : connectionList) {
            try {
                if (databaseSerializer.exists(databaseMeta.getName())) {
                    log.logBasic("Skipped: a connection with name '" + databaseMeta.getName() + "' already exists.");
                    continue;
                }
                databaseSerializer.save((IHopMetadata)databaseMeta);
            }
            catch (HopException e) {
                throw new HopException("Error importing database metadata [" + databaseMeta.getName() + "]", (Throwable)e);
            }
        }
        String eol = System.getProperty("line.separator");
        if (connectionList.size() > 0) {
            String connectionsFileName = projectConfig.getProjectHome() + System.getProperty("file.separator") + "connections.csv";
            try (OutputStream outputStream = HopVfs.getOutputStream((String)connectionsFileName, (boolean)false);){
                for (Map.Entry entry : connectionFileMap.entrySet()) {
                    outputStream.write(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                    outputStream.write(",".getBytes(StandardCharsets.UTF_8));
                    outputStream.write(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                    outputStream.write(eol.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new HopException("Error writing connections file to project " + projectName, (Throwable)e);
            }
        }
    }
}

