/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientUtil {
    public static boolean areScanStartRowAndStopRowEqual(byte[] startRow, byte[] stopRow) {
        return startRow != null && startRow.length > 0 && Bytes.equals(startRow, stopRow);
    }

    public static Cursor createCursor(byte[] row) {
        return new Cursor(row);
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }
}

