/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.MasterAddressRefresher;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.MasterRegistryFetchException;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Strings;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.hbase.shaded.com.google.common.net.HostAndPort;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.util.DNS;

@InterfaceAudience.Private
public class MasterRegistry
implements ConnectionRegistry {
    private static final String MASTER_ADDRS_CONF_SEPARATOR = ",";
    private volatile ImmutableMap<String, MasterProtos.ClientMetaService.Interface> masterAddr2Stub;
    private RpcClient rpcClient;
    private RpcControllerFactory rpcControllerFactory;
    private int rpcTimeoutMs;
    protected MasterAddressRefresher masterAddressRefresher;

    @Override
    public void init(Connection connection) throws IOException {
        Configuration conf = connection.getConfiguration();
        this.rpcTimeoutMs = (int)Math.min(Integer.MAX_VALUE, conf.getLong("hbase.rpc.timeout", 60000L));
        this.rpcClient = RpcClientFactory.createClient(conf, null);
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        this.populateMasterStubs(MasterRegistry.parseMasterAddrs(conf));
        this.masterAddressRefresher = new MasterAddressRefresher(conf, this);
    }

    protected <T extends Message> T doCall(Callable<T> callable) throws MasterRegistryFetchException {
        Exception lastException = null;
        Set masters = this.masterAddr2Stub.keySet();
        ArrayList stubs = new ArrayList(this.masterAddr2Stub.values());
        Collections.shuffle(stubs, ThreadLocalRandom.current());
        for (MasterProtos.ClientMetaService.Interface stub : stubs) {
            HBaseRpcController controller = this.rpcControllerFactory.newController();
            try {
                T resp = callable.call(stub, controller);
                if (!controller.failed()) {
                    return resp;
                }
                lastException = controller.getFailed();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (!ClientExceptionsUtil.isConnectionException(lastException)) continue;
            this.masterAddressRefresher.refreshNow();
        }
        throw new MasterRegistryFetchException(masters, lastException);
    }

    @Override
    public ServerName getActiveMaster() throws IOException {
        MasterProtos.GetMastersResponseEntry activeMaster = null;
        for (MasterProtos.GetMastersResponseEntry entry : this.getMastersInternal().getMasterServersList()) {
            if (!entry.getIsActive()) continue;
            activeMaster = entry;
            break;
        }
        if (activeMaster == null) {
            throw new HBaseIOException("No active master found");
        }
        return ProtobufUtil.toServerName(activeMaster.getServerName());
    }

    List<ServerName> getMasters() throws IOException {
        ArrayList<ServerName> result = new ArrayList<ServerName>();
        for (MasterProtos.GetMastersResponseEntry entry : this.getMastersInternal().getMasterServersList()) {
            result.add(ProtobufUtil.toServerName(entry.getServerName()));
        }
        return result;
    }

    private MasterProtos.GetMastersResponse getMastersInternal() throws IOException {
        return this.doCall(new Callable<MasterProtos.GetMastersResponse>(){

            @Override
            public MasterProtos.GetMastersResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                BlockingRpcCallback<MasterProtos.GetMastersResponse> cb = new BlockingRpcCallback<MasterProtos.GetMastersResponse>();
                stub.getMasters(controller, MasterProtos.GetMastersRequest.getDefaultInstance(), cb);
                return cb.get();
            }
        });
    }

    @Override
    public RegionLocations getMetaRegionLocations() throws IOException {
        MasterProtos.GetMetaRegionLocationsResponse resp = this.doCall(new Callable<MasterProtos.GetMetaRegionLocationsResponse>(){

            @Override
            public MasterProtos.GetMetaRegionLocationsResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                BlockingRpcCallback<MasterProtos.GetMetaRegionLocationsResponse> cb = new BlockingRpcCallback<MasterProtos.GetMetaRegionLocationsResponse>();
                stub.getMetaRegionLocations(controller, MasterProtos.GetMetaRegionLocationsRequest.getDefaultInstance(), cb);
                return cb.get();
            }
        });
        ArrayList<HRegionLocation> result = new ArrayList<HRegionLocation>();
        for (HBaseProtos.RegionLocation loc : resp.getMetaLocationsList()) {
            result.add(ProtobufUtil.toRegionLocation(loc));
        }
        return new RegionLocations(result);
    }

    @Override
    public String getClusterId() throws IOException {
        MasterProtos.GetClusterIdResponse resp = this.doCall(new Callable<MasterProtos.GetClusterIdResponse>(){

            @Override
            public MasterProtos.GetClusterIdResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                BlockingRpcCallback<MasterProtos.GetClusterIdResponse> cb = new BlockingRpcCallback<MasterProtos.GetClusterIdResponse>();
                stub.getClusterId(controller, MasterProtos.GetClusterIdRequest.getDefaultInstance(), cb);
                return cb.get();
            }
        });
        return resp.getClusterId();
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        MasterProtos.GetNumLiveRSResponse resp = this.doCall(new Callable<MasterProtos.GetNumLiveRSResponse>(){

            @Override
            public MasterProtos.GetNumLiveRSResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                BlockingRpcCallback<MasterProtos.GetNumLiveRSResponse> cb = new BlockingRpcCallback<MasterProtos.GetNumLiveRSResponse>();
                stub.getNumLiveRS(controller, MasterProtos.GetNumLiveRSRequest.getDefaultInstance(), cb);
                return cb.get();
            }
        });
        return resp.getNumRegionServers();
    }

    @Override
    public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
        final MasterProtos.GetTableStateRequest request = MasterProtos.GetTableStateRequest.newBuilder().setTableName(tableName.getNameAsString()).setIsEnabled(enabled).build();
        MasterProtos.GetTableStateResponse resp = this.doCall(new Callable<MasterProtos.GetTableStateResponse>(){

            @Override
            public MasterProtos.GetTableStateResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                BlockingRpcCallback<MasterProtos.GetTableStateResponse> cb = new BlockingRpcCallback<MasterProtos.GetTableStateResponse>();
                stub.getTableState(controller, request, cb);
                return cb.get();
            }
        });
        return resp.getEnabledOrDisabled();
    }

    @Override
    public void close() {
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
    }

    @InterfaceAudience.Private
    public static Set<ServerName> parseMasterAddrs(Configuration conf) throws UnknownHostException {
        HashSet<ServerName> masterAddrs = new HashSet<ServerName>();
        String configuredMasters = MasterRegistry.getMasterAddr(conf);
        for (String masterAddr : configuredMasters.split(MASTER_ADDRS_CONF_SEPARATOR)) {
            HostAndPort masterHostPort = HostAndPort.fromString(masterAddr.trim()).withDefaultPort(16000);
            masterAddrs.add(ServerName.valueOf(masterHostPort.toString(), -1L));
        }
        Preconditions.checkArgument(!masterAddrs.isEmpty(), "At least one master address is needed");
        return masterAddrs;
    }

    @InterfaceAudience.Private
    public static String getMasterAddr(Configuration conf) throws UnknownHostException {
        String masterAddrFromConf = conf.get("hbase.masters");
        if (!Strings.isNullOrEmpty(masterAddrFromConf)) {
            return masterAddrFromConf;
        }
        String hostname = DNS.getMasterHostname(conf);
        int port = conf.getInt("hbase.master.port", 16000);
        return String.format("%s:%d", hostname, port);
    }

    void populateMasterStubs(Set<ServerName> masters) throws IOException {
        Preconditions.checkNotNull(masters);
        ImmutableMap.Builder<String, MasterProtos.ClientMetaService.Stub> builder = ImmutableMap.builder();
        User user = User.getCurrent();
        for (ServerName masterAddr : masters) {
            builder.put(masterAddr.toString(), MasterProtos.ClientMetaService.newStub(this.rpcClient.createRpcChannel(masterAddr, user, this.rpcTimeoutMs)));
        }
        this.masterAddr2Stub = builder.build();
    }

    @InterfaceAudience.Private
    ImmutableSet<String> getParsedMasterServers() {
        return this.masterAddr2Stub.keySet();
    }

    protected static interface Callable<T extends Message> {
        public T call(MasterProtos.ClientMetaService.Interface var1, RpcController var2) throws IOException;
    }
}

