/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack;

import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack.HeaderField;

final class DynamicTable {
    HeaderField[] headerFields;
    int head;
    int tail;
    private long size;
    private long capacity = -1L;

    DynamicTable(long initialCapacity) {
        this.setCapacity(initialCapacity);
    }

    public int length() {
        int length = this.head < this.tail ? this.headerFields.length - this.tail + this.head : this.head - this.tail;
        return length;
    }

    public long size() {
        return this.size;
    }

    public long capacity() {
        return this.capacity;
    }

    public HeaderField getEntry(int index) {
        if (index <= 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = this.head - index;
        if (i < 0) {
            return this.headerFields[i + this.headerFields.length];
        }
        return this.headerFields[i];
    }

    public void add(HeaderField header) {
        int headerSize = header.size();
        if ((long)headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.capacity - this.size < (long)headerSize) {
            this.remove();
        }
        this.headerFields[this.head++] = header;
        this.size += (long)header.size();
        if (this.head == this.headerFields.length) {
            this.head = 0;
        }
    }

    public HeaderField remove() {
        HeaderField removed = this.headerFields[this.tail];
        if (removed == null) {
            return null;
        }
        this.size -= (long)removed.size();
        this.headerFields[this.tail++] = null;
        if (this.tail == this.headerFields.length) {
            this.tail = 0;
        }
        return removed;
    }

    public void clear() {
        while (this.tail != this.head) {
            this.headerFields[this.tail++] = null;
            if (this.tail != this.headerFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0L;
    }

    public void setCapacity(long capacity) {
        if (capacity < 0L || capacity > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("capacity is invalid: " + capacity);
        }
        if (this.capacity == capacity) {
            return;
        }
        this.capacity = capacity;
        if (capacity == 0L) {
            this.clear();
        } else {
            while (this.size > capacity) {
                this.remove();
            }
        }
        int maxEntries = (int)(capacity / 32L);
        if (capacity % 32L != 0L) {
            ++maxEntries;
        }
        if (this.headerFields != null && this.headerFields.length == maxEntries) {
            return;
        }
        HeaderField[] tmp = new HeaderField[maxEntries];
        int len = this.length();
        int cursor = this.tail;
        for (int i = 0; i < len; ++i) {
            HeaderField entry;
            tmp[i] = entry = this.headerFields[cursor++];
            if (cursor != this.headerFields.length) continue;
            cursor = 0;
        }
        this.tail = 0;
        this.head = this.tail + len;
        this.headerFields = tmp;
    }
}

