/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.shared.crypto.checksum;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumEngine;
import org.apache.hadoop.hbase.shaded.org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;

class RsaMd5Checksum
implements ChecksumEngine {
    RsaMd5Checksum() {
    }

    @Override
    public ChecksumType checksumType() {
        return ChecksumType.RSA_MD5;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, byte[] key, KeyUsage usage) {
        try {
            MessageDigest digester = MessageDigest.getInstance(LdapSecurityConstants.HASH_METHOD_MD5.getAlgorithm());
            return digester.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }
}

