/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Master {
    private static final Log LOG = LogFactory.getLog(Master.class);

    public static String getMasterUserName(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            return conf.get("mapreduce.jobtracker.kerberos.principal");
        }
        return conf.get("yarn.resourcemanager.principal");
    }

    public static InetSocketAddress getMasterAddress(Configuration conf) {
        String framework = conf.get("mapreduce.framework.name", "yarn");
        if (framework.equals("classic")) {
            String masterAddress = conf.get("mapreduce.jobtracker.address", "localhost:8012");
            return NetUtils.createSocketAddr(masterAddress, 8012, "mapreduce.jobtracker.address");
        }
        if (framework.equals("yarn") && HAUtil.isHAEnabled(conf)) {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
                String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
                if (rmIds != null && rmIds.length > 0) {
                    yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
                } else {
                    LOG.warn((Object)"RM_HA_IDS is not configured when RM HA is enabled");
                }
            }
            return yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        }
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterHostname = Master.getMasterAddress(conf).getHostName();
        return SecurityUtil.getServerPrincipal(Master.getMasterUserName(conf), masterHostname);
    }

    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

