/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExecutorHelper {
    private static final Log LOG = LogFactory.getLog(ExecutorHelper.class);

    static void logThrowableFromAfterExecute(Runnable r, Throwable t) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("afterExecute in thread: " + Thread.currentThread().getName() + ", runnable type: " + r.getClass().getName()));
        }
        if (t == null && r instanceof Future && ((Future)((Object)r)).isDone()) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (ExecutionException ee) {
                LOG.warn((Object)("Execution exception when running task in " + Thread.currentThread().getName()));
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Thread (" + Thread.currentThread() + ") interrupted: "), (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
        }
        if (t != null) {
            LOG.warn((Object)("Caught exception in thread " + Thread.currentThread().getName() + ": "), t);
        }
    }

    private ExecutorHelper() {
    }
}

