/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PreemptionResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PreemptionContractPBImpl
extends PreemptionContract {
    YarnProtos.PreemptionContractProto proto = YarnProtos.PreemptionContractProto.getDefaultInstance();
    YarnProtos.PreemptionContractProto.Builder builder = null;
    boolean viaProto = false;
    private Set<PreemptionContainer> containers;
    private List<PreemptionResourceRequest> resources;

    public PreemptionContractPBImpl() {
        this.builder = YarnProtos.PreemptionContractProto.newBuilder();
    }

    public PreemptionContractPBImpl(YarnProtos.PreemptionContractProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.PreemptionContractProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((PreemptionContractPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.resources != null) {
            this.addResourcesToProto();
        }
        if (this.containers != null) {
            this.addContainersToProto();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.PreemptionContractProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized Set<PreemptionContainer> getContainers() {
        this.initPreemptionContainers();
        return this.containers;
    }

    @Override
    public synchronized void setContainers(Set<PreemptionContainer> containers) {
        if (null == containers) {
            this.builder.clearContainer();
        }
        this.containers = containers;
    }

    @Override
    public synchronized List<PreemptionResourceRequest> getResourceRequest() {
        this.initPreemptionResourceRequests();
        return this.resources;
    }

    @Override
    public synchronized void setResourceRequest(List<PreemptionResourceRequest> req) {
        if (null == this.resources) {
            this.builder.clearResource();
        }
        this.resources = req;
    }

    private void initPreemptionResourceRequests() {
        if (this.resources != null) {
            return;
        }
        YarnProtos.PreemptionContractProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.PreemptionResourceRequestProto> list = p.getResourceList();
        this.resources = new ArrayList<PreemptionResourceRequest>();
        for (YarnProtos.PreemptionResourceRequestProto rr : list) {
            this.resources.add(this.convertFromProtoFormat(rr));
        }
    }

    private void addResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearResource();
        if (null == this.resources) {
            return;
        }
        Iterable<YarnProtos.PreemptionResourceRequestProto> iterable = new Iterable<YarnProtos.PreemptionResourceRequestProto>(){

            @Override
            public Iterator<YarnProtos.PreemptionResourceRequestProto> iterator() {
                return new Iterator<YarnProtos.PreemptionResourceRequestProto>(){
                    Iterator<PreemptionResourceRequest> iter;
                    {
                        this.iter = PreemptionContractPBImpl.this.resources.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.PreemptionResourceRequestProto next() {
                        return PreemptionContractPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllResource((Iterable<? extends YarnProtos.PreemptionResourceRequestProto>)iterable);
    }

    private void initPreemptionContainers() {
        if (this.containers != null) {
            return;
        }
        YarnProtos.PreemptionContractProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.PreemptionContainerProto> list = p.getContainerList();
        this.containers = new HashSet<PreemptionContainer>();
        for (YarnProtos.PreemptionContainerProto c : list) {
            this.containers.add(this.convertFromProtoFormat(c));
        }
    }

    private void addContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainer();
        if (null == this.containers) {
            return;
        }
        Iterable<YarnProtos.PreemptionContainerProto> iterable = new Iterable<YarnProtos.PreemptionContainerProto>(){

            @Override
            public Iterator<YarnProtos.PreemptionContainerProto> iterator() {
                return new Iterator<YarnProtos.PreemptionContainerProto>(){
                    Iterator<PreemptionContainer> iter;
                    {
                        this.iter = PreemptionContractPBImpl.this.containers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.PreemptionContainerProto next() {
                        return PreemptionContractPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainer((Iterable<? extends YarnProtos.PreemptionContainerProto>)iterable);
    }

    private PreemptionContainerPBImpl convertFromProtoFormat(YarnProtos.PreemptionContainerProto p) {
        return new PreemptionContainerPBImpl(p);
    }

    private YarnProtos.PreemptionContainerProto convertToProtoFormat(PreemptionContainer t) {
        return ((PreemptionContainerPBImpl)t).getProto();
    }

    private PreemptionResourceRequestPBImpl convertFromProtoFormat(YarnProtos.PreemptionResourceRequestProto p) {
        return new PreemptionResourceRequestPBImpl(p);
    }

    private YarnProtos.PreemptionResourceRequestProto convertToProtoFormat(PreemptionResourceRequest t) {
        return ((PreemptionResourceRequestPBImpl)t).getProto();
    }
}

