/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class JDDataSourceURL
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String PROTOCOL_ = "jdbc";
    private static final String SUB_PROTOCOL_ = "as400";
    private static final String NATIVE_SUB_PROTOCOL_ = "db2";
    private boolean extraPathSpecified_;
    private boolean portSpecified_;
    private Properties properties_;
    private String schema_;
    private String serverName_;
    private String url_;
    private boolean valid_;
    private String secondaryUrl_;
    private transient int portNumber_ = 0;

    public JDDataSourceURL(String string) {
        this.extraPathSpecified_ = false;
        this.portSpecified_ = false;
        this.properties_ = new Properties();
        this.schema_ = "";
        this.secondaryUrl_ = "";
        this.serverName_ = "";
        this.url_ = string;
        this.valid_ = false;
        if (string != null) {
            this.parseURL(string);
            if (this.valid_) {
                if (((Hashtable)this.properties_).containsKey("secondary URL")) {
                    this.secondaryUrl_ = (String)((Hashtable)this.properties_).get("secondary URL");
                }
                if (this.secondaryUrl_.indexOf("\\;") != -1) {
                    StringBuffer stringBuffer = new StringBuffer(this.secondaryUrl_.length());
                    int n = 32;
                    for (int i = this.secondaryUrl_.length() - 1; i > -1; --i) {
                        char c = this.secondaryUrl_.charAt(i);
                        if (c != '\\' || n != 59) {
                            stringBuffer.insert(0, c);
                        }
                        n = c;
                    }
                    this.secondaryUrl_ = stringBuffer.toString();
                    ((Hashtable)this.properties_).put("secondary URL", this.secondaryUrl_);
                }
            }
        }
    }

    public JDDataSourceURL(JDDataSourceURL jDDataSourceURL, String string, String string2) {
        this.extraPathSpecified_ = jDDataSourceURL.extraPathSpecified_;
        this.properties_ = (Properties)((Hashtable)jDDataSourceURL.properties_).clone();
        this.schema_ = jDDataSourceURL.schema_;
        this.valid_ = jDDataSourceURL.valid_;
        this.secondaryUrl_ = jDDataSourceURL.secondaryUrl_;
        this.serverName_ = string;
        int n = 0;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        if (n == 0) {
            this.portSpecified_ = false;
            this.portNumber_ = 0;
        } else {
            this.portSpecified_ = true;
            this.portNumber_ = n;
        }
        this.regenerateUrl();
    }

    void regenerateUrl() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:as400:");
        stringBuffer.append(this.serverName_);
        if (this.portSpecified_) {
            stringBuffer.append(":");
            stringBuffer.append(this.portNumber_);
        }
        if (this.schema_ != null && this.schema_.length() > 0) {
            stringBuffer.append("/");
            stringBuffer.append(this.schema_);
        }
        Enumeration enumeration = ((Hashtable)this.properties_).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.properties_.getProperty(string);
            stringBuffer.append(";");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
        }
        this.url_ = stringBuffer.toString();
    }

    String getNativeURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PROTOCOL_);
        stringBuffer.append(':');
        stringBuffer.append(NATIVE_SUB_PROTOCOL_);
        stringBuffer.append(':');
        stringBuffer.append("LOCALHOST");
        String string = this.properties_.getProperty("user");
        String string2 = this.properties_.getProperty("password");
        if (string != null) {
            stringBuffer.append(";user=" + string);
        }
        if (string2 != null) {
            stringBuffer.append(";password=" + string2);
        }
        Enumeration enumeration = ((Hashtable)this.properties_).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            stringBuffer.append(";" + string3 + "=" + this.properties_.getProperty(string3));
        }
        return stringBuffer.toString();
    }

    Properties getProperties() {
        return this.properties_;
    }

    public String getSchema() throws SQLException {
        int n = this.schema_.length();
        if (n > 128) {
            return null;
        }
        return this.schema_;
    }

    String getSecondaryURL() {
        return this.secondaryUrl_;
    }

    public String getServerName() {
        return this.serverName_;
    }

    private static int indexOfEither(String string, String string2, String string3, int n) {
        int n2 = string.indexOf(string2, n);
        int n3 = string.indexOf(string3, n);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return Math.min(n2, n3);
    }

    boolean isExtraPathSpecified() {
        return this.extraPathSpecified_;
    }

    public boolean isPortSpecified() {
        return this.portSpecified_;
    }

    public boolean isValid() {
        return this.valid_;
    }

    private void parseURL(String string) {
        int n = string.length();
        int n2 = string.indexOf(":");
        if (n2 == -1) {
            return;
        }
        if (!string.substring(0, n2).equalsIgnoreCase(PROTOCOL_)) {
            return;
        }
        int n3 = JDDataSourceURL.indexOfEither(string, ":", ";", n2 + 1);
        if (n3 == -1) {
            n3 = n;
        }
        if (!string.substring(n2 + 1, n3).equalsIgnoreCase(SUB_PROTOCOL_)) {
            return;
        }
        this.valid_ = true;
        String string2 = n3 == n ? "" : (string.charAt(n3) == ':' ? string.substring(n3 + 1) : string.substring(n3));
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        while (n5 != -1) {
            int n8;
            String string3;
            n5 = string2.indexOf(59, n7);
            if (n5 == -1) {
                string3 = string2.substring(n6 + 1);
            } else {
                if (n5 > 0 && string2.charAt(n5 - 1) == '\\') {
                    n7 = n5 + 1;
                    continue;
                }
                string3 = string2.substring(n6 + 1, n5);
            }
            int n9 = -1;
            if (string3.indexOf(34) != -1) {
                if (string3.endsWith("\"")) {
                    n9 = n5 - 1;
                } else {
                    n9 = string2.indexOf(34, n5);
                    string3 = string3 + string2.substring(n5, n9 + 1);
                    n5 = string2.indexOf(59, n9);
                }
            }
            if (++n4 == 1) {
                int n10;
                if (string3.length() >= 2 && string3.substring(0, 2).equals("//")) {
                    string3 = string3.substring(2);
                }
                if ((n8 = string3.indexOf(47)) == -1) {
                    this.serverName_ = string3;
                } else {
                    this.serverName_ = string3.substring(0, n8);
                    this.schema_ = string3.substring(n8 + 1);
                }
                boolean bl = false;
                if (this.serverName_.length() > 0 && this.serverName_.charAt(0) == '[' && (n10 = this.serverName_.indexOf(93)) > 0) {
                    int n11 = this.serverName_.indexOf(58, n10);
                    if (n11 != -1) {
                        this.portSpecified_ = true;
                        this.setPortNumber(n11);
                    }
                    this.serverName_ = this.serverName_.substring(1, n10);
                    bl = true;
                }
                if (!bl && (n10 = this.serverName_.indexOf(58)) != -1) {
                    this.portSpecified_ = true;
                    this.setPortNumber(n10);
                    this.serverName_ = this.serverName_.substring(0, n10);
                }
                if ((n10 = this.schema_.indexOf(47)) != -1 && n9 == -1) {
                    this.schema_ = this.schema_.substring(0, n10);
                    this.extraPathSpecified_ = true;
                }
            } else {
                String string4;
                String string5;
                n8 = string3.indexOf(61);
                if (n8 == -1) {
                    string5 = string3.trim();
                    string4 = "";
                } else {
                    string5 = string3.substring(0, n8).trim();
                    string4 = string3.substring(n8 + 1).trim();
                }
                ((Hashtable)this.properties_).put(string5, string4);
            }
            n6 = n5;
            n7 = n6 + 1;
        }
    }

    private void setPortNumber(int n) {
        try {
            this.portNumber_ = Integer.parseInt(this.serverName_.substring(n + 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPortNumber() {
        return this.portNumber_;
    }

    public String toString() {
        return this.url_;
    }
}

