/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserGroup;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUser;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class UserPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String descriptionText_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String sessionStartupTabText_ = ResourceLoader.getText("TAB_SESSION_STARTUP");
    private static final String displaySessionTabText_ = ResourceLoader.getText("TAB_DISPLAY_SESSION");
    private static final String outputTabText_ = ResourceLoader.getText("TAB_OUTPUT");
    private static final String internationalTabText_ = ResourceLoader.getText("TAB_INTERNATIONAL");
    private static final String otherTabText_ = ResourceLoader.getText("TAB_OTHER");
    private static final String securityTabText_ = ResourceLoader.getText("TAB_SECURITY");
    private static final String groupInformationTabText_ = ResourceLoader.getText("TAB_GROUP_INFORMATION");
    private static final String groupProfileNameText_ = ResourceLoader.getText("USER_GROUP_PROFILE_NAME") + " : ";
    private static final String groupIDNumberText_ = ResourceLoader.getText("USER_GROUP_ID_NUMBER") + " : ";
    private static final String groupAuthorityText_ = ResourceLoader.getText("USER_GROUP_AUTHORITY") + " : ";
    private static final String groupAuthorityTypeText_ = ResourceLoader.getText("USER_GROUP_AUTHORITY_TYPE") + " : ";
    private static final String groupHasMemberText_ = ResourceLoader.getText("USER_GROUP_HAS_MEMBER");
    private static final String groupMembersText_ = ResourceLoader.getText("USER_GROUPS_MEMBERS") + " : ";
    private static final String languageIDText_ = ResourceLoader.getText("USER_LANGUAGE_ID") + " : ";
    private static final String countryIDText_ = ResourceLoader.getText("USER_COUNTRY_ID") + " : ";
    private static final String codedCharacterSetIDText_ = ResourceLoader.getText("USER_CODED_CHARACTER_SET_ID") + " : ";
    private static final String localePathNameText_ = ResourceLoader.getText("USER_LOCALE_PATH_NAME") + " : ";
    private static final String localeJobAttributesText_ = ResourceLoader.getText("USER_LOCALE_JOB_ATTRIBUTES") + " : ";
    private static final String customText_ = ResourceLoader.getText("USER_CUSTOM") + " : ";
    private static final String outputQueueText_ = ResourceLoader.getText("USER_OUTPUT_QUEUE") + ": ";
    private static final String messageQueueText_ = ResourceLoader.getText("USER_MESSAGE_QUEUE") + ": ";
    private static final String printDeviceText_ = ResourceLoader.getText("USER_PRINT_DEVICE") + ": ";
    private static final String messageDeliveryText_ = ResourceLoader.getText("USER_MESSAGE_DELIVERY") + ": ";
    private static final String messageSeverityLevelText_ = ResourceLoader.getText("USER_MESSAGE_SEVERITY_LEVEL") + ": ";
    private static final String ownerText_ = ResourceLoader.getText("USER_OWNER") + ": ";
    private static final String objectAuditingValueText_ = ResourceLoader.getText("USER_OBJECT_AUDITING_VALUE") + ": ";
    private static final String userActionAuditLevelText_ = ResourceLoader.getText("USER_ACTION_AUDIT_LEVEL") + ": ";
    private static final String specialAuthorityText_ = ResourceLoader.getText("USER_SPECIAL_AUTHORITY") + ": ";
    private static final String sortSequeneceTableText_ = ResourceLoader.getText("USER_SORT_SEQUENCE_TABLE") + ": ";
    private static final String storageUsedText_ = ResourceLoader.getText("USER_STORAGE_USED") + ": ";
    private static final String supplementalGroupsNumberText_ = ResourceLoader.getText("USER_SUPPLEMENTAL_GROUPS_NUMBER") + ": ";
    private static final String supplementalGroupsText_ = ResourceLoader.getText("USER_SUPPLEMENTAL_GROUPS") + ": ";
    private static final String specialEnvironmentText_ = ResourceLoader.getText("USER_SPECIAL_ENVIRONMENT") + ": ";
    private static final String daysUntilPasswordExpireText_ = ResourceLoader.getText("USER_DAYS_UNTIL_PASSWORD_EXPIRE") + " : ";
    private static final String isNoPasswordText_ = ResourceLoader.getText("USER_IS_NO_PASSWORD") + " : ";
    private static final String isPasswordSetExpireText_ = ResourceLoader.getText("USER_IS_PASSWORD_SET_EXPIRE") + " : ";
    private static final String isWithDigitalCertificatesText_ = ResourceLoader.getText("USER_IS_WITH_DIGITAL_CERTIFICATES") + " : ";
    private static final String passwordExpireDateText_ = ResourceLoader.getText("USER_PASSWORD_EXPIRE_DATE") + " : ";
    private static final String passwordExpirationIntervalText_ = ResourceLoader.getText("USER_PASSWORD_EXPIRATION_INTERVAL") + " : ";
    private static final String passwordLastChangedDateText_ = ResourceLoader.getText("USER_PASSWORD_LAST_CHANGED_DATE") + " : ";
    private static final String previousSignedOnDateText_ = ResourceLoader.getText("USER_PREVIOUS_SIGNED_ON_DATE") + " : ";
    private static final String signedOnAttemptsNotValidText_ = ResourceLoader.getText("USER_SIGNED_ON_ATTEMPTS_NOT_VALID") + " : ";
    private static final String assistanceLevelText_ = ResourceLoader.getText("USER_ASSISTANCE_LEVEL") + " : ";
    private static final String attentionProgramNameText_ = ResourceLoader.getText("USER_ATTENTION_PROGRAM_NAME") + " : ";
    private static final String limitCapabilitiesText_ = ResourceLoader.getText("USER_LIMIT_CAPABILITIES") + " : ";
    private static final String initialProgramText_ = ResourceLoader.getText("USER_INITIAL_PROGRAM") + " : ";
    private static final String initialMenuText_ = ResourceLoader.getText("USER_INITIAL_MENU") + " : ";
    private static final String displaySignOnInformationText_ = ResourceLoader.getText("USER_DISPLAY_SIGNON_INFORMATION") + " : ";
    private static final String limitDeviceSessionsText_ = ResourceLoader.getText("USER_LIMIT_DEVICE_SESSIONS") + " : ";
    private static final String accountingCodeText_ = ResourceLoader.getText("USER_ACCOUNTING_CODE") + " : ";
    private static final String currentLibText_ = ResourceLoader.getText("USER_CURRENT_LIB") + " : ";
    private static final String highestSchedulePriorityText_ = ResourceLoader.getText("USER_HIGHEST_SCHEDULE_PRIORITY") + " : ";
    private static final String homeDirectoryText_ = ResourceLoader.getText("USER_HOME_DIRECTORY") + " : ";
    private static final String jobDescriptionNameText_ = ResourceLoader.getText("USER_JOB_DESCRIPTION_NAME") + " : ";
    private static final String maximumAllowedStorageText_ = ResourceLoader.getText("USER_MAXIMUM_ALLOWED_STORAGE") + " : ";
    private static final String statusText_ = ResourceLoader.getText("USER_STATUS") + " : ";
    private static final String userClassNameText_ = ResourceLoader.getText("USER_CLASS_NAME") + " : ";
    private static final String userIDNumberText_ = ResourceLoader.getText("USER_ID_NUMBER") + " : ";
    private static final String userProfileNameText_ = ResourceLoader.getText("USER_PROFILE_NAME") + " : ";
    private static final DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static final DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static final String trueText_ = ResourceLoader.getText("DLG_TRUE");
    private static final String falseText_ = ResourceLoader.getText("DLG_FALSE");
    private VUser object_;
    private User user_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public UserPropertiesPane(VUser vUser, User user) {
        this.object_ = vUser;
        this.user_ = user;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(generalTabText_, null, this.getGeneralTab());
        jTabbedPane.addTab(sessionStartupTabText_, null, this.getSessionStartupTab());
        jTabbedPane.addTab(displaySessionTabText_, null, this.getDisplaySessionTab());
        jTabbedPane.addTab(outputTabText_, null, this.getOutputTab());
        jTabbedPane.addTab(internationalTabText_, null, this.getInternationalTab());
        jTabbedPane.addTab(securityTabText_, null, this.getSecurityTab());
        jTabbedPane.addTab(groupInformationTabText_, null, this.getGroupInformationTab());
        jTabbedPane.addTab(otherTabText_, null, this.getOtherTab());
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    private Component getDisplaySessionTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        String string = this.user_.getAttentionKeyHandlingProgram();
        VUtilities.constrain(attentionProgramNameText_, string, jPanel, gridBagLayout, n++);
        VUtilities.constrain(limitCapabilitiesText_, this.user_.getLimitCapabilities(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(assistanceLevelText_, this.user_.getAssistanceLevel(), jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private Component getGeneralTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(userProfileNameText_, this.object_.getIcon(32, false), 2), new JLabel(this.object_.getText()), jPanel, gridBagLayout, n++);
        VUtilities.constrain(descriptionText_, this.user_.getDescription(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(userClassNameText_, this.user_.getUserClassName(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(userIDNumberText_, Integer.toString(this.user_.getUserIDNumber()), jPanel, gridBagLayout, n++);
        VUtilities.constrain(statusText_, this.user_.getStatus(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(currentLibText_, this.user_.getCurrentLibraryName(), jPanel, gridBagLayout, n++);
        int n2 = this.user_.getMaximumStorageAllowed();
        String string = n2 == -1 ? "*NOMAX" : Integer.toString(n2);
        VUtilities.constrain(maximumAllowedStorageText_, string, jPanel, gridBagLayout, n++);
        VUtilities.constrain(storageUsedText_, Integer.toString(this.user_.getStorageUsed()), jPanel, gridBagLayout, n++);
        VUtilities.constrain(highestSchedulePriorityText_, Integer.toString(this.user_.getHighestSchedulingPriority()), jPanel, gridBagLayout, n++);
        VUtilities.constrain(accountingCodeText_, this.user_.getAccountingCode(), jPanel, gridBagLayout, n++);
        String string2 = this.user_.getJobDescription();
        VUtilities.constrain(jobDescriptionNameText_, string2, jPanel, gridBagLayout, n++);
        VUtilities.constrain(homeDirectoryText_, this.user_.getHomeDirectory(), jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private Component getGroupInformationTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(groupProfileNameText_, this.user_.getGroupProfileName(), jPanel, gridBagLayout, n++);
        String string = "";
        int n2 = this.user_.getGroupIDNumber();
        string = n2 == 0 ? "*NONE" : "" + n2;
        VUtilities.constrain(groupIDNumberText_, string, jPanel, gridBagLayout, n++);
        VUtilities.constrain(groupAuthorityText_, this.user_.getGroupAuthority(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(groupAuthorityTypeText_, this.user_.getGroupAuthorityType(), jPanel, gridBagLayout, n++);
        String string2 = falseText_;
        if (this.user_.isGroupHasMember()) {
            string2 = trueText_;
        }
        VUtilities.constrain(groupHasMemberText_, string2, jPanel, gridBagLayout, n++);
        if (this.user_.isGroupHasMember()) {
            Serializable serializable;
            Vector<String> vector = new Vector<String>();
            try {
                serializable = new UserGroup(this.user_.getSystem(), this.user_.getName());
                Enumeration enumeration = ((UserGroup)serializable).getMembers();
                while (enumeration.hasMoreElements()) {
                    String string3 = ((User)enumeration.nextElement()).getUserProfileName();
                    vector.addElement(string3);
                }
            }
            catch (Exception exception) {
                Trace.log(2, "error when retrieve members : " + exception);
                this.errorEventSupport_.fireError(exception);
            }
            serializable = new JList(vector);
            ((JComponent)serializable).setBackground(Color.lightGray);
            VUtilities.constrain(new JLabel(groupMembersText_), (Component)serializable, jPanel, gridBagLayout, n++);
        }
        return jPanel;
    }

    private Component getInternationalTab() {
        int n;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n2 = 0;
        VUtilities.constrain(languageIDText_, this.user_.getLanguageID(), jPanel, gridBagLayout, n2++);
        VUtilities.constrain(countryIDText_, this.user_.getCountryID(), jPanel, gridBagLayout, n2++);
        int n3 = this.user_.getCCSID();
        String string = n3 == -2 ? "QCCSID" : Integer.toString(n3);
        VUtilities.constrain(codedCharacterSetIDText_, string, jPanel, gridBagLayout, n2++);
        VUtilities.constrain(localePathNameText_, this.user_.getLocalePathName(), jPanel, gridBagLayout, n2++);
        VUtilities.constrain(new JLabel(localeJobAttributesText_), jPanel, gridBagLayout, n2++);
        String[] stringArray = this.user_.getLocaleJobAttributes();
        JRadioButton[] jRadioButtonArray = new JRadioButton[3];
        JCheckBox[] jCheckBoxArray = new JCheckBox[6];
        boolean[] blArray = new boolean[]{false, false, false};
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false};
        if (this.searchArray(stringArray, "*NONE")) {
            blArray[0] = true;
        } else if (this.searchArray(stringArray, "*SYSVAL")) {
            blArray[1] = true;
        } else {
            blArray[2] = true;
        }
        String[] stringArray2 = new String[]{"*NONE", "*SYSVAL", "CUSTOM", "*CCSID", "*DATFMT", "*DATSEP", "*DECFMT", "*SRTSEQ", "*TIMSEP"};
        for (n = 0; n < 6; ++n) {
            if (!this.searchArray(stringArray, stringArray2[n + 3])) continue;
            blArray2[n] = true;
        }
        for (n = 0; n < 3; ++n) {
            jRadioButtonArray[n] = new JRadioButton(stringArray2[n], blArray[n]);
            jRadioButtonArray[n].setEnabled(false);
        }
        for (n = 0; n < 2; ++n) {
            VUtilities.constrain(jRadioButtonArray[n], jPanel, gridBagLayout, 1, n2++, 1, 1);
        }
        for (n = 0; n < 6; ++n) {
            jCheckBoxArray[n] = new JCheckBox(stringArray2[n + 3], blArray2[n]);
            jCheckBoxArray[n].setEnabled(false);
        }
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 3; ++i) {
                VUtilities.constrain(jCheckBoxArray[n * 3 + i], jPanel, gridBagLayout, i + 1, n2, 1, 1);
            }
            ++n2;
        }
        return jPanel;
    }

    private Component getOtherTab() {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        String[] stringArray;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n4 = 0;
        VUtilities.constrain(ownerText_, this.user_.getOwner(), jPanel, gridBagLayout, n4++);
        VUtilities.constrain(objectAuditingValueText_, this.user_.getObjectAuditingValue(), jPanel, gridBagLayout, n4++);
        VUtilities.constrain(specialEnvironmentText_, this.user_.getSpecialEnvironment(), jPanel, gridBagLayout, n4++);
        String string = this.user_.getSortSequenceTable();
        VUtilities.constrain(sortSequeneceTableText_, string, jPanel, gridBagLayout, n4++);
        int n5 = this.user_.getSupplementalGroupsNumber();
        String string2 = "";
        string2 = n5 == 0 ? "*NONE" : "" + n5;
        VUtilities.constrain(supplementalGroupsNumberText_, string2, jPanel, gridBagLayout, n4++);
        if (n5 > 0) {
            stringArray = this.user_.getSupplementalGroups();
            object2 = new JList<String>(stringArray);
            object = new JScrollPane((Component)object2);
            n3 = Math.max(1, stringArray.length);
            ((Component)object).setSize(120, 20 * n3);
            VUtilities.constrain(new JLabel(supplementalGroupsText_), (Component)object2, jPanel, gridBagLayout, n4++);
        }
        stringArray = this.user_.getUserActionAuditLevel();
        object2 = new JCheckBox[13];
        object = new boolean[13];
        for (n3 = 0; n3 < 13; ++n3) {
            object[n3] = false;
        }
        String[] stringArray2 = new String[]{"*CMD", "*CREATE", "*DELETE", "*JOBDTA", "*OBJMGT", "*OFCSRV", "*OPTICAL", "*PGMADP", "*SAVRST", "*SECURITY", "*SERVICE", "*SPLFDTA", "*SYSMGT"};
        for (n2 = 0; n2 < 13; ++n2) {
            if (!this.searchArray(stringArray, stringArray2[n2])) continue;
            object[n2] = true;
        }
        for (n2 = 0; n2 < 13; ++n2) {
            object2[n2] = new JCheckBox(stringArray2[n2], (boolean)object[n2]);
            object2[n2].setEnabled(false);
        }
        VUtilities.constrain(new JLabel(userActionAuditLevelText_), jPanel, gridBagLayout, 0, n4++, 1, 1);
        for (n2 = 0; n2 < 4; ++n2) {
            for (int i = 0; i < 3; ++i) {
                VUtilities.constrain(object2[n2 * 3 + i], jPanel, gridBagLayout, i + 1, n4, 1, 1);
            }
            ++n4;
        }
        VUtilities.constrain(object2[12], jPanel, gridBagLayout, 1, n4++, 1, 1);
        String[] stringArray3 = this.user_.getSpecialAuthority();
        JCheckBox[] jCheckBoxArray = new JCheckBox[8];
        for (int i = 0; i < 8; ++i) {
            object[i] = false;
        }
        String[] stringArray4 = new String[]{"*ALLOBJ", "*AUDIT", "*IOSYSCFG", "*JOBCTL", "*SAVSYS", "*SECADM", "*SERVICE", "*SPLCTL"};
        for (n = 0; n < 8; ++n) {
            if (!this.searchArray(stringArray3, stringArray4[n])) continue;
            object[n] = true;
        }
        for (n = 0; n < 8; ++n) {
            jCheckBoxArray[n] = new JCheckBox(stringArray4[n], (boolean)object[n]);
            jCheckBoxArray[n].setEnabled(false);
        }
        VUtilities.constrain(new JLabel(specialAuthorityText_), jPanel, gridBagLayout, 0, n4++, 1, 1);
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 3; ++i) {
                VUtilities.constrain(jCheckBoxArray[n * 3 + i], jPanel, gridBagLayout, i + 1, n4, 1, 1);
            }
            ++n4;
        }
        VUtilities.constrain(jCheckBoxArray[6], jPanel, gridBagLayout, 1, n4, 1, 1);
        VUtilities.constrain(jCheckBoxArray[7], jPanel, gridBagLayout, 2, n4++, 1, 1);
        return jPanel;
    }

    private Component getOutputTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(printDeviceText_, this.user_.getPrintDevice(), jPanel, gridBagLayout, n++);
        String string = this.user_.getOutputQueue();
        VUtilities.constrain(outputQueueText_, string, jPanel, gridBagLayout, n++);
        string = this.user_.getMessageQueue();
        VUtilities.constrain(messageQueueText_, string, jPanel, gridBagLayout, n++);
        VUtilities.constrain(messageDeliveryText_, this.user_.getMessageQueueDeliveryMethod(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(messageSeverityLevelText_, Integer.toString(this.user_.getMessageQueueSeverity()), jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private Component getSecurityTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        String string = "";
        int n2 = this.user_.getPasswordExpirationInterval();
        string = n2 == 0 ? "*SYSVAL" : (n2 == -1 ? "*NOMAX" : "" + n2);
        VUtilities.constrain(passwordExpirationIntervalText_, string, jPanel, gridBagLayout, n++);
        Date date = this.user_.getPasswordExpireDate();
        String string2 = "NONE";
        if (date != null) {
            string2 = dateFormat_.format(date) + " " + timeFormat_.format(date);
        }
        VUtilities.constrain(passwordExpireDateText_, string2, jPanel, gridBagLayout, n++);
        VUtilities.constrain(daysUntilPasswordExpireText_, Integer.toString(this.user_.getDaysUntilPasswordExpire()), jPanel, gridBagLayout, n++);
        date = this.user_.getPasswordLastChangedDate();
        string2 = date != null ? dateFormat_.format(date) + " " + timeFormat_.format(date) : "NONE";
        VUtilities.constrain(passwordLastChangedDateText_, string2, jPanel, gridBagLayout, n++);
        date = this.user_.getPreviousSignedOnDate();
        string2 = date != null ? dateFormat_.format(date) + " " + timeFormat_.format(date) : "NONE";
        VUtilities.constrain(previousSignedOnDateText_, string2, jPanel, gridBagLayout, n++);
        VUtilities.constrain(signedOnAttemptsNotValidText_, Integer.toString(this.user_.getSignedOnAttemptsNotValid()), jPanel, gridBagLayout, n++);
        String string3 = falseText_;
        if (this.user_.isNoPassword()) {
            string3 = trueText_;
        }
        VUtilities.constrain(isNoPasswordText_, string3, jPanel, gridBagLayout, n++);
        string3 = falseText_;
        if (this.user_.isPasswordSetExpire()) {
            string3 = trueText_;
        }
        VUtilities.constrain(isPasswordSetExpireText_, string3, jPanel, gridBagLayout, n++);
        string3 = falseText_;
        if (this.user_.isWithDigitalCertificates()) {
            string3 = trueText_;
        }
        VUtilities.constrain(isWithDigitalCertificatesText_, string3, jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private Component getSessionStartupTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        String string = this.user_.getInitialProgram();
        VUtilities.constrain(initialProgramText_, string, jPanel, gridBagLayout, n++);
        string = this.user_.getInitialMenu();
        VUtilities.constrain(initialMenuText_, string, jPanel, gridBagLayout, n++);
        VUtilities.constrain(displaySignOnInformationText_, this.user_.getDisplaySignOnInformation(), jPanel, gridBagLayout, n++);
        VUtilities.constrain(limitDeviceSessionsText_, this.user_.getLimitDeviceSessions(), jPanel, gridBagLayout, n++);
        return jPanel;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    private boolean searchArray(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

