/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.api.r.JVMObjectId;
import org.apache.spark.api.r.JVMObjectTracker;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class SerDe$ {
    public static SerDe$ MODULE$;
    private Function2<DataInputStream, Object, Object> sqlReadObject;
    private Function2<DataOutputStream, Object, Object> sqlWriteObject;

    static {
        new SerDe$();
    }

    public SerDe$ setSQLReadObject(Function2<DataInputStream, Object, Object> value) {
        this.sqlReadObject = value;
        return this;
    }

    public SerDe$ setSQLWriteObject(Function2<DataOutputStream, Object, Object> value) {
        this.sqlWriteObject = value;
        return this;
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType, jvmObjectTracker);
    }

    public Object readTypedObject(DataInputStream dis, char dataType, JVMObjectTracker jvmObjectTracker) {
        Object object;
        char c = dataType;
        switch (c) {
            case 'n': {
                object = null;
                break;
            }
            case 'i': {
                object = this.readInt(dis);
                break;
            }
            case 'd': {
                object = this.readDouble(dis);
                break;
            }
            case 'b': {
                object = this.readBoolean(dis);
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis, jvmObjectTracker);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'a': {
                object = this.readArray(dis, jvmObjectTracker);
                break;
            }
            case 'l': {
                object = this.readList(dis, jvmObjectTracker);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'j': {
                object = jvmObjectTracker.apply(new JVMObjectId(this.readString(dis)));
                break;
            }
            default: {
                if (this.sqlReadObject == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                Object obj = this.sqlReadObject.apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
                if (obj == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                object = obj;
                break;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        Predef$.MODULE$.assert(bytes[len - 1] == 0);
        String str = new String((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        return in.readInt() != 0;
    }

    public Date readDate(DataInputStream in) {
        Date date;
        block3: {
            try {
                String inStr;
                String string = inStr = this.readString(in);
                String string2 = "NA";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    date = null;
                    break block3;
                }
                date = Date.valueOf(inStr);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                date = null;
            }
        }
        return date;
    }

    public Timestamp readTime(DataInputStream in) {
        Timestamp timestamp;
        block3: {
            try {
                double seconds = in.readDouble();
                if (Double.isNaN(seconds)) {
                    timestamp = null;
                    break block3;
                }
                long sec = (long)Math.floor(seconds);
                Timestamp t = new Timestamp(sec * 1000L);
                t.setNanos((int)((seconds - (double)sec) * 1.0E9));
                timestamp = t;
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                timestamp = null;
            }
        }
        return timestamp;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$1 -> SerDe$.MODULE$.readBytes(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> MODULE$.readInt(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.readDouble(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.readBoolean(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$5 -> SerDe$.MODULE$.readString(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArray(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        Object object;
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            case 'i': {
                object = this.readIntArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'j': {
                object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis))).map((Function1 & Serializable & scala.Serializable)x -> jvmObjectTracker.apply(new JVMObjectId((String)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'a': {
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$6 -> SerDe$.MODULE$.readArray(dis, jvmObjectTracker), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
                break;
            }
            case 'l': {
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$7 -> SerDe$.MODULE$.readList(dis, jvmObjectTracker), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
                break;
            }
            default: {
                if (this.sqlReadObject == null) {
                    throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType).toString());
                }
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$8 -> SerDe$.$anonfun$readArray$4(dis, arrType, BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
                break;
            }
        }
        return object;
    }

    public Object[] readList(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        int len = this.readInt(dis);
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$9 -> SerDe$.MODULE$.readObject(dis, jvmObjectTracker), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public java.util.Map<Object, Object> readMap(DataInputStream in, JVMObjectTracker jvmObjectTracker) {
        java.util.Map<Object, Object> map;
        int len = this.readInt(in);
        if (len > 0) {
            Object[] keys = (Object[])this.readArray(in, jvmObjectTracker);
            Object[] values = this.readList(in, jvmObjectTracker);
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(keys)).zip((GenIterable)Predef$.MODULE$.wrapRefArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).asJava();
        } else {
            map = new HashMap<Object, Object>();
        }
        return map;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        String string = typeStr;
        if ("void".equals(string)) {
            dos.writeByte(110);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("character".equals(string)) {
            dos.writeByte(99);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("double".equals(string)) {
            dos.writeByte(100);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("integer".equals(string)) {
            dos.writeByte(105);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("logical".equals(string)) {
            dos.writeByte(98);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("date".equals(string)) {
            dos.writeByte(68);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("time".equals(string)) {
            dos.writeByte(116);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("raw".equals(string)) {
            dos.writeByte(114);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("array".equals(string)) {
            dos.writeByte(97);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("list".equals(string)) {
            dos.writeByte(108);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("map".equals(string)) {
            dos.writeByte(101);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("jobj".equals(string)) {
            dos.writeByte(106);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(typeStr).toString());
        }
    }

    private void writeKeyValue(DataOutputStream dos, Object key, Object value, JVMObjectTracker jvmObjectTracker) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid map key type: ").append(key.getClass().getName()).toString());
        }
        this.writeString(dos, (String)key);
        this.writeObject(dos, value, jvmObjectTracker);
    }

    public void writeObject(DataOutputStream dos, Object obj, JVMObjectTracker jvmObjectTracker) {
        if (obj == null) {
            this.writeType(dos, "void");
        } else {
            Object value = obj instanceof WrappedArray ? ((WrappedArray)obj).toArray(ClassTag$.MODULE$.apply(Object.class)) : obj;
            Object object = value;
            if (object instanceof Character) {
                Character c = (Character)object;
                this.writeType(dos, "character");
                this.writeString(dos, c.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                this.writeType(dos, "character");
                this.writeString(dos, string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                Long l = (Long)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                Float f = (Float)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Float2float(f));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                Double d = (Double)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                Byte by = (Byte)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                Short s = (Short)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Short2short(s));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                this.writeType(dos, "logical");
                this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Date) {
                Date date = (Date)object;
                this.writeType(dos, "date");
                this.writeDate(dos, date);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Time) {
                Time time = (Time)object;
                this.writeType(dos, "time");
                this.writeTime(dos, time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                this.writeType(dos, "time");
                this.writeTime(dos, timestamp);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                this.writeType(dos, "raw");
                this.writeBytes(dos, byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                this.writeType(dos, "array");
                this.writeStringArr(dos, (String[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(cArray)).map((Function1 & Serializable & scala.Serializable)x$10 -> SerDe$.$anonfun$writeObject$1(BoxesRunTime.unboxToChar((Object)x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, (int[])new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(sArray)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, nArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lArray)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$12 -> x$12, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(fArray)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$13 -> x$13, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, dArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                this.writeType(dos, "array");
                this.writeBooleanArr(dos, blArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.writeType(dos, "list");
                this.writeInt(dos, objectArray.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(objectArray)).foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    SerDe$.MODULE$.writeObject(dos, elem, jvmObjectTracker);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Properties) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value, jvmObjectTracker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value2 = entry.getValue();
                    this.writeKeyValue(dos, key, value2, jvmObjectTracker);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SerDe$.$anonfun$writeObject$6(dos, jvmObjectTracker, x0$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                boolean sqlWriteSucceeded;
                boolean bl = sqlWriteSucceeded = this.sqlWriteObject != null && BoxesRunTime.unboxToBoolean((Object)this.sqlWriteObject.apply((Object)dos, value));
                if (!sqlWriteSucceeded) {
                    this.writeType(dos, "jobj");
                    this.writeJObj(dos, value, jvmObjectTracker);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        }
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        int intValue = value ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeString(out, value.toString());
    }

    public void writeTime(DataOutputStream out, Time value) {
        out.writeDouble((double)value.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value) {
        out.writeDouble((double)(value.getTime() / 1000L) + (double)value.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeJObj(DataOutputStream out, Object value, JVMObjectTracker jvmObjectTracker) {
        String id;
        JVMObjectId jVMObjectId = jvmObjectTracker.addAndGetId(value);
        if (jVMObjectId == null) {
            throw new MatchError((Object)jVMObjectId);
        }
        String string = id = jVMObjectId.id();
        String id2 = string;
        this.writeString(out, id2);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> out.writeInt(v));
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(value)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> out.writeDouble(v));
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            SerDe$.MODULE$.writeBoolean(out, BoxesRunTime.unboxToBoolean((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        this.writeType(out, "character");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            SerDe$.MODULE$.writeString(out, v);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$readArray$4(DataInputStream dis$1, char arrType$1, int x$8) {
        void var3_3;
        Object obj = SerDe$.MODULE$.sqlReadObject.apply((Object)dis$1, (Object)BoxesRunTime.boxToCharacter((char)arrType$1));
        if (obj == null) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType$1).toString());
        }
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$writeObject$1(char x$10) {
        return ((Object)BoxesRunTime.boxToCharacter((char)x$10)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeObject$6(DataOutputStream dos$1, JVMObjectTracker jvmObjectTracker$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object k1 = tuple2._1();
        Object v1 = tuple2._2();
        MODULE$.writeKeyValue(dos$1, k1, v1, jvmObjectTracker$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SerDe$() {
        MODULE$ = this;
    }
}

