/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node4;
import org.roaringbitmap.art.Node48;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.longlong.LongUtils;

public class Node16
extends Node {
    long firstV = 0L;
    long secondV = 0L;
    Node[] children = new Node[16];

    public Node16(int compressionLength) {
        super(NodeType.NODE16, compressionLength);
    }

    @Override
    public int getChildPos(byte k) {
        byte[] firstBytes = LongUtils.toBDBytes(this.firstV);
        if (this.count <= 8) {
            return Node.binarySearch(firstBytes, 0, this.count, k);
        }
        int pos = Node.binarySearch(firstBytes, 0, 8, k);
        if (pos != -1) {
            return pos;
        }
        byte[] secondBytes = LongUtils.toBDBytes(this.secondV);
        pos = Node.binarySearch(secondBytes, 0, this.count - 8, k);
        if (pos != -1) {
            return 8 + pos;
        }
        return -1;
    }

    @Override
    public Node getChild(int pos) {
        return this.children[pos];
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        this.children[pos] = freshOne;
    }

    @Override
    public int getMinPos() {
        return 0;
    }

    @Override
    public int getNextLargerPos(int pos) {
        if (pos == -1) {
            return 0;
        }
        return ++pos < this.count ? pos : -1;
    }

    @Override
    public int getMaxPos() {
        return this.count - 1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            return this.count - 1;
        }
        return --pos >= 0 ? pos : -1;
    }

    public static Node insert(Node node, Node child, byte key) {
        Node16 currentNode16 = (Node16)node;
        if (currentNode16.count < 8) {
            byte[] bytes = LongUtils.toBDBytes(currentNode16.firstV);
            bytes[currentNode16.count] = key;
            currentNode16.firstV = LongUtils.fromBDBytes(bytes);
            currentNode16.children[currentNode16.count] = child;
            currentNode16.count = (short)(currentNode16.count + 1);
            Node16.sortSmallByteArray(bytes, currentNode16.children, 0, currentNode16.count - 1);
            currentNode16.firstV = LongUtils.fromBDBytes(bytes);
            return currentNode16;
        }
        if (currentNode16.count < 16) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putLong(currentNode16.firstV);
            byteBuffer.putLong(currentNode16.secondV);
            byteBuffer.put((int)currentNode16.count, key);
            currentNode16.children[currentNode16.count] = child;
            currentNode16.count = (short)(currentNode16.count + 1);
            Node16.sortSmallByteArray(byteBuffer.array(), currentNode16.children, 0, currentNode16.count - 1);
            currentNode16.firstV = byteBuffer.getLong(0);
            currentNode16.secondV = byteBuffer.getLong(8);
            return currentNode16;
        }
        Node48 node48 = new Node48(currentNode16.prefixLength);
        byte[] firtBytes = LongUtils.toBDBytes(currentNode16.firstV);
        for (int i = 0; i < 8; ++i) {
            byte v = firtBytes[i];
            int unsignedIdx = Byte.toUnsignedInt(v);
            Node48.setOneByte(unsignedIdx, (byte)i, node48.childIndex);
            node48.children[i] = currentNode16.children[i];
        }
        byte[] secondBytes = LongUtils.toBDBytes(currentNode16.secondV);
        for (int i = 8; i < currentNode16.count; ++i) {
            byte v = secondBytes[i - 8];
            int unsignedIdx = Byte.toUnsignedInt(v);
            Node48.setOneByte(unsignedIdx, (byte)i, node48.childIndex);
            node48.children[i] = currentNode16.children[i];
        }
        Node16.copyPrefix(currentNode16, node48);
        node48.count = currentNode16.count;
        Node freshOne = Node48.insert(node48, child, key);
        return freshOne;
    }

    @Override
    public Node remove(int pos) {
        this.children[pos] = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        byte[] bytes = byteBuffer.putLong(this.firstV).putLong(this.secondV).array();
        System.arraycopy(bytes, pos + 1, bytes, pos, this.count - pos);
        System.arraycopy(this.children, pos + 1, this.children, pos, this.count - pos);
        this.firstV = byteBuffer.getLong(0);
        this.secondV = byteBuffer.getLong(8);
        this.count = (short)(this.count - 1);
        if (this.count <= 3) {
            Node4 node4 = new Node4(this.prefixLength);
            node4.key = (int)(this.firstV >> 32);
            System.arraycopy(this.children, 0, node4.children, 0, this.count);
            node4.count = this.count;
            Node16.copyPrefix(this, node4);
            return node4;
        }
        return this;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(Long.reverseBytes(this.firstV));
        dataOutput.writeLong(Long.reverseBytes(this.secondV));
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putLong(this.firstV);
        byteBuffer.putLong(this.secondV);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        this.firstV = Long.reverseBytes(dataInput.readLong());
        this.secondV = Long.reverseBytes(dataInput.readLong());
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        this.firstV = byteBuffer.getLong();
        this.secondV = byteBuffer.getLong();
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 16;
    }

    @Override
    public void replaceChildren(Node[] children) {
        int pos = this.getNextLargerPos(-1);
        int offset = 0;
        while (pos != -1) {
            this.children[pos] = children[offset];
            pos = this.getNextLargerPos(pos);
            ++offset;
        }
    }

    private static void sortSmallByteArray(byte[] key, Node[] children, int left, int right) {
        int i;
        int j = i = left;
        while (i < right) {
            byte ai = key[i + 1];
            Node child = children[i + 1];
            int unsignedByteAi = Byte.toUnsignedInt(ai);
            while (unsignedByteAi < Byte.toUnsignedInt(key[j])) {
                key[j + 1] = key[j];
                children[j + 1] = children[j];
                if (j-- != left) continue;
            }
            key[j + 1] = ai;
            children[j + 1] = child;
            j = ++i;
        }
    }
}

