/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.UnboundedSource;

class SyntheticRecordsCheckpoint
implements UnboundedSource.CheckpointMark {
    private static final Coder<Long> LONG_CODER = BigEndianLongCoder.of();
    public static final Coder<SyntheticRecordsCheckpoint> CODER = new AtomicCoder<SyntheticRecordsCheckpoint>(){

        public void encode(SyntheticRecordsCheckpoint value, OutputStream outStream) throws IOException {
            LONG_CODER.encode((Object)value.startPosition, outStream);
            LONG_CODER.encode((Object)value.endPosition, outStream);
        }

        public SyntheticRecordsCheckpoint decode(InputStream inStream) throws IOException {
            long startPosition = (Long)LONG_CODER.decode(inStream);
            long endPosition = (Long)LONG_CODER.decode(inStream);
            return new SyntheticRecordsCheckpoint(startPosition, endPosition);
        }
    };
    private final long startPosition;
    private final long endPosition;

    public SyntheticRecordsCheckpoint(long startPosition, long endPosition) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public void finalizeCheckpoint() {
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.endPosition;
    }
}

