/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ProcessContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.NoOpStepContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SparkSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.SideInputBroadcast;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.CachedSideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.LinkedListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import scala.Tuple2;

public class DoFnFunction<InputT, OutputT>
implements MapPartitionsFunction<WindowedValue<InputT>, Tuple2<TupleTag<?>, WindowedValue<?>>> {
    private final MetricsContainerStepMapAccumulator metricsAccum;
    private final String stepName;
    private final DoFn<InputT, OutputT> doFn;
    private transient boolean wasSetupCalled;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs;
    private final SerializablePipelineOptions serializableOptions;
    private final List<TupleTag<?>> additionalOutputTags;
    private final TupleTag<OutputT> mainOutputTag;
    private final Coder<InputT> inputCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoderMap;
    private final SideInputBroadcast broadcastStateData;
    private DoFnSchemaInformation doFnSchemaInformation;
    private Map<String, PCollectionView<?>> sideInputMapping;

    public DoFnFunction(MetricsContainerStepMapAccumulator metricsAccum, String stepName, DoFn<InputT, OutputT> doFn, WindowingStrategy<?, ?> windowingStrategy, Map<PCollectionView<?>, WindowingStrategy<?, ?>> sideInputs, SerializablePipelineOptions serializableOptions, List<TupleTag<?>> additionalOutputTags, TupleTag<OutputT> mainOutputTag, Coder<InputT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoderMap, SideInputBroadcast broadcastStateData, DoFnSchemaInformation doFnSchemaInformation, Map<String, PCollectionView<?>> sideInputMapping) {
        this.metricsAccum = metricsAccum;
        this.stepName = stepName;
        this.doFn = doFn;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = sideInputs;
        this.serializableOptions = serializableOptions;
        this.additionalOutputTags = additionalOutputTags;
        this.mainOutputTag = mainOutputTag;
        this.inputCoder = inputCoder;
        this.outputCoderMap = outputCoderMap;
        this.broadcastStateData = broadcastStateData;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
    }

    public Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> call(Iterator<WindowedValue<InputT>> iter) throws Exception {
        if (!this.wasSetupCalled && iter.hasNext()) {
            DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)this.serializableOptions.get());
            this.wasSetupCalled = true;
        }
        DoFnOutputManager outputManager = new DoFnOutputManager();
        DoFnRunner doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.serializableOptions.get(), this.doFn, (SideInputReader)CachedSideInputReader.of(new SparkSideInputReader(this.sideInputs, this.broadcastStateData)), (DoFnRunners.OutputManager)outputManager, this.mainOutputTag, this.additionalOutputTags, (StepContext)new NoOpStepContext(), this.inputCoder, this.outputCoderMap, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        DoFnRunnerWithMetrics doFnRunnerWithMetrics = new DoFnRunnerWithMetrics(this.stepName, doFnRunner, this.metricsAccum);
        return new ProcessContext(this.doFn, doFnRunnerWithMetrics, outputManager, Collections.emptyIterator()).processPartition(iter).iterator();
    }

    private class DoFnOutputManager
    implements ProcessContext.ProcessOutputManager<Tuple2<TupleTag<?>, WindowedValue<?>>> {
        private final Multimap<TupleTag<?>, WindowedValue<?>> outputs = LinkedListMultimap.create();

        private DoFnOutputManager() {
        }

        @Override
        public void clear() {
            this.outputs.clear();
        }

        @Override
        public Iterator<Tuple2<TupleTag<?>, WindowedValue<?>>> iterator() {
            Iterator entryIter = this.outputs.entries().iterator();
            return Iterators.transform(entryIter, this.entryToTupleFn());
        }

        private <K, V> Function<Map.Entry<K, V>, Tuple2<K, V>> entryToTupleFn() {
            return en -> new Tuple2(en.getKey(), en.getValue());
        }

        public synchronized <T> void output(TupleTag<T> tag, WindowedValue<T> output) {
            this.outputs.put(tag, output);
        }
    }
}

