/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DefaultMetricResults;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.util.JsonFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetricsContainerStepMap
implements Serializable {
    private Map<String, MetricsContainerImpl> metricsContainers;
    private MetricsContainerImpl unboundContainer = new MetricsContainerImpl(null);

    public MetricsContainerStepMap() {
        this.metricsContainers = new ConcurrentHashMap<String, MetricsContainerImpl>();
    }

    public MetricsContainerImpl getUnboundContainer() {
        return this.unboundContainer;
    }

    public MetricsContainerImpl getContainer(String stepName) {
        if (stepName == null) {
            return this.getUnboundContainer();
        }
        return this.metricsContainers.computeIfAbsent(stepName, name -> new MetricsContainerImpl((String)name));
    }

    public void updateAll(MetricsContainerStepMap other) {
        for (Map.Entry<String, MetricsContainerImpl> container : other.metricsContainers.entrySet()) {
            this.getContainer(container.getKey()).update(container.getValue());
        }
        this.getUnboundContainer().update(other.getUnboundContainer());
    }

    public void update(String step, MetricsContainerImpl container) {
        this.getContainer(step).update(container);
    }

    public void reset() {
        for (MetricsContainerImpl metricsContainer : this.metricsContainers.values()) {
            metricsContainer.reset();
        }
        this.unboundContainer.reset();
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof MetricsContainerStepMap) {
            MetricsContainerStepMap metricsContainerStepMap = (MetricsContainerStepMap)object;
            return Objects.equals(this.metricsContainers, metricsContainerStepMap.metricsContainers) && Objects.equals(this.unboundContainer, metricsContainerStepMap.unboundContainer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.metricsContainers, this.unboundContainer);
    }

    public static MetricResults asAttemptedOnlyMetricResults(MetricsContainerStepMap attemptedMetricsContainers) {
        return MetricsContainerStepMap.asMetricResults(attemptedMetricsContainers, new MetricsContainerStepMap());
    }

    public static MetricResults asMetricResults(MetricsContainerStepMap attemptedMetricsContainers, MetricsContainerStepMap committedMetricsContainers) {
        MetricUpdates cumulative;
        HashMap counters = new HashMap();
        HashMap distributions = new HashMap();
        HashMap gauges = new HashMap();
        for (MetricsContainerImpl container : attemptedMetricsContainers.getMetricsContainers()) {
            cumulative = container.getCumulative();
            MetricsContainerStepMap.mergeAttemptedResults(counters, cumulative.counterUpdates(), (l, r) -> l + r);
            MetricsContainerStepMap.mergeAttemptedResults(distributions, cumulative.distributionUpdates(), DistributionData::combine);
            MetricsContainerStepMap.mergeAttemptedResults(gauges, cumulative.gaugeUpdates(), GaugeData::combine);
        }
        for (MetricsContainerImpl container : committedMetricsContainers.getMetricsContainers()) {
            cumulative = container.getCumulative();
            MetricsContainerStepMap.mergeCommittedResults(counters, cumulative.counterUpdates(), (l, r) -> l + r);
            MetricsContainerStepMap.mergeCommittedResults(distributions, cumulative.distributionUpdates(), DistributionData::combine);
            MetricsContainerStepMap.mergeCommittedResults(gauges, cumulative.gaugeUpdates(), GaugeData::combine);
        }
        return new DefaultMetricResults(counters.values(), distributions.values().stream().map(result -> result.transform(DistributionData::extractResult)).collect(Collectors.toList()), gauges.values().stream().map(result -> result.transform(GaugeData::extractResult)).collect(Collectors.toList()));
    }

    public Iterable<MetricsApi.MonitoringInfo> getMonitoringInfos() {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        for (MetricsContainerImpl container : this.getMetricsContainers()) {
            for (MetricsApi.MonitoringInfo mi : container.getMonitoringInfos()) {
                monitoringInfos.add(mi);
            }
        }
        return monitoringInfos;
    }

    public Map<String, ByteString> getMonitoringData(ShortIdMap shortIds) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MetricsContainerImpl container : this.getMetricsContainers()) {
            builder.putAll(container.getMonitoringData(shortIds));
        }
        return builder.build();
    }

    public String toString() {
        JobApi.MetricResults results = JobApi.MetricResults.newBuilder().addAllAttempted(this.getMonitoringInfos()).build();
        JobApi.GetJobMetricsResponse response = JobApi.GetJobMetricsResponse.newBuilder().setMetrics(results).build();
        try {
            JsonFormat.Printer printer = JsonFormat.printer();
            return printer.print((MessageOrBuilder)response);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<MetricsContainerImpl> getMetricsContainers() {
        return Iterables.concat(this.metricsContainers.values(), Collections.singleton(this.unboundContainer));
    }

    private static <T> void mergeAttemptedResults(Map<MetricKey, MetricResult<T>> metricResultMap, Iterable<MetricUpdates.MetricUpdate<T>> updates, BiFunction<T, T, T> combine) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key = metricUpdate.getKey();
            metricResultMap.compute(key, (k, current) -> {
                if (current == null) {
                    return MetricResult.attempted((MetricKey)key, metricUpdate.getUpdate());
                }
                return current.addAttempted(metricUpdate.getUpdate(), combine);
            });
        }
    }

    private static <T> void mergeCommittedResults(Map<MetricKey, MetricResult<T>> metricResultMap, Iterable<MetricUpdates.MetricUpdate<T>> updates, BiFunction<T, T, T> combine) {
        for (MetricUpdates.MetricUpdate metricUpdate : updates) {
            MetricKey key = metricUpdate.getKey();
            if (metricResultMap.computeIfPresent(key, (k, current) -> current.addCommitted(metricUpdate.getUpdate(), combine)) != null) continue;
            throw new IllegalStateException(String.format("%s: existing 'attempted' result not found for 'committed' value %s", key, metricUpdate.getUpdate()));
        }
    }
}

