/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SnapshotName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_CLUSTER_SNAPSHOT = PathTemplate.createWithoutUrlEncoding("projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String cluster;
    private final String snapshot;

    @Deprecated
    protected SnapshotName() {
        this.project = null;
        this.instance = null;
        this.cluster = null;
        this.snapshot = null;
    }

    private SnapshotName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.instance = Preconditions.checkNotNull(builder.getInstance());
        this.cluster = Preconditions.checkNotNull(builder.getCluster());
        this.snapshot = Preconditions.checkNotNull(builder.getSnapshot());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SnapshotName of(String project, String instance, String cluster, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setSnapshot(snapshot).build();
    }

    public static String format(String project, String instance, String cluster, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setSnapshot(snapshot).build().toString();
    }

    public static SnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_INSTANCE_CLUSTER_SNAPSHOT.validatedMatch(formattedString, "SnapshotName.parse: formattedString not in valid format");
        return SnapshotName.of(matchMap.get("project"), matchMap.get("instance"), matchMap.get("cluster"), matchMap.get("snapshot"));
    }

    public static List<SnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<SnapshotName> list = new ArrayList<SnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_CLUSTER_SNAPSHOT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SnapshotName snapshotName = this;
            synchronized (snapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put("instance", this.instance);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put("cluster", this.cluster);
                    }
                    if (this.snapshot != null) {
                        fieldMapBuilder.put("snapshot", this.snapshot);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_CLUSTER_SNAPSHOT.instantiate("project", this.project, "instance", this.instance, "cluster", this.cluster, "snapshot", this.snapshot);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SnapshotName that = (SnapshotName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.snapshot, that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.snapshot);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String cluster;
        private String snapshot;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder(SnapshotName snapshotName) {
            this.project = snapshotName.project;
            this.instance = snapshotName.instance;
            this.cluster = snapshotName.cluster;
            this.snapshot = snapshotName.snapshot;
        }

        public SnapshotName build() {
            return new SnapshotName(this);
        }
    }
}

