/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TimestampRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ValueRange;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RegexUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class Filters {
    public static final Filters FILTERS = new Filters();
    private static final SimpleFilter PASS = new SimpleFilter(RowFilter.newBuilder().setPassAllFilter(true).build());
    private static final SimpleFilter BLOCK = new SimpleFilter(RowFilter.newBuilder().setBlockAllFilter(true).build());
    private static final SimpleFilter SINK = new SimpleFilter(RowFilter.newBuilder().setSink(true).build());
    private static final SimpleFilter STRIP_VALUE = new SimpleFilter(RowFilter.newBuilder().setStripValueTransformer(true).build());

    private Filters() {
    }

    public ChainFilter chain() {
        return new ChainFilter();
    }

    public InterleaveFilter interleave() {
        return new InterleaveFilter();
    }

    public ConditionFilter condition(@Nonnull Filter predicate) {
        Preconditions.checkNotNull(predicate);
        return new ConditionFilter(predicate);
    }

    public KeyFilter key() {
        return new KeyFilter();
    }

    public FamilyFilter family() {
        return new FamilyFilter();
    }

    public QualifierFilter qualifier() {
        return new QualifierFilter();
    }

    public TimestampFilter timestamp() {
        return new TimestampFilter();
    }

    public ValueFilter value() {
        return new ValueFilter();
    }

    public OffsetFilter offset() {
        return new OffsetFilter();
    }

    public LimitFilter limit() {
        return new LimitFilter();
    }

    public Filter fromProto(RowFilter rowFilter) {
        return new SimpleFilter(rowFilter);
    }

    public Filter pass() {
        return PASS;
    }

    public Filter block() {
        return BLOCK;
    }

    public Filter sink() {
        return SINK;
    }

    public Filter label(@Nonnull String label) {
        Preconditions.checkNotNull(label);
        return new SimpleFilter(RowFilter.newBuilder().setApplyLabelTransformer(label).build());
    }

    @InternalExtensionOnly
    public static interface Filter
    extends Cloneable,
    Serializable {
        @InternalApi
        public RowFilter toProto();
    }

    private static final class SimpleFilter
    implements Filter {
        private static final long serialVersionUID = 3595911451325189833L;
        private final RowFilter proto;

        private SimpleFilter(@Nonnull RowFilter proto) {
            Preconditions.checkNotNull(proto);
            this.proto = proto;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            return this.proto;
        }

        public SimpleFilter clone() {
            try {
                return (SimpleFilter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }
    }

    public static final class LimitFilter
    implements Serializable {
        private static final long serialVersionUID = -794915549003008940L;

        private LimitFilter() {
        }

        public Filter cellsPerRow(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerRowLimitFilter(count).build());
        }

        public Filter cellsPerColumn(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerColumnLimitFilter(count).build());
        }
    }

    public static final class OffsetFilter
    implements Serializable {
        private static final long serialVersionUID = 3228791236971884041L;

        private OffsetFilter() {
        }

        public Filter cellsPerRow(int count) {
            return new SimpleFilter(RowFilter.newBuilder().setCellsPerRowOffsetFilter(count).build());
        }
    }

    public static final class ValueRangeFilter
    extends Range.AbstractByteStringRange<ValueRangeFilter>
    implements Filter {
        private static final long serialVersionUID = -2452360677825047088L;

        private ValueRangeFilter() {
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            ValueRange.Builder builder = ValueRange.newBuilder();
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartValueClosed((ByteString)this.getStart());
                    break;
                }
                case OPEN: {
                    builder.setStartValueOpen((ByteString)this.getStart());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndValueClosed((ByteString)this.getEnd());
                    break;
                }
                case OPEN: {
                    builder.setEndValueOpen((ByteString)this.getEnd());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setValueRangeFilter(builder.build()).build();
        }

        @Override
        public ValueRangeFilter clone() {
            return (ValueRangeFilter)super.clone();
        }
    }

    public static final class ValueFilter
    implements Serializable {
        private static final long serialVersionUID = 6722715229238811179L;

        private ValueFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull(regex);
            return this.regex(ByteString.copyFromUtf8(regex));
        }

        public Filter exactMatch(@Nonnull String value) {
            Preconditions.checkNotNull(value);
            return this.exactMatch(ByteString.copyFromUtf8(value));
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull(value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull(regex);
            return new SimpleFilter(RowFilter.newBuilder().setValueRegexFilter(regex).build());
        }

        public ValueRangeFilter range() {
            return new ValueRangeFilter();
        }

        public Filter strip() {
            return STRIP_VALUE;
        }
    }

    public static final class TimestampRangeFilter
    extends Range.AbstractTimestampRange<TimestampRangeFilter>
    implements Filter {
        private static final long serialVersionUID = 8410980338603335276L;

        private TimestampRangeFilter() {
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            TimestampRange.Builder builder = TimestampRange.newBuilder();
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartTimestampMicros((Long)this.getStart());
                    break;
                }
                case OPEN: {
                    builder.setStartTimestampMicros((Long)this.getStart() + 1L);
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndTimestampMicros((Long)this.getEnd() + 1L);
                    break;
                }
                case OPEN: {
                    builder.setEndTimestampMicros((Long)this.getEnd());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setTimestampRangeFilter(builder.build()).build();
        }

        @Override
        public TimestampRangeFilter clone() {
            return (TimestampRangeFilter)super.clone();
        }
    }

    public static final class TimestampFilter
    implements Serializable {
        private static final long serialVersionUID = 5284219722591464991L;

        private TimestampFilter() {
        }

        public TimestampRangeFilter range() {
            return new TimestampRangeFilter();
        }

        public TimestampRangeFilter exact(Long exactTimestamp) {
            return (TimestampRangeFilter)((TimestampRangeFilter)new TimestampRangeFilter().startClosed(exactTimestamp)).endClosed(exactTimestamp);
        }
    }

    public static final class QualifierRangeFilter
    extends Range.AbstractByteStringRange<QualifierRangeFilter>
    implements Filter {
        private static final long serialVersionUID = -1909319911147913630L;
        private final String family;

        private QualifierRangeFilter(String family) {
            this.family = family;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            ColumnRange.Builder builder = ColumnRange.newBuilder().setFamilyName(this.family);
            switch (this.getStartBound()) {
                case CLOSED: {
                    builder.setStartQualifierClosed((ByteString)this.getStart());
                    break;
                }
                case OPEN: {
                    builder.setStartQualifierOpen((ByteString)this.getStart());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown start bound: " + (Object)((Object)this.getStartBound()));
                }
            }
            switch (this.getEndBound()) {
                case CLOSED: {
                    builder.setEndQualifierClosed((ByteString)this.getEnd());
                    break;
                }
                case OPEN: {
                    builder.setEndQualifierOpen((ByteString)this.getEnd());
                    break;
                }
                case UNBOUNDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown end bound: " + (Object)((Object)this.getEndBound()));
                }
            }
            return RowFilter.newBuilder().setColumnRangeFilter(builder.build()).build();
        }

        @Override
        public QualifierRangeFilter clone() {
            return (QualifierRangeFilter)super.clone();
        }
    }

    public static final class QualifierFilter
    implements Serializable {
        private static final long serialVersionUID = -1274850022909506559L;

        private QualifierFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull(regex);
            return this.regex(ByteString.copyFromUtf8(regex));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull(regex);
            return new SimpleFilter(RowFilter.newBuilder().setColumnQualifierRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull String value) {
            Preconditions.checkNotNull(value);
            return this.exactMatch(ByteString.copyFromUtf8(value));
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull(value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public QualifierRangeFilter rangeWithinFamily(@Nonnull String family) {
            Preconditions.checkNotNull(family);
            return new QualifierRangeFilter(family);
        }
    }

    public static final class FamilyFilter
    implements Serializable {
        private static final long serialVersionUID = -4470936841191831553L;

        private FamilyFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull(regex);
            return new SimpleFilter(RowFilter.newBuilder().setFamilyNameRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull String value) {
            Preconditions.checkNotNull(value);
            return this.regex(RegexUtil.literalRegex(value));
        }
    }

    public static final class KeyFilter
    implements Serializable {
        private static final long serialVersionUID = 5137765114285539458L;

        private KeyFilter() {
        }

        public Filter regex(@Nonnull String regex) {
            Preconditions.checkNotNull(regex);
            return this.regex(ByteString.copyFromUtf8(regex));
        }

        public Filter regex(@Nonnull ByteString regex) {
            Preconditions.checkNotNull(regex);
            return new SimpleFilter(RowFilter.newBuilder().setRowKeyRegexFilter(regex).build());
        }

        public Filter exactMatch(@Nonnull String value) {
            Preconditions.checkNotNull(value);
            return this.exactMatch(ByteString.copyFromUtf8(value));
        }

        public Filter exactMatch(@Nonnull ByteString value) {
            Preconditions.checkNotNull(value);
            return this.regex(RegexUtil.literalRegex(value));
        }

        public Filter sample(double probability) {
            Preconditions.checkArgument(0.0 <= probability, "Probability must be positive");
            Preconditions.checkArgument(probability <= 1.0, "Probability must be less than 1.0");
            return new SimpleFilter(RowFilter.newBuilder().setRowSampleFilter(probability).build());
        }
    }

    public static final class ConditionFilter
    implements Filter {
        private static final long serialVersionUID = -2720899822014446776L;
        private transient RowFilter.Condition.Builder builder;

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.builder.build());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            RowFilter.Condition condition = (RowFilter.Condition)s.readObject();
            this.builder = condition.toBuilder();
        }

        private ConditionFilter(@Nonnull Filter predicate) {
            Preconditions.checkNotNull(predicate);
            this.builder = RowFilter.Condition.newBuilder().setPredicateFilter(predicate.toProto());
        }

        public ConditionFilter then(@Nonnull Filter filter) {
            Preconditions.checkNotNull(filter);
            this.builder.setTrueFilter(filter.toProto());
            return this;
        }

        public ConditionFilter otherwise(@Nonnull Filter filter) {
            Preconditions.checkNotNull(filter);
            this.builder.setFalseFilter(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            Preconditions.checkState(this.builder.hasTrueFilter() || this.builder.hasFalseFilter(), "ConditionFilter must have either a then or otherwise filter.");
            return RowFilter.newBuilder().setCondition(this.builder.build()).build();
        }

        public ConditionFilter clone() {
            try {
                ConditionFilter clone = (ConditionFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }

    public static final class InterleaveFilter
    implements Filter {
        private static final long serialVersionUID = -6356151037337889421L;
        private transient RowFilter.Interleave.Builder builder = RowFilter.Interleave.newBuilder();

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.builder.build());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            RowFilter.Interleave interleave = (RowFilter.Interleave)s.readObject();
            this.builder = interleave.toBuilder();
        }

        private InterleaveFilter() {
        }

        public InterleaveFilter filter(@Nonnull Filter filter) {
            Preconditions.checkNotNull(filter);
            this.builder.addFilters(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            switch (this.builder.getFiltersCount()) {
                case 0: {
                    return PASS.toProto();
                }
                case 1: {
                    return this.builder.getFilters(0);
                }
            }
            return RowFilter.newBuilder().setInterleave(this.builder.build()).build();
        }

        public InterleaveFilter clone() {
            try {
                InterleaveFilter clone = (InterleaveFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }

    public static final class ChainFilter
    implements Filter {
        private static final long serialVersionUID = -6756759448656768478L;
        private transient RowFilter.Chain.Builder builder = RowFilter.Chain.newBuilder();

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.builder.build());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            RowFilter.Chain chain = (RowFilter.Chain)s.readObject();
            this.builder = chain.toBuilder();
        }

        private ChainFilter() {
        }

        public ChainFilter filter(@Nonnull Filter filter) {
            Preconditions.checkNotNull(filter);
            this.builder.addFilters(filter.toProto());
            return this;
        }

        @Override
        @InternalApi
        public RowFilter toProto() {
            switch (this.builder.getFiltersCount()) {
                case 0: {
                    return PASS.toProto();
                }
                case 1: {
                    return this.builder.getFilters(0);
                }
            }
            return RowFilter.newBuilder().setChain(this.builder.build()).build();
        }

        public ChainFilter clone() {
            try {
                ChainFilter clone = (ChainFilter)super.clone();
                clone.builder = this.builder.clone();
                return clone;
            }
            catch (ClassCastException | CloneNotSupportedException e) {
                throw new RuntimeException("should never happen");
            }
        }
    }
}

