/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.re2j;

import com.google.bigtable.repackaged.com.google.re2j.CharGroup;
import com.google.bigtable.repackaged.com.google.re2j.Unicode;
import com.google.bigtable.repackaged.com.google.re2j.Utils;

class CharClass {
    private int[] r;
    private int len;

    CharClass(int[] r) {
        this.r = r;
        this.len = r.length;
    }

    CharClass() {
        this.r = Utils.EMPTY_INTS;
        this.len = 0;
    }

    private void ensureCapacity(int newLen) {
        if (this.r.length < newLen) {
            if (newLen < this.len * 2) {
                newLen = this.len * 2;
            }
            int[] r2 = new int[newLen];
            System.arraycopy(this.r, 0, r2, 0, this.len);
            this.r = r2;
        }
    }

    int[] toArray() {
        if (this.len == this.r.length) {
            return this.r;
        }
        int[] r2 = new int[this.len];
        System.arraycopy(this.r, 0, r2, 0, this.len);
        return r2;
    }

    CharClass cleanClass() {
        if (this.len < 4) {
            return this;
        }
        CharClass.qsortIntPair(this.r, 0, this.len - 2);
        int w = 2;
        for (int i = 2; i < this.len; i += 2) {
            int lo = this.r[i];
            int hi = this.r[i + 1];
            if (lo <= this.r[w - 1] + 1) {
                if (hi <= this.r[w - 1]) continue;
                this.r[w - 1] = hi;
                continue;
            }
            this.r[w] = lo;
            this.r[w + 1] = hi;
            w += 2;
        }
        this.len = w;
        return this;
    }

    CharClass appendLiteral(int x, int flags) {
        return (flags & 1) != 0 ? this.appendFoldedRange(x, x) : this.appendRange(x, x);
    }

    CharClass appendRange(int lo, int hi) {
        if (this.len > 0) {
            for (int i = 2; i <= 4; i += 2) {
                if (this.len < i) continue;
                int rlo = this.r[this.len - i];
                int rhi = this.r[this.len - i + 1];
                if (lo > rhi + 1 || rlo > hi + 1) continue;
                if (lo < rlo) {
                    this.r[this.len - i] = lo;
                }
                if (hi > rhi) {
                    this.r[this.len - i + 1] = hi;
                }
                return this;
            }
        }
        this.ensureCapacity(this.len + 2);
        this.r[this.len++] = lo;
        this.r[this.len++] = hi;
        return this;
    }

    CharClass appendFoldedRange(int lo, int hi) {
        if (lo <= 65 && hi >= 66639) {
            return this.appendRange(lo, hi);
        }
        if (hi < 65 || lo > 66639) {
            return this.appendRange(lo, hi);
        }
        if (lo < 65) {
            this.appendRange(lo, 64);
            lo = 65;
        }
        if (hi > 66639) {
            this.appendRange(66640, hi);
            hi = 66639;
        }
        for (int c = lo; c <= hi; ++c) {
            this.appendRange(c, c);
            int f = Unicode.simpleFold(c);
            while (f != c) {
                this.appendRange(f, f);
                f = Unicode.simpleFold(f);
            }
        }
        return this;
    }

    CharClass appendClass(int[] x) {
        for (int i = 0; i < x.length; i += 2) {
            this.appendRange(x[i], x[i + 1]);
        }
        return this;
    }

    CharClass appendFoldedClass(int[] x) {
        for (int i = 0; i < x.length; i += 2) {
            this.appendFoldedRange(x[i], x[i + 1]);
        }
        return this;
    }

    CharClass appendNegatedClass(int[] x) {
        int nextLo = 0;
        for (int i = 0; i < x.length; i += 2) {
            int lo = x[i];
            int hi = x[i + 1];
            if (nextLo <= lo - 1) {
                this.appendRange(nextLo, lo - 1);
            }
            nextLo = hi + 1;
        }
        if (nextLo <= 0x10FFFF) {
            this.appendRange(nextLo, 0x10FFFF);
        }
        return this;
    }

    CharClass appendTable(int[][] table) {
        for (int[] triple : table) {
            int lo = triple[0];
            int hi = triple[1];
            int stride = triple[2];
            if (stride == 1) {
                this.appendRange(lo, hi);
                continue;
            }
            for (int c = lo; c <= hi; c += stride) {
                this.appendRange(c, c);
            }
        }
        return this;
    }

    CharClass appendNegatedTable(int[][] table) {
        int nextLo = 0;
        for (int[] triple : table) {
            int lo = triple[0];
            int hi = triple[1];
            int stride = triple[2];
            if (stride == 1) {
                if (nextLo <= lo - 1) {
                    this.appendRange(nextLo, lo - 1);
                }
                nextLo = hi + 1;
                continue;
            }
            for (int c = lo; c <= hi; c += stride) {
                if (nextLo <= c - 1) {
                    this.appendRange(nextLo, c - 1);
                }
                nextLo = c + 1;
            }
        }
        if (nextLo <= 0x10FFFF) {
            this.appendRange(nextLo, 0x10FFFF);
        }
        return this;
    }

    CharClass appendTableWithSign(int[][] table, int sign) {
        return sign < 0 ? this.appendNegatedTable(table) : this.appendTable(table);
    }

    CharClass negateClass() {
        int nextLo = 0;
        int w = 0;
        for (int i = 0; i < this.len; i += 2) {
            int lo = this.r[i];
            int hi = this.r[i + 1];
            if (nextLo <= lo - 1) {
                this.r[w] = nextLo;
                this.r[w + 1] = lo - 1;
                w += 2;
            }
            nextLo = hi + 1;
        }
        this.len = w;
        if (nextLo <= 0x10FFFF) {
            this.ensureCapacity(this.len + 2);
            this.r[this.len++] = nextLo;
            this.r[this.len++] = 0x10FFFF;
        }
        return this;
    }

    CharClass appendClassWithSign(int[] x, int sign) {
        return sign < 0 ? this.appendNegatedClass(x) : this.appendClass(x);
    }

    CharClass appendGroup(CharGroup g, boolean foldCase) {
        int[] cls = g.cls;
        if (foldCase) {
            cls = new CharClass().appendFoldedClass(cls).cleanClass().toArray();
        }
        return this.appendClassWithSign(cls, g.sign);
    }

    private static int cmp(int[] array, int i, int pivotFrom, int pivotTo) {
        int cmp = array[i] - pivotFrom;
        return cmp != 0 ? cmp : pivotTo - array[i + 1];
    }

    private static void qsortIntPair(int[] array, int left, int right) {
        int pivotIndex = (left + right) / 2 & 0xFFFFFFFE;
        int pivotFrom = array[pivotIndex];
        int pivotTo = array[pivotIndex + 1];
        int i = left;
        int j = right;
        while (i <= j) {
            while (i < right && CharClass.cmp(array, i, pivotFrom, pivotTo) < 0) {
                i += 2;
            }
            while (j > left && CharClass.cmp(array, j, pivotFrom, pivotTo) > 0) {
                j -= 2;
            }
            if (i > j) continue;
            if (i != j) {
                int temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                temp = array[i + 1];
                array[i + 1] = array[j + 1];
                array[j + 1] = temp;
            }
            i += 2;
            j -= 2;
        }
        if (left < j) {
            CharClass.qsortIntPair(array, left, j);
        }
        if (i < right) {
            CharClass.qsortIntPair(array, i, right);
        }
    }

    static String charClassToString(int[] r, int len) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < len; i += 2) {
            int hi;
            int lo;
            if (i > 0) {
                b.append(' ');
            }
            if ((lo = r[i]) == (hi = r[i + 1])) {
                b.append("0x");
                b.append(Integer.toHexString(lo));
                continue;
            }
            b.append("0x");
            b.append(Integer.toHexString(lo));
            b.append("-0x");
            b.append(Integer.toHexString(hi));
        }
        b.append(']');
        return b.toString();
    }

    public String toString() {
        return CharClass.charClassToString(this.r, this.len);
    }
}

