/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.alts.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;

public final class AltsFraming {
    private static final int FRAME_LENGTH_HEADER_SIZE = 4;
    private static final int FRAME_MESSAGE_TYPE_HEADER_SIZE = 4;
    private static final int MAX_DATA_LENGTH = 0x100000;
    private static final int INITIAL_BUFFER_CAPACITY = 65536;
    private static final int MESSAGE_TYPE = 6;

    private AltsFraming() {
    }

    static int getFrameLengthHeaderSize() {
        return 4;
    }

    static int getFrameMessageTypeHeaderSize() {
        return 4;
    }

    static int getMaxDataLength() {
        return 0x100000;
    }

    static int getFramingOverhead() {
        return 8;
    }

    static ByteBuffer toFrame(ByteBuffer input, int dataSize) throws GeneralSecurityException {
        Preconditions.checkNotNull(input);
        if (dataSize > input.remaining()) {
            dataSize = input.remaining();
        }
        Producer producer = new Producer();
        ByteBuffer inputAlias = input.duplicate();
        ((Buffer)inputAlias).limit(input.position() + dataSize);
        producer.readBytes(inputAlias);
        producer.flush();
        ((Buffer)input).position(inputAlias.position());
        ByteBuffer output = producer.getRawFrame();
        return output;
    }

    private static void copy(ByteBuffer dst, ByteBuffer src) {
        if (dst.hasRemaining() && src.hasRemaining()) {
            if (dst.remaining() >= src.remaining()) {
                dst.put(src);
            } else {
                int count = Math.min(dst.remaining(), src.remaining());
                ByteBuffer slice = src.slice();
                ((Buffer)slice).limit(count);
                dst.put(slice);
                ((Buffer)src).position(src.position() + count);
            }
        }
    }

    public static final class Parser {
        private ByteBuffer buffer = ByteBuffer.allocate(65536);
        private boolean isComplete = false;

        public Parser() {
            Preconditions.checkArgument(65536 > this.getFramePrefixLength() + this.getFrameSuffixLength());
        }

        public boolean readBytes(ByteBuffer input) throws GeneralSecurityException {
            Preconditions.checkNotNull(input);
            if (this.isComplete) {
                return true;
            }
            while (this.buffer.position() < 4 && input.hasRemaining()) {
                this.buffer.put(input.get());
            }
            if (this.buffer.position() == 4 && input.hasRemaining()) {
                ByteBuffer bufferAlias = this.buffer.duplicate();
                ((Buffer)bufferAlias).flip();
                bufferAlias.order(ByteOrder.LITTLE_ENDIAN);
                int dataLength = bufferAlias.getInt();
                if (dataLength < 4 || dataLength > 0x100000) {
                    throw new IllegalArgumentException("Invalid frame length " + dataLength);
                }
                int frameLength = dataLength + 4;
                if (this.buffer.capacity() < frameLength) {
                    this.buffer = ByteBuffer.allocate(frameLength);
                    this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.buffer.putInt(dataLength);
                }
                ((Buffer)this.buffer).limit(frameLength);
            }
            AltsFraming.copy(this.buffer, input);
            if (!this.buffer.hasRemaining()) {
                ((Buffer)this.buffer).flip();
                this.isComplete = true;
            }
            return this.isComplete;
        }

        int getFramePrefixLength() {
            int result = 8;
            return result;
        }

        int getFrameSuffixLength() {
            return 0;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        private void reset() {
            ((Buffer)this.buffer).clear();
            this.isComplete = false;
        }

        public ByteBuffer getRawFrame() {
            if (!this.isComplete) {
                return null;
            }
            ByteBuffer result = this.buffer.duplicate();
            this.reset();
            return result;
        }
    }

    static final class Producer {
        private ByteBuffer buffer;
        private boolean isComplete;

        Producer(int maxFrameSize) {
            this.buffer = ByteBuffer.allocate(maxFrameSize);
            this.reset();
            Preconditions.checkArgument(maxFrameSize > this.getFramePrefixLength() + this.getFrameSuffixLength());
        }

        Producer() {
            this(65536);
        }

        int getFramePrefixLength() {
            int result = 8;
            return result;
        }

        int getFrameSuffixLength() {
            return 0;
        }

        boolean readBytes(ByteBuffer input) throws GeneralSecurityException {
            Preconditions.checkNotNull(input);
            if (this.isComplete) {
                return true;
            }
            AltsFraming.copy(this.buffer, input);
            if (!this.buffer.hasRemaining()) {
                this.flush();
            }
            return this.isComplete;
        }

        void flush() throws GeneralSecurityException {
            if (this.isComplete) {
                return;
            }
            int frameLength = this.buffer.position() + this.getFrameSuffixLength();
            ((Buffer)this.buffer).flip();
            ((Buffer)this.buffer).limit(this.buffer.limit() + this.getFrameSuffixLength());
            int dataLength = frameLength - 4;
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer.putInt(dataLength);
            this.buffer.putInt(6);
            ((Buffer)this.buffer).position(0);
            this.isComplete = true;
        }

        private void reset() {
            ((Buffer)this.buffer).clear();
            ((Buffer)this.buffer).position(this.getFramePrefixLength());
            ((Buffer)this.buffer).limit(this.buffer.limit() - this.getFrameSuffixLength());
            this.isComplete = false;
        }

        ByteBuffer getRawFrame() {
            if (!this.isComplete) {
                return null;
            }
            ByteBuffer result = this.buffer.duplicate();
            this.reset();
            return result;
        }
    }
}

