/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.census;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.census.internal.DeprecatedCensusConstants;
import com.google.bigtable.repackaged.io.opencensus.contrib.grpc.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.io.opencensus.stats.Measure;
import com.google.bigtable.repackaged.io.opencensus.stats.MeasureMap;
import com.google.bigtable.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.io.opencensus.tags.Tags;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextBinarySerializer;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextSerializationException;
import com.google.bigtable.repackaged.io.opencensus.tags.unsafe.ContextUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class CensusStatsModule {
    private static final Logger logger = Logger.getLogger(CensusStatsModule.class.getName());
    private static final double NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
    private final Tagger tagger;
    private final StatsRecorder statsRecorder;
    private final Supplier<Stopwatch> stopwatchSupplier;
    @VisibleForTesting
    final Metadata.Key<TagContext> statsHeader;
    private final boolean propagateTags;
    private final boolean recordStartedRpcs;
    private final boolean recordFinishedRpcs;
    private final boolean recordRealTimeMetrics;
    private final boolean recordRetryMetrics;

    CensusStatsModule(Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags, boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics, boolean recordRetryMetrics) {
        this(Tags.getTagger(), Tags.getTagPropagationComponent().getBinarySerializer(), Stats.getStatsRecorder(), stopwatchSupplier, propagateTags, recordStartedRpcs, recordFinishedRpcs, recordRealTimeMetrics, recordRetryMetrics);
    }

    CensusStatsModule(final Tagger tagger, final TagContextBinarySerializer tagCtxSerializer, StatsRecorder statsRecorder, Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags, boolean recordStartedRpcs, boolean recordFinishedRpcs, boolean recordRealTimeMetrics, boolean recordRetryMetrics) {
        this.tagger = Preconditions.checkNotNull(tagger, "tagger");
        this.statsRecorder = Preconditions.checkNotNull(statsRecorder, "statsRecorder");
        Preconditions.checkNotNull(tagCtxSerializer, "tagCtxSerializer");
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
        this.propagateTags = propagateTags;
        this.recordStartedRpcs = recordStartedRpcs;
        this.recordFinishedRpcs = recordFinishedRpcs;
        this.recordRealTimeMetrics = recordRealTimeMetrics;
        this.recordRetryMetrics = recordRetryMetrics;
        this.statsHeader = Metadata.Key.of("grpc-tags-bin", new Metadata.BinaryMarshaller<TagContext>(){

            @Override
            public byte[] toBytes(TagContext context) {
                try {
                    return tagCtxSerializer.toByteArray(context);
                }
                catch (TagContextSerializationException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public TagContext parseBytes(byte[] serialized) {
                try {
                    return tagCtxSerializer.fromByteArray(serialized);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse stats header", e);
                    return tagger.empty();
                }
            }
        });
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return new ServerTracerFactory();
    }

    ClientInterceptor getClientInterceptor() {
        return new StatsClientInterceptor();
    }

    private void recordRealTimeMetric(TagContext ctx, Measure.MeasureDouble measure, double value) {
        if (this.recordRealTimeMetrics) {
            MeasureMap measureMap = this.statsRecorder.newMeasureMap().put(measure, value);
            measureMap.record(ctx);
        }
    }

    private void recordRealTimeMetric(TagContext ctx, Measure.MeasureLong measure, long value) {
        if (this.recordRealTimeMetrics) {
            MeasureMap measureMap = this.statsRecorder.newMeasureMap().put(measure, value);
            measureMap.record(ctx);
        }
    }

    @VisibleForTesting
    final class StatsClientInterceptor
    implements ClientInterceptor {
        StatsClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            TagContext parentCtx = CensusStatsModule.this.tagger.getCurrentTagContext();
            final CallAttemptsTracerFactory tracerFactory = new CallAttemptsTracerFactory(CensusStatsModule.this, parentCtx, method.getFullMethodName());
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            TagContext parentCtx = headers.get(CensusStatsModule.this.statsHeader);
            if (parentCtx == null) {
                parentCtx = CensusStatsModule.this.tagger.empty();
            }
            TagValue methodTag = TagValue.create(fullMethodName);
            parentCtx = CensusStatsModule.this.tagger.toBuilder(parentCtx).putLocal(RpcMeasureConstants.GRPC_SERVER_METHOD, methodTag).build();
            return new ServerTracer(CensusStatsModule.this, parentCtx);
        }
    }

    private static final class ServerTracer
    extends ServerStreamTracer {
        @Nullable
        private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> outboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> inboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> inboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> outboundUncompressedSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> inboundUncompressedSizeUpdater;
        private final CensusStatsModule module;
        private final TagContext parentCtx;
        private volatile int streamClosed;
        private final Stopwatch stopwatch;
        private volatile long outboundMessageCount;
        private volatile long inboundMessageCount;
        private volatile long outboundWireSize;
        private volatile long inboundWireSize;
        private volatile long outboundUncompressedSize;
        private volatile long inboundUncompressedSize;

        ServerTracer(CensusStatsModule module, TagContext parentCtx) {
            this.module = Preconditions.checkNotNull(module, "module");
            this.parentCtx = Preconditions.checkNotNull(parentCtx, "parentCtx");
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
            if (module.recordStartedRpcs) {
                module.statsRecorder.newMeasureMap().put(DeprecatedCensusConstants.RPC_SERVER_STARTED_COUNT, 1L).record(parentCtx);
            }
        }

        @Override
        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
            this.module.recordRealTimeMetric(this.parentCtx, RpcMeasureConstants.GRPC_SERVER_SENT_BYTES_PER_METHOD, bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
            this.module.recordRealTimeMetric(this.parentCtx, RpcMeasureConstants.GRPC_SERVER_RECEIVED_BYTES_PER_METHOD, bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            if (outboundUncompressedSizeUpdater != null) {
                outboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            if (inboundUncompressedSizeUpdater != null) {
                inboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundMessage(int seqNo) {
            if (inboundMessageCountUpdater != null) {
                inboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.inboundMessageCount;
            }
            this.module.recordRealTimeMetric(this.parentCtx, RpcMeasureConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_METHOD, 1L);
        }

        @Override
        public void outboundMessage(int seqNo) {
            if (outboundMessageCountUpdater != null) {
                outboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.outboundMessageCount;
            }
            this.module.recordRealTimeMetric(this.parentCtx, RpcMeasureConstants.GRPC_SERVER_SENT_MESSAGES_PER_METHOD, 1L);
        }

        @Override
        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            if (!this.module.recordFinishedRpcs) {
                return;
            }
            this.stopwatch.stop();
            long elapsedTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            MeasureMap measureMap = this.module.statsRecorder.newMeasureMap().put(DeprecatedCensusConstants.RPC_SERVER_FINISHED_COUNT, 1L).put(DeprecatedCensusConstants.RPC_SERVER_SERVER_LATENCY, (double)elapsedTimeNanos / NANOS_PER_MILLI).put(DeprecatedCensusConstants.RPC_SERVER_RESPONSE_COUNT, this.outboundMessageCount).put(DeprecatedCensusConstants.RPC_SERVER_REQUEST_COUNT, this.inboundMessageCount).put(DeprecatedCensusConstants.RPC_SERVER_RESPONSE_BYTES, (double)this.outboundWireSize).put(DeprecatedCensusConstants.RPC_SERVER_REQUEST_BYTES, (double)this.inboundWireSize).put(DeprecatedCensusConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (double)this.outboundUncompressedSize).put(DeprecatedCensusConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (double)this.inboundUncompressedSize);
            if (!status.isOk()) {
                measureMap.put(DeprecatedCensusConstants.RPC_SERVER_ERROR_COUNT, 1L);
            }
            TagValue statusTag = TagValue.create(status.getCode().toString());
            measureMap.record(this.module.tagger.toBuilder(this.parentCtx).putLocal(RpcMeasureConstants.GRPC_SERVER_STATUS, statusTag).build());
        }

        @Override
        public Context filterContext(Context context) {
            if (!this.module.tagger.empty().equals(this.parentCtx)) {
                return ContextUtils.withValue(context, this.parentCtx);
            }
            return context;
        }

        static {
            AtomicLongFieldUpdater<ServerTracer> tmpInboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpOutboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpOutboundWireSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpInboundMessageCountUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpOutboundMessageCountUpdater;
            AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
            try {
                tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
                tmpOutboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundMessageCount");
                tmpInboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundMessageCount");
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundWireSize");
                tmpOutboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundUncompressedSize");
                tmpInboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundUncompressedSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpStreamClosedUpdater = null;
                tmpOutboundMessageCountUpdater = null;
                tmpInboundMessageCountUpdater = null;
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
                tmpOutboundUncompressedSizeUpdater = null;
                tmpInboundUncompressedSizeUpdater = null;
            }
            streamClosedUpdater = tmpStreamClosedUpdater;
            outboundMessageCountUpdater = tmpOutboundMessageCountUpdater;
            inboundMessageCountUpdater = tmpInboundMessageCountUpdater;
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
            outboundUncompressedSizeUpdater = tmpOutboundUncompressedSizeUpdater;
            inboundUncompressedSizeUpdater = tmpInboundUncompressedSizeUpdater;
        }
    }

    @VisibleForTesting
    static final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        static final Measure.MeasureLong RETRIES_PER_CALL = Measure.MeasureLong.create("grpc.io/client/retries_per_call", "Number of retries per call", "1");
        static final Measure.MeasureLong TRANSPARENT_RETRIES_PER_CALL = Measure.MeasureLong.create("grpc.io/client/transparent_retries_per_call", "Transparent retries per call", "1");
        static final Measure.MeasureDouble RETRY_DELAY_PER_CALL = Measure.MeasureDouble.create("grpc.io/client/retry_delay_per_call", "Retry delay per call", "ms");
        ClientTracer inboundMetricTracer;
        private final CensusStatsModule module;
        private final Stopwatch stopwatch;
        @GuardedBy(value="lock")
        private boolean callEnded;
        private final TagContext parentCtx;
        private final TagContext startCtx;
        private final String fullMethodName;
        private final AtomicLong attemptsPerCall = new AtomicLong();
        private final AtomicLong transparentRetriesPerCall = new AtomicLong();
        private Status status;
        private final Object lock = new Object();
        private long retryDelayNanos;
        @GuardedBy(value="lock")
        private int activeStreams;
        @GuardedBy(value="lock")
        private boolean finishedCallToBeRecorded;

        CallAttemptsTracerFactory(CensusStatsModule module, TagContext parentCtx, String fullMethodName) {
            this.module = Preconditions.checkNotNull(module, "module");
            this.parentCtx = Preconditions.checkNotNull(parentCtx, "parentCtx");
            this.fullMethodName = Preconditions.checkNotNull(fullMethodName, "fullMethodName");
            this.stopwatch = (Stopwatch)module.stopwatchSupplier.get();
            TagValue methodTag = TagValue.create(fullMethodName);
            this.startCtx = module.tagger.toBuilder(parentCtx).putLocal(RpcMeasureConstants.GRPC_CLIENT_METHOD, methodTag).build();
            if (module.recordStartedRpcs) {
                module.statsRecorder.newMeasureMap().put(DeprecatedCensusConstants.RPC_CLIENT_STARTED_COUNT, 1L).record(this.startCtx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata metadata) {
            Object object = this.lock;
            synchronized (object) {
                if (this.finishedCallToBeRecorded) {
                    return new ClientStreamTracer(){};
                }
                if (++this.activeStreams == 1 && this.stopwatch.isRunning()) {
                    this.stopwatch.stop();
                    this.retryDelayNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                }
            }
            if (this.module.recordStartedRpcs && this.attemptsPerCall.get() > 0L) {
                this.module.statsRecorder.newMeasureMap().put(DeprecatedCensusConstants.RPC_CLIENT_STARTED_COUNT, 1L).record(this.startCtx);
            }
            if (info.isTransparentRetry()) {
                this.transparentRetriesPerCall.incrementAndGet();
            } else {
                this.attemptsPerCall.incrementAndGet();
            }
            return new ClientTracer(this, this.module, this.parentCtx, this.startCtx, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attemptEnded() {
            if (!this.module.recordFinishedRpcs) {
                return;
            }
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (--this.activeStreams == 0) {
                    this.stopwatch.start();
                    if (this.callEnded && !this.finishedCallToBeRecorded) {
                        shouldRecordFinishedCall = true;
                        this.finishedCallToBeRecorded = true;
                    }
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callEnded(Status status) {
            if (!this.module.recordFinishedRpcs) {
                return;
            }
            this.status = status;
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.callEnded) {
                    return;
                }
                this.callEnded = true;
                if (this.activeStreams == 0 && !this.finishedCallToBeRecorded) {
                    shouldRecordFinishedCall = true;
                    this.finishedCallToBeRecorded = true;
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        void recordFinishedCall() {
            if (this.attemptsPerCall.get() == 0L) {
                ClientTracer tracer = new ClientTracer(this, this.module, this.parentCtx, this.startCtx, null);
                tracer.roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                tracer.statusCode = this.status.getCode();
                tracer.recordFinishedAttempt();
            } else if (this.inboundMetricTracer != null) {
                this.inboundMetricTracer.recordFinishedAttempt();
            }
            if (!this.module.recordRetryMetrics) {
                return;
            }
            long retriesPerCall = 0L;
            long attempts = this.attemptsPerCall.get();
            if (attempts > 0L) {
                retriesPerCall = attempts - 1L;
            }
            MeasureMap measureMap = this.module.statsRecorder.newMeasureMap().put(RETRIES_PER_CALL, retriesPerCall).put(TRANSPARENT_RETRIES_PER_CALL, this.transparentRetriesPerCall.get()).put(RETRY_DELAY_PER_CALL, (double)this.retryDelayNanos / NANOS_PER_MILLI);
            TagValue methodTag = TagValue.create(this.fullMethodName);
            TagValue statusTag = TagValue.create(this.status.getCode().toString());
            measureMap.record(this.module.tagger.toBuilder(this.parentCtx).putLocal(RpcMeasureConstants.GRPC_CLIENT_METHOD, methodTag).putLocal(RpcMeasureConstants.GRPC_CLIENT_STATUS, statusTag).build());
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundMessageCountUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundUncompressedSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundUncompressedSizeUpdater;
        final Stopwatch stopwatch;
        final CallAttemptsTracerFactory attemptsState;
        final AtomicBoolean inboundReceivedOrClosed = new AtomicBoolean();
        final CensusStatsModule module;
        final TagContext parentCtx;
        final TagContext startCtx;
        final ClientStreamTracer.StreamInfo info;
        volatile long outboundMessageCount;
        volatile long inboundMessageCount;
        volatile long outboundWireSize;
        volatile long inboundWireSize;
        volatile long outboundUncompressedSize;
        volatile long inboundUncompressedSize;
        long roundtripNanos;
        Status.Code statusCode;

        ClientTracer(CallAttemptsTracerFactory attemptsState, CensusStatsModule module, TagContext parentCtx, TagContext startCtx, ClientStreamTracer.StreamInfo info) {
            this.attemptsState = attemptsState;
            this.module = module;
            this.parentCtx = parentCtx;
            this.startCtx = startCtx;
            this.info = info;
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
        }

        @Override
        public void streamCreated(Attributes transportAttrs, Metadata headers) {
            if (this.module.propagateTags) {
                headers.discardAll(this.module.statsHeader);
                if (!this.module.tagger.empty().equals(this.parentCtx)) {
                    headers.put(this.module.statsHeader, this.parentCtx);
                }
            }
        }

        @Override
        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
            this.module.recordRealTimeMetric(this.startCtx, RpcMeasureConstants.GRPC_CLIENT_SENT_BYTES_PER_METHOD, bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
            this.module.recordRealTimeMetric(this.startCtx, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_METHOD, bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            if (outboundUncompressedSizeUpdater != null) {
                outboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            if (inboundUncompressedSizeUpdater != null) {
                inboundUncompressedSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundUncompressedSize += bytes;
            }
        }

        @Override
        public void inboundMessage(int seqNo) {
            if (this.inboundReceivedOrClosed.compareAndSet(false, true)) {
                this.attemptsState.inboundMetricTracer = this;
            }
            if (inboundMessageCountUpdater != null) {
                inboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.inboundMessageCount;
            }
            this.module.recordRealTimeMetric(this.startCtx, RpcMeasureConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_METHOD, 1L);
        }

        @Override
        public void outboundMessage(int seqNo) {
            if (outboundMessageCountUpdater != null) {
                outboundMessageCountUpdater.getAndIncrement(this);
            } else {
                ++this.outboundMessageCount;
            }
            this.module.recordRealTimeMetric(this.startCtx, RpcMeasureConstants.GRPC_CLIENT_SENT_MESSAGES_PER_METHOD, 1L);
        }

        @Override
        public void streamClosed(Status status) {
            this.stopwatch.stop();
            this.roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Deadline deadline = this.info.getCallOptions().getDeadline();
            this.statusCode = status.getCode();
            if (this.statusCode == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                this.statusCode = Status.Code.DEADLINE_EXCEEDED;
            }
            this.attemptsState.attemptEnded();
            if (this.inboundReceivedOrClosed.compareAndSet(false, true) && this.module.recordFinishedRpcs) {
                this.recordFinishedAttempt();
            }
        }

        void recordFinishedAttempt() {
            MeasureMap measureMap = this.module.statsRecorder.newMeasureMap().put(DeprecatedCensusConstants.RPC_CLIENT_FINISHED_COUNT, 1L).put(DeprecatedCensusConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (double)this.roundtripNanos / NANOS_PER_MILLI).put(DeprecatedCensusConstants.RPC_CLIENT_REQUEST_COUNT, this.outboundMessageCount).put(DeprecatedCensusConstants.RPC_CLIENT_RESPONSE_COUNT, this.inboundMessageCount).put(DeprecatedCensusConstants.RPC_CLIENT_REQUEST_BYTES, (double)this.outboundWireSize).put(DeprecatedCensusConstants.RPC_CLIENT_RESPONSE_BYTES, (double)this.inboundWireSize).put(DeprecatedCensusConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (double)this.outboundUncompressedSize).put(DeprecatedCensusConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (double)this.inboundUncompressedSize);
            if (this.statusCode != Status.Code.OK) {
                measureMap.put(DeprecatedCensusConstants.RPC_CLIENT_ERROR_COUNT, 1L);
            }
            TagValue statusTag = TagValue.create(this.statusCode.toString());
            measureMap.record(this.module.tagger.toBuilder(this.startCtx).putLocal(RpcMeasureConstants.GRPC_CLIENT_STATUS, statusTag).build());
        }

        static {
            AtomicLongFieldUpdater<ClientTracer> tmpInboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundUncompressedSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpInboundMessageCountUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundMessageCountUpdater;
            try {
                tmpOutboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundMessageCount");
                tmpInboundMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundMessageCount");
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundWireSize");
                tmpOutboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundUncompressedSize");
                tmpInboundUncompressedSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundUncompressedSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpOutboundMessageCountUpdater = null;
                tmpInboundMessageCountUpdater = null;
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
                tmpOutboundUncompressedSizeUpdater = null;
                tmpInboundUncompressedSizeUpdater = null;
            }
            outboundMessageCountUpdater = tmpOutboundMessageCountUpdater;
            inboundMessageCountUpdater = tmpInboundMessageCountUpdater;
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
            outboundUncompressedSizeUpdater = tmpOutboundUncompressedSizeUpdater;
            inboundUncompressedSizeUpdater = tmpInboundUncompressedSizeUpdater;
        }
    }
}

