/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.compression.BrotliOptions;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class BrotliEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final Encoder.Parameters parameters;

    public BrotliEncoder() {
        this(BrotliOptions.DEFAULT);
    }

    public BrotliEncoder(Encoder.Parameters parameters) {
        this.parameters = ObjectUtil.checkNotNull(parameters, "Parameters");
    }

    public BrotliEncoder(BrotliOptions brotliOptions) {
        this(brotliOptions.parameters());
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (!msg.isReadable()) {
            return Unpooled.EMPTY_BUFFER;
        }
        try {
            byte[] uncompressed = ByteBufUtil.getBytes(msg, msg.readerIndex(), msg.readableBytes(), false);
            byte[] compressed = Encoder.compress((byte[])uncompressed, (Encoder.Parameters)this.parameters);
            if (preferDirect) {
                ByteBuf out = ctx.alloc().ioBuffer(compressed.length);
                out.writeBytes(compressed);
                return out;
            }
            return Unpooled.wrappedBuffer(compressed);
        }
        catch (Exception e) {
            ReferenceCountUtil.release(msg);
            throw e;
        }
    }
}

