/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.CellDeduplicationHelper;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class AppendAdapter
implements OperationAdapter<Append, ReadModifyWriteRow> {
    @Override
    public void adapt(Append operation, ReadModifyWriteRow readModifyWriteRow) {
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            String familyName = Bytes.toString((byte[])((byte[])entry.getKey()));
            List<Cell> cells = CellDeduplicationHelper.deduplicateFamily((Mutation)operation, (byte[])entry.getKey());
            for (Cell cell : cells) {
                readModifyWriteRow.append(familyName, ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()), ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            }
        }
    }
}

