/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;

@InternalApi(value="For internal usage only")
public class PutAdapter
extends MutationAdapter<Put> {
    private final int maxKeyValueSize;
    private final boolean setClientTimestamp;

    public PutAdapter(int maxKeyValueSize) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = true;
    }

    public PutAdapter(int maxKeyValueSize, boolean setClientTimestamp) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = setClientTimestamp;
    }

    PutAdapter withServerSideTimestamps() {
        return new PutAdapter(this.maxKeyValueSize, false);
    }

    @Override
    public void adapt(Put operation, MutationApi<?> mutation) {
        if (operation.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        long currentTimestampMicros = this.setClientTimestamp ? System.currentTimeMillis() * 1000L : -1L;
        int rowLength = operation.getRow().length;
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            ByteString familyString = ByteString.copyFrom((byte[])entry.getKey());
            int familySize = familyString.size();
            for (Cell cell : (List)entry.getValue()) {
                int qualifierLength = cell.getQualifierLength();
                int valueLength = cell.getValueLength();
                int keyValueSize = 20 + rowLength + familySize + qualifierLength + valueLength;
                if (this.maxKeyValueSize > 0 && keyValueSize > this.maxKeyValueSize) {
                    throw new IllegalArgumentException("KeyValue size too large");
                }
                ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), qualifierLength);
                ByteString value = ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), valueLength);
                long timestampMicros = currentTimestampMicros;
                if (cell.getTimestamp() != Long.MAX_VALUE) {
                    timestampMicros = TimestampConverter.hbase2bigtable(cell.getTimestamp());
                }
                mutation.setCell(familyString.toStringUtf8(), cellQualifierByteString, timestampMicros, value);
            }
        }
    }

    boolean isSetClientTimestamp() {
        return this.setClientTimestamp;
    }
}

