/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

@InternalApi(value="For internal usage only")
public abstract class BigtableHBaseSettings {
    protected static final Logger LOG = new Logger(BigtableOptionsFactory.class);
    private final Configuration configuration;
    private final String projectId;
    private final String instanceId;
    private final int ttlSecondsForBackup;

    public static BigtableHBaseSettings create(Configuration configuration) throws IOException {
        return BigtableHBaseVeneerSettings.create(configuration);
    }

    public BigtableHBaseSettings(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        this.projectId = this.getRequiredValue("google.bigtable.project.id", "Project ID");
        this.instanceId = this.getRequiredValue("google.bigtable.instance.id", "Instance ID");
        this.ttlSecondsForBackup = configuration.getInt("google.bigtable.snapshot.default.ttl.secs", 86400);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getTtlSecondsForBackup() {
        return this.ttlSecondsForBackup;
    }

    public abstract String getDataHost();

    public abstract String getAdminHost();

    public abstract int getPort();

    public abstract int getBulkMaxRowCount();

    public abstract long getBatchingMaxRequestSize();

    public abstract boolean isRetriesWithoutTimestampAllowed();

    protected String getRequiredValue(String key, String displayName) {
        String value = this.configuration.get(key);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(value), String.format("%s must be supplied via %s", displayName, key));
        return value;
    }

    public abstract String toDebugString();
}

