/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;

@InternalApi(value="For internal usage only")
public class RowResultAdapter
implements RowAdapter<Result> {
    private static final byte[] EMPTY_VALUE = new byte[0];
    private static final String SCAN_MARKER_ROW_LABEL = "bigtable-scan-marker-row";

    @Override
    public RowAdapter.RowBuilder<Result> createRowBuilder() {
        return new RowResultBuilder();
    }

    @Override
    public boolean isScanMarkerRow(Result result) {
        if (result.rawCells().length != 1 || !(result.rawCells()[0] instanceof RowCell)) {
            return false;
        }
        RowCell cell = (RowCell)result.rawCells()[0];
        return cell.getLabels().size() == 1 && cell.getLabels().get(0).equals(SCAN_MARKER_ROW_LABEL) && cell.getValueArray().length == 0 && cell.getFamilyArray().length == 0 && cell.getQualifierArray().length == 0;
    }

    @Override
    public ByteString getKey(Result result) {
        Cell cell = result.rawCells()[0];
        return ByteStringer.wrap(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    static class RowResultBuilder
    implements RowAdapter.RowBuilder<Result> {
        private ByteString currentKey;
        private String family;
        private byte[] qualifier;
        private List<String> labels;
        private long timestamp;
        private byte[] value;
        private RowCell previousNoLabelCell;
        private Map<String, List<RowCell>> cells = new TreeMap<String, List<RowCell>>();
        private List<RowCell> currentFamilyCells = null;
        private String previousFamily;
        private int nextValueIndex;

        RowResultBuilder() {
        }

        @Override
        public void startRow(ByteString rowKey) {
            this.currentKey = rowKey;
        }

        @Override
        public void startCell(String family, ByteString qualifier, long timestamp, List<String> labels, long size) {
            this.family = family;
            this.qualifier = ByteStringer.extract(qualifier);
            this.timestamp = timestamp;
            this.labels = labels;
            if (size > 0L) {
                this.value = new byte[(int)size];
                this.nextValueIndex = 0;
            } else {
                this.value = EMPTY_VALUE;
                this.nextValueIndex = -1;
            }
        }

        @Override
        public void cellValue(ByteString newValue) {
            if (this.nextValueIndex == -1) {
                this.value = ByteStringer.extract(newValue);
                this.nextValueIndex = newValue.size();
                return;
            }
            Preconditions.checkState(this.nextValueIndex + newValue.size() <= this.value.length, "Cell value is larger than expected");
            newValue.copyTo(this.value, this.nextValueIndex);
            this.nextValueIndex += newValue.size();
        }

        @Override
        public void finishCell() {
            Preconditions.checkNotNull(this.currentKey, "row key cannot be null");
            Preconditions.checkState(this.nextValueIndex == this.value.length, "Cell value too short");
            if (!Objects.equals(this.family, this.previousFamily)) {
                this.previousFamily = this.family;
                this.currentFamilyCells = new ArrayList<RowCell>();
                this.cells.put(this.family, this.currentFamilyCells);
                this.previousNoLabelCell = null;
            }
            RowCell rowCell = new RowCell(ByteStringer.extract(this.currentKey), this.family.getBytes(), this.qualifier, TimestampConverter.bigtable2hbase(this.timestamp), this.value, this.labels);
            if (!this.labels.isEmpty()) {
                this.currentFamilyCells.add(rowCell);
            } else if (!RowResultBuilder.keysMatch(this.previousNoLabelCell, rowCell)) {
                this.currentFamilyCells.add(rowCell);
                this.previousNoLabelCell = rowCell;
            }
        }

        private static boolean keysMatch(RowCell previousNoLabelCell, RowCell current) {
            return previousNoLabelCell != null && previousNoLabelCell.getTimestamp() == current.getTimestamp() && Arrays.equals(previousNoLabelCell.getQualifierArray(), current.getQualifierArray());
        }

        @Override
        public Result finishRow() {
            ImmutableList.Builder combined = ImmutableList.builder();
            for (List<RowCell> familyCellList : this.cells.values()) {
                combined.addAll(familyCellList);
            }
            return Result.create((List)((Object)combined.build()));
        }

        @Override
        public void reset() {
            this.currentKey = null;
            this.family = null;
            this.qualifier = null;
            this.labels = null;
            this.timestamp = 0L;
            this.value = null;
            this.cells = new TreeMap<String, List<RowCell>>();
            this.currentFamilyCells = null;
            this.previousFamily = null;
            this.previousNoLabelCell = null;
        }

        @Override
        public Result createScanMarkerRow(ByteString rowKey) {
            return Result.create(ImmutableList.of(new RowCell(ByteStringer.extract(rowKey), EMPTY_VALUE, EMPTY_VALUE, 0L, EMPTY_VALUE, ImmutableList.of(RowResultAdapter.SCAN_MARKER_ROW_LABEL))));
        }
    }
}

