/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase1_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.net.bytebuddy.ByteBuddy;
import com.google.bigtable.repackaged.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.google.bigtable.repackaged.net.bytebuddy.matcher.ElementMatchers;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableAdmin;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;

@InternalApi(value="For internal usage only")
public abstract class BigtableAdmin
extends AbstractBigtableAdmin {
    private static Class<? extends BigtableAdmin> adminClass = null;

    public BigtableAdmin(CommonConnection connection) throws IOException {
        super(connection);
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        this.snapshotTable(snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
        this.LOG.warn("isSnapshotFinished() is not currently supported by BigtableAdmin.\nYou may poll for existence of the snapshot with listSnapshots(snapshotName)", new Object[0]);
        return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(TimeUnit.MINUTES.toMillis(5L)).build();
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
    }

    public void snapshot(String snapshotId, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotId, tableName);
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
    }

    public void cloneSnapshot(String s, TableName tableName, boolean b) throws IOException, TableExistsException, RestoreSnapshotException {
        if (!b) {
            this.cloneSnapshot(s, tableName);
        }
        throw new UnsupportedOperationException("cloneSnapshot");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        List<String> backups = Futures.getChecked(this.adminClientWrapper.listBackupsAsync(this.getBackupClusterId()), IOException.class);
        ArrayList<HBaseProtos.SnapshotDescription> response = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (String snapshot : backups) {
            response.add(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshot).build());
        }
        return response;
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        if (pattern == null || pattern.matcher("").matches()) {
            return ImmutableList.of();
        }
        ArrayList<HBaseProtos.SnapshotDescription> response = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (HBaseProtos.SnapshotDescription description : this.listSnapshots()) {
            if (!pattern.matcher(description.getName()).matches()) continue;
            response.add(description);
        }
        return response;
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus(){

            public Collection<ServerName> getServers() {
                return Collections.emptyList();
            }
        };
    }

    private static synchronized Class<? extends BigtableAdmin> getSubclass() {
        if (adminClass == null) {
            adminClass = new ByteBuddy().subclass(BigtableAdmin.class).method(ElementMatchers.isAbstract()).intercept(InvocationHandlerAdapter.of(new AbstractBigtableAdmin.UnsupportedOperationsHandler())).make().load(BigtableAdmin.class.getClassLoader()).getLoaded();
        }
        return adminClass;
    }

    public static Admin createInstance(CommonConnection connection) throws IOException {
        try {
            return BigtableAdmin.getSubclass().getDeclaredConstructor(CommonConnection.class).newInstance(connection);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfInstanceOf(e.getTargetException(), IOException.class);
            Throwables.throwIfInstanceOf(e.getTargetException(), RuntimeException.class);
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

