/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.workflow.meta;

import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="workflow-log", name="Workflow Log", description="This metadata object type allows you to log activity of a workflow with a pipeline", image="workflow-log.svg", documentationUrl="/metadata-types/workflow-log.html")
public class WorkflowLog
extends HopMetadataBase
implements IHopMetadata {
    @HopMetadataProperty
    private boolean enabled;
    @HopMetadataProperty
    private boolean loggingParentsOnly;
    @HopMetadataProperty
    private String pipelineFilename;
    @HopMetadataProperty
    private boolean executingAtStart;
    @HopMetadataProperty
    private boolean executingPeriodically;
    @HopMetadataProperty
    private String intervalInSeconds;
    @HopMetadataProperty
    private boolean executingAtEnd;

    public WorkflowLog() {
        this.enabled = true;
        this.loggingParentsOnly = true;
        this.executingAtStart = true;
        this.executingPeriodically = false;
        this.intervalInSeconds = "30";
        this.executingAtEnd = true;
    }

    public WorkflowLog(String name) {
        super(name);
    }

    public WorkflowLog(String name, boolean enabled, boolean loggingParentsOnly, String pipelineFilename, boolean executingAtStart, boolean executingPeriodically, String intervalInSeconds, boolean executingAtEnd) {
        super(name);
        this.enabled = enabled;
        this.loggingParentsOnly = loggingParentsOnly;
        this.pipelineFilename = pipelineFilename;
        this.executingAtStart = executingAtStart;
        this.executingPeriodically = executingPeriodically;
        this.intervalInSeconds = intervalInSeconds;
        this.executingAtEnd = executingAtEnd;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLoggingParentsOnly() {
        return this.loggingParentsOnly;
    }

    public void setLoggingParentsOnly(boolean loggingParentsOnly) {
        this.loggingParentsOnly = loggingParentsOnly;
    }

    public String getPipelineFilename() {
        return this.pipelineFilename;
    }

    public void setPipelineFilename(String pipelineFilename) {
        this.pipelineFilename = pipelineFilename;
    }

    public boolean isExecutingAtStart() {
        return this.executingAtStart;
    }

    public void setExecutingAtStart(boolean executingAtStart) {
        this.executingAtStart = executingAtStart;
    }

    public boolean isExecutingPeriodically() {
        return this.executingPeriodically;
    }

    public void setExecutingPeriodically(boolean executingPeriodically) {
        this.executingPeriodically = executingPeriodically;
    }

    public String getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public void setIntervalInSeconds(String intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
    }

    public boolean isExecutingAtEnd() {
        return this.executingAtEnd;
    }

    public void setExecutingAtEnd(boolean executingAtEnd) {
        this.executingAtEnd = executingAtEnd;
    }
}

