/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorPath;
import akka.actor.ActorPathExtractor$;
import akka.actor.Address;
import akka.actor.InvalidActorNameException;
import akka.actor.RootActorPath;
import akka.actor.RootActorPath$;
import java.net.MalformedURLException;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ActorPath$
implements Serializable {
    public static final ActorPath$ MODULE$;
    private final String ValidSymbols;
    private final int ValidPathCode;
    private final int EmptyPathCode;
    private final Iterable<String> emptyActorPath;

    static {
        new ActorPath$();
    }

    public ActorPath fromString(String s) {
        String string = s;
        Option<Tuple2<Address, Iterable<String>>> option = ActorPathExtractor$.MODULE$.unapply(string);
        if (option.isEmpty()) {
            throw new MalformedURLException(new StringBuilder().append((Object)"cannot parse as ActorPath: ").append((Object)s).toString());
        }
        Address address = (Address)((Tuple2)option.get())._1();
        Iterable elems = (Iterable)((Tuple2)option.get())._2();
        ActorPath actorPath = new RootActorPath(address, RootActorPath$.MODULE$.apply$default$2()).$div((scala.collection.Iterable<String>)elems);
        return actorPath;
    }

    private final String ValidSymbols() {
        return "-_.*$+:@&=,!~';";
    }

    private final int ValidPathCode() {
        return -1;
    }

    private final int EmptyPathCode() {
        return -2;
    }

    public final void validatePathElement(String element) {
        this.validatePathElement(element, null);
    }

    public final void validatePathElement(String element, String fullPath) {
        int n = this.findInvalidPathElementCharPosition(element);
        switch (n) {
            default: {
                throw new InvalidActorNameException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid actor path element [", "]", ", illegal character [", "] at position: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element, this.fullPathMsg$1(fullPath), BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(element), n)), BoxesRunTime.boxToInteger((int)n)}))).append((Object)"Actor paths MUST: ").append((Object)"not start with `$`, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include only ASCII letters and can only contain these special characters: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"-_.*$+:@&=,!~';"}))).toString());
            }
            case -2: {
                throw new InvalidActorNameException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actor path element must not be empty ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPathMsg$1(fullPath)})));
            }
            case -1: 
        }
    }

    public final boolean isValidPathElement(String s) {
        return this.findInvalidPathElementCharPosition(s) == -1;
    }

    private final int findInvalidPathElementCharPosition(String s) {
        int len2;
        return s.isEmpty() ? -2 : ((len2 = s.length()) > 0 && s.charAt(0) != '$' ? this.validate$1(0, s, len2) : 0);
    }

    public final Iterable<String> emptyActorPath() {
        return this.emptyActorPath;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String fullPathMsg$1(String fullPath$1) {
        return fullPath$1 != null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (in path [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPath$1})) : "";
    }

    private final boolean isValidChar$1(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "-_.*$+:@&=,!~';".indexOf(c) != -1;
    }

    private final boolean isHexChar$1(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private final int validate$1(int pos, String s$1, int len$1) {
        int n;
        block3: {
            while (pos < len$1) {
                int n2;
                char c = s$1.charAt(pos);
                if (this.isValidChar$1(c)) {
                    ++pos;
                    continue;
                }
                if ('%' == c && pos + 2 < len$1 && this.isHexChar$1(s$1.charAt(pos + 1)) && this.isHexChar$1(s$1.charAt(pos + 2))) {
                    pos += 3;
                    continue;
                }
                n = n2 = pos;
                break block3;
            }
            n = -1;
        }
        return n;
    }

    private ActorPath$() {
        MODULE$ = this;
        this.emptyActorPath = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
    }
}

