/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;

@InternalApi
public class FilterMarkerRowsCallable<RowT>
extends ServerStreamingCallable<ReadRowsRequest, RowT> {
    private final ServerStreamingCallable<ReadRowsRequest, RowT> innerCallable;
    private final RowAdapter<RowT> rowAdapter;

    public FilterMarkerRowsCallable(ServerStreamingCallable<ReadRowsRequest, RowT> inner, RowAdapter<RowT> rowAdapter) {
        this.rowAdapter = rowAdapter;
        this.innerCallable = inner;
    }

    public void call(ReadRowsRequest request, ResponseObserver<RowT> responseObserver, ApiCallContext context) {
        FilteringResponseObserver innerObserver = new FilteringResponseObserver(responseObserver);
        this.innerCallable.call((Object)request, (ResponseObserver)innerObserver, context);
    }

    private class FilteringResponseObserver
    implements ResponseObserver<RowT> {
        private final ResponseObserver<RowT> outerObserver;
        private StreamController innerController;
        private boolean autoFlowControl = true;

        FilteringResponseObserver(ResponseObserver<RowT> outerObserver) {
            this.outerObserver = outerObserver;
        }

        public void onStart(final StreamController controller) {
            this.innerController = controller;
            this.outerObserver.onStart(new StreamController(){

                public void cancel() {
                    controller.cancel();
                }

                public void disableAutoInboundFlowControl() {
                    FilteringResponseObserver.this.autoFlowControl = false;
                    controller.disableAutoInboundFlowControl();
                }

                public void request(int count) {
                    controller.request(count);
                }
            });
        }

        public void onResponse(RowT response) {
            if (FilterMarkerRowsCallable.this.rowAdapter.isScanMarkerRow(response)) {
                if (!this.autoFlowControl) {
                    this.innerController.request(1);
                }
            } else {
                this.outerObserver.onResponse(response);
            }
        }

        public void onError(Throwable t) {
            this.outerObserver.onError(t);
        }

        public void onComplete() {
            this.outerObserver.onComplete();
        }
    }
}

