/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PreparedStatementParser {
    private static final Pattern VALUES = Pattern.compile("(?i)INSERT\\s+INTO\\s+.+VALUES\\s*\\(", 40);
    private final List<List<String>> parameters = new ArrayList<List<String>>();
    private final List<String> parts = new ArrayList<String>();

    private PreparedStatementParser(String sql) {
        this.parseSQL(sql);
    }

    static PreparedStatementParser parse(String sql) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("SQL may not be blank");
        }
        return new PreparedStatementParser(sql);
    }

    String[][] getParameters() {
        String[][] list = new String[this.parameters.size()][];
        int i = 0;
        for (List<String> param : this.parameters) {
            list[i++] = param.toArray(new String[0]);
        }
        return list;
    }

    List<String> getParts() {
        return this.parts;
    }

    private void parseSQL(String sql) {
        int i;
        ArrayList<String> currentParamList = new ArrayList<String>();
        boolean afterBackSlash = false;
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        boolean whiteSpace = false;
        Matcher matcher = VALUES.matcher(sql);
        boolean valuesMode = matcher.find();
        int currentParensLevel = 0;
        int quotedStart = 0;
        int partStart = 0;
        int idxStart = i = valuesMode ? matcher.end() - 1 : 0;
        int idxEnd = i;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (inSingleLineComment) {
                if (c == '\n') {
                    inSingleLineComment = false;
                }
            } else if (inMultiLineComment) {
                if (c == '*' && sql.length() > i + 1 && sql.charAt(i + 1) == '/') {
                    inMultiLineComment = false;
                    ++i;
                }
            } else if (afterBackSlash) {
                afterBackSlash = false;
            } else if (c == '\\') {
                afterBackSlash = true;
            } else if (c == '\'' && !inBackQuotes) {
                boolean bl = inQuotes = !inQuotes;
                if (inQuotes) {
                    quotedStart = i;
                } else if (!afterBackSlash) {
                    idxStart = quotedStart;
                    idxEnd = i + 1;
                }
            } else if (c == '`' && !inQuotes) {
                inBackQuotes = !inBackQuotes;
            } else if (!inQuotes && !inBackQuotes) {
                if (c == '?') {
                    if (currentParensLevel > 0) {
                        idxStart = i;
                        idxEnd = i + 1;
                    }
                    if (!valuesMode) {
                        this.parts.add(sql.substring(partStart, i));
                        partStart = i + 1;
                        currentParamList.add("?");
                    }
                } else if (c == '-' && sql.length() > i + 1 && sql.charAt(i + 1) == '-') {
                    inSingleLineComment = true;
                    ++i;
                } else if (c == '/' && sql.length() > i + 1 && sql.charAt(i + 1) == '*') {
                    inMultiLineComment = true;
                    ++i;
                } else if (c == ',') {
                    if (valuesMode && idxEnd > idxStart) {
                        currentParamList.add(PreparedStatementParser.typeTransformParameterValue(sql.substring(idxStart, idxEnd)));
                        this.parts.add(sql.substring(partStart, idxStart));
                        partStart = idxEnd;
                        idxStart = idxEnd = i;
                    }
                    ++idxStart;
                    ++idxEnd;
                } else if (c == '(') {
                    ++currentParensLevel;
                    ++idxStart;
                    ++idxEnd;
                } else if (c == ')') {
                    if (valuesMode && --currentParensLevel == 0) {
                        if (idxEnd > idxStart) {
                            currentParamList.add(PreparedStatementParser.typeTransformParameterValue(sql.substring(idxStart, idxEnd)));
                            this.parts.add(sql.substring(partStart, idxStart));
                            partStart = idxEnd;
                            idxStart = idxEnd = i;
                        }
                        if (!currentParamList.isEmpty()) {
                            this.parameters.add(currentParamList);
                            currentParamList = new ArrayList(currentParamList.size());
                        }
                    }
                } else if (Character.isWhitespace(c)) {
                    whiteSpace = true;
                } else if (currentParensLevel > 0) {
                    if (whiteSpace) {
                        idxStart = i;
                        idxEnd = i + 1;
                    } else {
                        ++idxEnd;
                    }
                    whiteSpace = false;
                }
            }
            ++i;
        }
        if (!valuesMode && !currentParamList.isEmpty()) {
            this.parameters.add(currentParamList);
        }
        String lastPart = sql.substring(partStart);
        this.parts.add(lastPart);
    }

    private static String typeTransformParameterValue(String paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(paramValue)) {
            return "1";
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(paramValue)) {
            return "0";
        }
        if ("NULL".equalsIgnoreCase(paramValue)) {
            return "\\N";
        }
        return paramValue;
    }
}

