/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.CommonRequestParams;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ServiceConstants;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageGrpc;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.WriteObjectSpec;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class GoogleCloudStorageGrpcWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<WriteObjectResponse>
implements GoogleCloudStorageItemInfo.Provider {
    private static final Duration START_RESUMABLE_WRITE_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration QUERY_WRITE_STATUS_TIMEOUT = Duration.ofMinutes(1L);
    private static final ImmutableSet<Status.Code> TRANSIENT_ERRORS = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.INTERNAL, (Object)Status.Code.RESOURCE_EXHAUSTED, (Object)Status.Code.UNAVAILABLE);
    private volatile StorageGrpc.StorageStub stub;
    private final StorageStubProvider stubProvider;
    private final StorageResourceId resourceId;
    private final CreateObjectOptions createOptions;
    private final ObjectWriteConditions writeConditions;
    private final String requesterPaysProject;
    private final GoogleCloudStorageImpl.BackOffFactory backOffFactory;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageGrpcWriteChannel(StorageStubProvider stubProvider, ExecutorService threadPool, AsyncWriteChannelOptions channelOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, ObjectWriteConditions writeConditions, String requesterPaysProject, GoogleCloudStorageImpl.BackOffFactory backOffFactory) {
        super(threadPool, channelOptions);
        this.stubProvider = stubProvider;
        this.stub = stubProvider.newAsyncStub();
        this.resourceId = resourceId;
        this.createOptions = createOptions;
        this.writeConditions = writeConditions;
        this.requesterPaysProject = requesterPaysProject;
        this.backOffFactory = backOffFactory;
    }

    protected String getResourceString() {
        return this.resourceId.toString();
    }

    public void handleResponse(WriteObjectResponse response) {
        com.google.storage.v2.Object resource = response.getResource();
        Map<String, byte[]> metadata = resource.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BaseEncoding.base64().decode((CharSequence)entry.getValue())));
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (resource.hasChecksums()) {
            md5Hash = !resource.getChecksums().getMd5Hash().isEmpty() ? resource.getChecksums().getMd5Hash().toByteArray() : null;
            crc32c = resource.getChecksums().hasCrc32C() ? ByteBuffer.allocate(4).putInt(resource.getChecksums().getCrc32C()).array() : null;
        }
        this.completedItemInfo = GoogleCloudStorageItemInfo.createObject(this.resourceId, Timestamps.toMillis((Timestamp)resource.getCreateTime()), Timestamps.toMillis((Timestamp)resource.getUpdateTime()), resource.getSize(), resource.getContentType(), resource.getContentEncoding(), metadata, resource.getGeneration(), resource.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    public void startUpload(InputStream pipeSource) {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    private class UploadOperation
    implements Callable<WriteObjectResponse> {
        private final BufferedInputStream pipeSource;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();
        private Hasher objectHasher;
        private String uploadId;
        private long writeOffset = 0L;
        private InsertChunkResponseObserver responseObserver;
        private final TreeMap<Long, ByteString> dataChunkMap = new TreeMap();

        UploadOperation(InputStream pipeSource) {
            this.pipeSource = new BufferedInputStream(pipeSource, this.MAX_BYTES_PER_MESSAGE);
            if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                this.objectHasher = Hashing.crc32c().newHasher();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public WriteObjectResponse call() throws IOException {
            this.uploadId = this.startResumableUpload();
            try (BufferedInputStream ignore = this.pipeSource;){
                WriteObjectResponse writeObjectResponse = (WriteObjectResponse)ResilientOperation.retry(this::doResumableUpload, (BackOff)GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), (RetryDeterminer)RetryDeterminer.ALL_ERRORS, IOException.class);
                return writeObjectResponse;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        private WriteObjectResponse doResumableUpload() throws IOException {
            if (this.writeOffset > 0L) {
                this.writeOffset = this.getCommittedWriteSize(this.uploadId);
            }
            this.responseObserver = new InsertChunkResponseObserver(this.uploadId, this.writeOffset);
            StreamObserver requestStreamObserver = ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getGrpcWriteTimeout(), TimeUnit.MILLISECONDS)).writeObject((StreamObserver)this.responseObserver);
            try {
                this.responseObserver.ready.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Streaming RPC failed to become ready for resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            boolean objectFinalized = false;
            while (!objectFinalized) {
                WriteObjectRequest insertRequest;
                if (this.dataChunkMap.size() > 0 && this.dataChunkMap.lastKey() >= this.writeOffset) {
                    insertRequest = this.buildRequestFromBufferedDataChunk(this.dataChunkMap, this.writeOffset);
                    this.writeOffset += (long)insertRequest.getChecksummedData().getContent().size();
                } else {
                    ByteString data = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)this.pipeSource, (long)this.MAX_BYTES_PER_MESSAGE), (int)this.MAX_BYTES_PER_MESSAGE);
                    this.dataChunkMap.put(this.writeOffset, data);
                    if ((long)this.dataChunkMap.size() >= GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getNumberOfBufferedRequests()) {
                        this.dataChunkMap.remove(this.dataChunkMap.firstKey());
                    }
                    insertRequest = this.buildInsertRequest(this.writeOffset, data, false);
                    this.writeOffset += (long)data.size();
                }
                requestStreamObserver.onNext((Object)insertRequest);
                objectFinalized = insertRequest.getFinishWrite();
                if (this.responseObserver.hasTransientError() || this.responseObserver.hasNonTransientError()) {
                    requestStreamObserver.onError(this.responseObserver.hasTransientError() ? this.responseObserver.transientError : this.responseObserver.nonTransientError);
                    break;
                }
                if (!objectFinalized) continue;
                requestStreamObserver.onCompleted();
            }
            try {
                this.responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            if (this.responseObserver.hasTransientError()) {
                throw new IOException(this.responseObserver.transientError);
            }
            return this.responseObserver.getResponseOrThrow();
        }

        private WriteObjectRequest buildInsertRequest(long writeOffset, ByteString dataChunk, boolean resumeFromFailedInsert) {
            WriteObjectRequest.Builder requestBuilder = WriteObjectRequest.newBuilder().setUploadId(this.uploadId).setWriteOffset(writeOffset);
            if (dataChunk.size() > 0) {
                ChecksummedData.Builder requestDataBuilder = ChecksummedData.newBuilder().setContent(dataChunk);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    if (!resumeFromFailedInsert) {
                        this.updateObjectHash(dataChunk);
                    }
                    requestDataBuilder.setCrc32C(this.getChunkHash(dataChunk));
                }
                requestBuilder.setChecksummedData(requestDataBuilder);
            }
            if (dataChunk.size() < this.MAX_BYTES_PER_MESSAGE) {
                requestBuilder.setFinishWrite(true);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    requestBuilder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(this.objectHasher.hash().asInt()));
                }
            }
            return requestBuilder.build();
        }

        private int getChunkHash(ByteString dataChunk) {
            Hasher chunkHasher = Hashing.crc32c().newHasher();
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                chunkHasher.putBytes(buffer);
            }
            return chunkHasher.hash().asInt();
        }

        private void updateObjectHash(ByteString dataChunk) {
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                this.objectHasher.putBytes(buffer);
            }
        }

        private WriteObjectRequest buildRequestFromBufferedDataChunk(TreeMap<Long, ByteString> dataChunkMap, long writeOffset) throws IOException {
            WriteObjectRequest request = null;
            if (dataChunkMap.size() > 0 && dataChunkMap.firstKey() <= writeOffset) {
                for (Map.Entry<Long, ByteString> entry : dataChunkMap.entrySet()) {
                    if (entry.getKey() + (long)entry.getValue().size() <= writeOffset && entry.getKey() != writeOffset) continue;
                    Long writeOffsetToResume = entry.getKey();
                    ByteString chunkData = entry.getValue();
                    request = this.buildInsertRequest(writeOffsetToResume, chunkData, true);
                    break;
                }
            }
            if (request == null) {
                throw new IOException(String.format("Didn't have enough data buffered for attempt to resume upload for uploadID %s: last committed offset=%s, earliest buffered offset=%s. Upload must be restarted from the beginning.", this.uploadId, writeOffset, dataChunkMap.firstKey()));
            }
            return request;
        }

        private String startResumableUpload() throws IOException {
            WriteObjectSpec.Builder insertObjectSpecBuilder = WriteObjectSpec.newBuilder().setResource(com.google.storage.v2.Object.newBuilder().setBucket(GrpcChannelUtils.toV2BucketName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getBucketName())).setName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getObjectName()).setContentType(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getContentType()).putAllMetadata(GoogleCloudStorageImpl.encodeMetadata(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getMetadata())).build());
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasContentGenerationMatch()) {
                insertObjectSpecBuilder.setIfGenerationMatch(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getContentGenerationMatch().longValue());
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasMetaGenerationMatch()) {
                insertObjectSpecBuilder.setIfMetagenerationMatch(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getMetaGenerationMatch().longValue());
            }
            CommonRequestParams.Builder commonRequestParamsBuilder = null;
            if (GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject != null) {
                commonRequestParamsBuilder = CommonRequestParams.newBuilder().setUserProject(GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject);
            }
            StartResumableWriteRequest.Builder startResumableWriteRequestBuilder = StartResumableWriteRequest.newBuilder().setWriteObjectSpec(insertObjectSpecBuilder);
            if (commonRequestParamsBuilder != null) {
                startResumableWriteRequestBuilder.setCommonRequestParams(commonRequestParamsBuilder);
            }
            StartResumableWriteRequest request = startResumableWriteRequestBuilder.build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            try {
                ResilientOperation.retry(() -> {
                    ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(START_RESUMABLE_WRITE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).startResumableWrite(request, (StreamObserver)responseObserver);
                    try {
                        responseObserver.done.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
                    }
                    if (responseObserver.hasError()) {
                        throw new IOException(responseObserver.getError());
                    }
                    return null;
                }, (BackOff)GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), (RetryDeterminer)RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            return ((StartResumableWriteResponse)responseObserver.getResponse()).getUploadId();
        }

        private long getCommittedWriteSize(String uploadId) throws IOException {
            QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            try {
                ResilientOperation.retry(() -> {
                    ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(QUERY_WRITE_STATUS_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).queryWriteStatus(request, (StreamObserver)responseObserver);
                    try {
                        responseObserver.done.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
                    }
                    if (responseObserver.hasError()) {
                        throw new IOException(responseObserver.getError());
                    }
                    return null;
                }, (BackOff)GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), (RetryDeterminer)RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to get committed write size for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            return ((QueryWriteStatusResponse)responseObserver.getResponse()).getCommittedSize();
        }

        private class SimpleResponseObserver<T>
        implements StreamObserver<T> {
            private T response;
            private Throwable error;
            final CountDownLatch done = new CountDownLatch(1);

            private SimpleResponseObserver() {
            }

            public T getResponse() {
                return (T)Preconditions.checkNotNull(this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            public Throwable getError() {
                return (Throwable)Preconditions.checkNotNull((Object)this.error, (String)"Error not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            public void onNext(T response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                this.error = new IOException(String.format("Caught exception for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), t);
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }
        }

        private class InsertChunkResponseObserver
        implements ClientResponseObserver<WriteObjectRequest, WriteObjectResponse> {
            private final long writeOffset;
            private final String uploadId;
            private WriteObjectResponse response;
            public Throwable transientError = null;
            public Throwable nonTransientError = null;
            final CountDownLatch done = new CountDownLatch(1);
            final CountDownLatch ready = new CountDownLatch(1);

            InsertChunkResponseObserver(String uploadId, long writeOffset) {
                this.uploadId = uploadId;
                this.writeOffset = writeOffset;
            }

            public WriteObjectResponse getResponseOrThrow() throws IOException {
                if (this.hasNonTransientError()) {
                    throw new IOException(String.format("Resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), this.nonTransientError);
                }
                return (WriteObjectResponse)Preconditions.checkNotNull((Object)this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasTransientError() {
                return this.transientError != null;
            }

            boolean hasNonTransientError() {
                return this.response == null && this.nonTransientError != null;
            }

            public void onNext(WriteObjectResponse response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                Status.Code statusCode = status.getCode();
                if (TRANSIENT_ERRORS.contains((Object)statusCode)) {
                    this.transientError = t;
                }
                if (this.transientError == null) {
                    this.nonTransientError = new IOException(String.format("Caught exception for '%s', while uploading to uploadId %s at writeOffset %d. Status: %s", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId, this.writeOffset, status.getDescription()), t);
                }
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }

            public void beforeStart(ClientCallStreamObserver<WriteObjectRequest> clientCallStreamObserver) {
                clientCallStreamObserver.setOnReadyHandler(this.ready::countDown);
            }
        }
    }
}

