/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.spark.launcher.CommandBuilderUtils;

abstract class AbstractCommandBuilder {
    boolean verbose;
    String appName;
    String appResource;
    String deployMode;
    String javaHome;
    String mainClass;
    String master;
    protected String propertiesFile;
    final List<String> appArgs = new ArrayList<String>();
    final List<String> jars;
    final List<String> files;
    final List<String> pyFiles;
    final Map<String, String> childEnv = new HashMap<String, String>();
    final Map<String, String> conf = new HashMap<String, String>();
    private Map<String, String> effectiveConfig;

    AbstractCommandBuilder() {
        this.files = new ArrayList<String>();
        this.jars = new ArrayList<String>();
        this.pyFiles = new ArrayList<String>();
    }

    abstract List<String> buildCommand(Map<String, String> var1) throws IOException, IllegalArgumentException;

    List<String> buildJavaCommand(String extraClassPath) throws IOException {
        File javaOpts;
        String[] candidateJavaHomes;
        ArrayList<String> cmd = new ArrayList<String>();
        for (String javaHome : candidateJavaHomes = new String[]{this.javaHome, this.childEnv.get("JAVA_HOME"), System.getenv("JAVA_HOME"), System.getProperty("java.home")}) {
            if (javaHome == null) continue;
            cmd.add(CommandBuilderUtils.join(File.separator, javaHome, "bin", "java"));
            break;
        }
        if ((javaOpts = new File(CommandBuilderUtils.join(File.separator, this.getConfDir(), "java-opts"))).isFile()) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(javaOpts), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.addOptionString(cmd, line);
                }
            }
        }
        cmd.add("-cp");
        cmd.add(CommandBuilderUtils.join(File.pathSeparator, this.buildClassPath(extraClassPath)));
        return cmd;
    }

    void addOptionString(List<String> cmd, String options) {
        if (!CommandBuilderUtils.isEmpty(options)) {
            for (String opt : CommandBuilderUtils.parseOptionString(options)) {
                cmd.add(opt);
            }
        }
    }

    List<String> buildClassPath(String appClassPath) throws IOException {
        String sparkHome = this.getSparkHome();
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        this.addToClassPath(cp, appClassPath);
        this.addToClassPath(cp, this.getConfDir());
        boolean prependClasses = !CommandBuilderUtils.isEmpty(this.getenv("SPARK_PREPEND_CLASSES"));
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        if (prependClasses || isTesting) {
            String scala = this.getScalaVersion();
            List<String> projects = Arrays.asList("common/kvstore", "common/network-common", "common/network-shuffle", "common/network-yarn", "common/sketch", "common/tags", "common/unsafe", "core", "examples", "graphx", "launcher", "mllib", "repl", "resource-managers/mesos", "resource-managers/yarn", "sql/catalyst", "sql/core", "sql/hive", "sql/hive-thriftserver", "streaming");
            if (prependClasses) {
                if (!isTesting) {
                    System.err.println("NOTE: SPARK_PREPEND_CLASSES is set, placing locally compiled Spark classes ahead of assembly.");
                }
                for (String project : projects) {
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/classes", sparkHome, project, scala));
                }
            }
            if (isTesting) {
                for (String project : projects) {
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/test-classes", sparkHome, project, scala));
                }
            }
            this.addToClassPath(cp, String.format("%s/core/target/jars/*", sparkHome));
            this.addToClassPath(cp, String.format("%s/mllib/target/jars/*", sparkHome));
        }
        boolean isTestingSql = "1".equals(this.getenv("SPARK_SQL_TESTING"));
        String jarsDir = CommandBuilderUtils.findJarsDir(this.getSparkHome(), this.getScalaVersion(), !isTesting && !isTestingSql);
        if (jarsDir != null) {
            this.addToClassPath(cp, CommandBuilderUtils.join(File.separator, jarsDir, "*"));
        }
        this.addToClassPath(cp, this.getenv("HADOOP_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("YARN_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("SPARK_DIST_CLASSPATH"));
        return new ArrayList<String>(cp);
    }

    private void addToClassPath(Set<String> cp, String entries) {
        String[] split;
        if (CommandBuilderUtils.isEmpty(entries)) {
            return;
        }
        for (String entry : split = entries.split(Pattern.quote(File.pathSeparator))) {
            if (CommandBuilderUtils.isEmpty(entry)) continue;
            if (new File(entry).isDirectory() && !entry.endsWith(File.separator)) {
                entry = entry + File.separator;
            }
            cp.add(entry);
        }
    }

    String getScalaVersion() {
        String scala = this.getenv("SPARK_SCALA_VERSION");
        if (scala != null) {
            return scala;
        }
        String sparkHome = this.getSparkHome();
        File scala212 = new File(sparkHome, "launcher/target/scala-2.12");
        File scala213 = new File(sparkHome, "launcher/target/scala-2.13");
        CommandBuilderUtils.checkState(!scala212.isDirectory() || !scala213.isDirectory(), "Presence of build for multiple Scala versions detected.\nEither clean one of them or set SPARK_SCALA_VERSION in your environment.", new Object[0]);
        if (scala213.isDirectory()) {
            return "2.13";
        }
        CommandBuilderUtils.checkState(scala212.isDirectory(), "Cannot find any build directories.", new Object[0]);
        return "2.12";
    }

    String getSparkHome() {
        String path = this.getenv("SPARK_HOME");
        if (path == null && "1".equals(this.getenv("SPARK_TESTING"))) {
            path = System.getProperty("spark.test.home");
        }
        CommandBuilderUtils.checkState(path != null, "Spark home not found; set it explicitly or use the SPARK_HOME environment variable.", new Object[0]);
        return path;
    }

    String getenv(String key) {
        return CommandBuilderUtils.firstNonEmpty(this.childEnv.get(key), System.getenv(key));
    }

    void setPropertiesFile(String path) {
        this.effectiveConfig = null;
        this.propertiesFile = path;
    }

    Map<String, String> getEffectiveConfig() throws IOException {
        if (this.effectiveConfig == null) {
            this.effectiveConfig = new HashMap<String, String>(this.conf);
            Properties p = this.loadPropertiesFile();
            for (String key : p.stringPropertyNames()) {
                if (this.effectiveConfig.containsKey(key)) continue;
                this.effectiveConfig.put(key, p.getProperty(key));
            }
        }
        return this.effectiveConfig;
    }

    private Properties loadPropertiesFile() throws IOException {
        File propsFile;
        Properties props = new Properties();
        if (this.propertiesFile != null) {
            propsFile = new File(this.propertiesFile);
            CommandBuilderUtils.checkArgument(propsFile.isFile(), "Invalid properties file '%s'.", this.propertiesFile);
        } else {
            propsFile = new File(this.getConfDir(), "spark-defaults.conf");
        }
        if (propsFile.isFile()) {
            try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8);){
                props.load(isr);
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    e.setValue(e.getValue().toString().trim());
                }
            }
        }
        return props;
    }

    private String getConfDir() {
        String confDir = this.getenv("SPARK_CONF_DIR");
        return confDir != null ? confDir : CommandBuilderUtils.join(File.separator, this.getSparkHome(), "conf");
    }
}

