/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.config;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEnginePluginType;

public class PipelineRunConfigurationMetadataObjectFactory
implements IHopMetadataObjectFactory {
    public Object createObject(String id, Object parentObject) throws HopException {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.findPluginWithId(PipelineEnginePluginType.class, id);
        if (plugin == null) {
            throw new HopException("Unable to find the plugin in the context of a pipeline engine plugin for id: " + id);
        }
        try {
            IPipelineEngine engine = (IPipelineEngine)registry.loadClass(plugin, IPipelineEngine.class);
            IPipelineEngineRunConfiguration engineRunConfiguration = engine.createDefaultPipelineEngineRunConfiguration();
            engineRunConfiguration.setEnginePluginId(plugin.getIds()[0]);
            engineRunConfiguration.setEnginePluginName(plugin.getName());
            if (parentObject != null && parentObject instanceof IVariables) {
                engineRunConfiguration.initializeFrom((IVariables)parentObject);
            }
            return engineRunConfiguration;
        }
        catch (HopPluginException e) {
            throw new HopException("Unable to load the pipeline engine plugin class with plugin id: " + id, (Throwable)e);
        }
    }

    public String getObjectId(Object object) throws HopException {
        if (!(object instanceof IPipelineEngineRunConfiguration)) {
            throw new HopException("Object provided needs to be of class " + IPipelineEngineRunConfiguration.class.getName());
        }
        return ((IPipelineEngineRunConfiguration)object).getEnginePluginId();
    }
}

