/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.debug.IBreakPointListener;
import org.apache.hop.pipeline.debug.TransformDebugMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;

public class PipelineDebugMeta {
    public static final String XML_TAG = "pipeline-debug-meta";
    public static final String XML_TAG_TRANSFORM_DEBUG_METAS = "transform-debug-metas";
    private PipelineMeta pipelineMeta;
    private Map<TransformMeta, TransformDebugMeta> transformDebugMetaMap;
    private boolean dataShown = false;

    public PipelineDebugMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
        this.transformDebugMetaMap = new HashMap<TransformMeta, TransformDebugMeta>();
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public Map<TransformMeta, TransformDebugMeta> getTransformDebugMetaMap() {
        return this.transformDebugMetaMap;
    }

    public void setTransformDebugMetaMap(Map<TransformMeta, TransformDebugMeta> transformDebugMeta) {
        this.transformDebugMetaMap = transformDebugMeta;
    }

    public synchronized void addRowListenersToPipeline(final IPipelineEngine<PipelineMeta> pipeline) {
        this.dataShown = false;
        for (TransformMeta transformMeta : this.transformDebugMetaMap.keySet()) {
            final TransformDebugMeta transformDebugMeta = this.transformDebugMetaMap.get(transformMeta);
            for (IEngineComponent component : pipeline.getComponentCopies(transformMeta.getName())) {
                if (!(component instanceof ITransform)) continue;
                ITransform baseTransform = (ITransform)component;
                baseTransform.addRowListener(new RowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        try {
                            TransformDebugMeta transformDebugMeta2 = transformDebugMeta;
                            synchronized (transformDebugMeta2) {
                                int rowCount = transformDebugMeta.getRowCount();
                                if (transformDebugMeta.isReadingFirstRows() && rowCount > 0) {
                                    int bufferSize = transformDebugMeta.getRowBuffer().size();
                                    if (bufferSize < rowCount) {
                                        transformDebugMeta.setRowBufferMeta(rowMeta);
                                        transformDebugMeta.getRowBuffer().add(rowMeta.cloneRow(row));
                                    } else {
                                        pipeline.pauseExecution();
                                        PipelineDebugMeta.this.dataShown = true;
                                        transformDebugMeta.fireBreakPointListeners(PipelineDebugMeta.this);
                                    }
                                } else if (transformDebugMeta.isPausingOnBreakPoint() && transformDebugMeta.getCondition() != null) {
                                    if (rowCount > 0) {
                                        transformDebugMeta.setRowBufferMeta(rowMeta);
                                        transformDebugMeta.getRowBuffer().add(0, rowMeta.cloneRow(row));
                                        int bufferSize = transformDebugMeta.getRowBuffer().size();
                                        if (bufferSize > rowCount) {
                                            transformDebugMeta.getRowBuffer().remove(bufferSize - 1);
                                        }
                                    } else if (transformDebugMeta.getRowBuffer().isEmpty()) {
                                        transformDebugMeta.getRowBuffer().add(rowMeta.cloneRow(row));
                                    } else {
                                        transformDebugMeta.getRowBuffer().set(0, rowMeta.cloneRow(row));
                                    }
                                    if (transformDebugMeta.getCondition().evaluate(rowMeta, row)) {
                                        pipeline.pauseExecution();
                                        transformDebugMeta.fireBreakPointListeners(PipelineDebugMeta.this);
                                    }
                                }
                            }
                        }
                        catch (HopException e) {
                            throw new HopTransformException((Throwable)e);
                        }
                    }
                });
            }
        }
        try {
            pipeline.addExecutionFinishedListener(p -> {
                if (this.dataShown) {
                    return;
                }
                for (TransformMeta transformMeta : this.transformDebugMetaMap.keySet()) {
                    List<Object[]> rowBuffer;
                    TransformDebugMeta transformDebugMeta = this.transformDebugMetaMap.get(transformMeta);
                    if (transformDebugMeta == null || (rowBuffer = transformDebugMeta.getRowBuffer()) == null || rowBuffer.isEmpty()) continue;
                    transformDebugMeta.fireBreakPointListeners(this);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addBreakPointListers(IBreakPointListener breakPointListener) {
        for (TransformDebugMeta transformDebugMeta : this.transformDebugMetaMap.values()) {
            transformDebugMeta.addBreakPointListener(breakPointListener);
        }
    }

    public int getTotalNumberOfHits() {
        int total = 0;
        for (TransformDebugMeta transformDebugMeta : this.transformDebugMetaMap.values()) {
            total += transformDebugMeta.getNumberOfHits();
        }
        return total;
    }

    public int getNrOfUsedTransforms() {
        int nr = 0;
        for (TransformDebugMeta transformDebugMeta : this.transformDebugMetaMap.values()) {
            if (transformDebugMeta.isReadingFirstRows() && transformDebugMeta.getRowCount() > 0) {
                ++nr;
                continue;
            }
            if (!transformDebugMeta.isPausingOnBreakPoint() || transformDebugMeta.getCondition() == null || transformDebugMeta.getCondition().isEmpty()) continue;
            ++nr;
        }
        return nr;
    }
}

