/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.local.transaction;

import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;

@ExtensionPoint(id="DatabaseCreatedXp", extensionPointId="DatabaseCreated", description="Pass the connection group to a relational database from a parent pipeline, workflow, action or transform")
public class DatabaseCreatedXp
implements IExtensionPoint<Database> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Database database) throws HopException {
        if (!(database.getParentObject() instanceof IExtensionData)) {
            return;
        }
        IExtensionData extensionData = (IExtensionData)database.getParentObject();
        String connectionGroup = (String)extensionData.getExtensionDataMap().get("CONNECTION_GROUP");
        if (connectionGroup != null) {
            database.setConnectionGroup(connectionGroup);
        }
    }
}

