/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformFinishedListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.ITransformStartedListener;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformStatus;

public interface ITransform
extends IVariables,
IHasLogChannel,
IEngineComponent,
IExtensionData {
    public IPipelineEngine<PipelineMeta> getPipeline();

    public boolean processRow() throws HopException;

    public boolean canProcessOneRow();

    public boolean init();

    public void dispose();

    public void markStart();

    public void markStop();

    public void stopRunning() throws HopException;

    @Override
    public boolean isRunning();

    public void setRunning(boolean var1);

    @Override
    public boolean isStopped();

    public void setStopped(boolean var1);

    default public void setSafeStopped(boolean stopped) {
    }

    default public boolean isSafeStopped() {
        return false;
    }

    @Override
    public boolean isPaused();

    public void stopAll();

    public void pauseRunning();

    public void resumeRunning();

    public String getTransformName();

    public int getCopy();

    public String getTransformPluginId();

    @Override
    public long getErrors();

    public void setErrors(long var1);

    @Override
    public long getLinesInput();

    @Override
    public long getLinesOutput();

    @Override
    public long getLinesRead();

    @Override
    public long getLinesWritten();

    @Override
    public long getLinesUpdated();

    public void setLinesRejected(long var1);

    @Override
    public long getLinesRejected();

    public void putRow(IRowMeta var1, Object[] var2) throws HopException;

    public Object[] getRow() throws HopException;

    public void setOutputDone();

    @Override
    public void addRowListener(IRowListener var1);

    @Override
    public void removeRowListener(IRowListener var1);

    public List<IRowListener> getRowListeners();

    public List<IRowSet> getInputRowSets();

    public List<IRowSet> getOutputRowSets();

    public boolean isPartitioned();

    public void setPartitionId(String var1);

    public String getPartitionId();

    public void cleanup();

    public void initBeforeStart() throws HopTransformException;

    public void addTransformFinishedListener(ITransformFinishedListener var1);

    public void addTransformStartedListener(ITransformStartedListener var1);

    public boolean isMapping();

    public TransformMeta getTransformMeta();

    @Override
    public ILogChannel getLogChannel();

    public int rowsetInputSize();

    public int rowsetOutputSize();

    public long getProcessed();

    public Map<String, ResultFile> getResultFiles();

    @Override
    public EngineComponent.ComponentExecutionStatus getStatus();

    @Override
    public long getExecutionDuration();

    public void identifyErrorOutput();

    public void setPartitioned(boolean var1);

    public void setRepartitioning(int var1);

    public void batchComplete() throws HopException;

    public void setMetadataProvider(IHopMetadataProvider var1);

    public IHopMetadataProvider getMetadataProvider();

    public int getCurrentOutputRowSetNr();

    public void setCurrentOutputRowSetNr(int var1);

    public int getCurrentInputRowSetNr();

    public void setCurrentInputRowSetNr(int var1);

    default public Collection<TransformStatus> subStatuses() {
        return Collections.emptyList();
    }

    default public void addRowSetToInputRowSets(IRowSet rowSet) {
        this.getInputRowSets().add(rowSet);
    }

    default public void addRowSetToOutputRowSets(IRowSet rowSet) {
        this.getOutputRowSets().add(rowSet);
    }

    public ITransformMeta getMeta();

    public ITransformData getData();

    @Override
    public Date getInitStartDate();

    @Override
    public void setInitStartDate(Date var1);

    @Override
    public Date getExecutionStartDate();

    @Override
    public void setExecutionStartDate(Date var1);

    @Override
    public Date getFirstRowReadDate();

    @Override
    public void setFirstRowReadDate(Date var1);

    @Override
    public Date getLastRowWrittenDate();

    @Override
    public void setLastRowWrittenDate(Date var1);

    @Override
    public Date getExecutionEndDate();

    @Override
    public void setExecutionEndDate(Date var1);
}

