/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WorkflowMap;

public class BaseHttpServlet
extends HttpServlet {
    protected static final long serialVersionUID = -1348342810327662788L;
    protected PipelineMap pipelineMap;
    protected WorkflowMap workflowMap;
    protected HopServerConfig serverConfig;
    protected IVariables variables;
    private boolean jettyMode = false;
    protected ILogChannel log = new LogChannel((Object)"Servlet");

    public String convertContextPath(String contextPath) {
        if (this.jettyMode) {
            return contextPath;
        }
        return contextPath.substring(contextPath.lastIndexOf("/") + 1);
    }

    public BaseHttpServlet() {
    }

    public BaseHttpServlet(PipelineMap pipelineMap) {
        this.pipelineMap = pipelineMap;
        this.jettyMode = true;
        this.serverConfig = pipelineMap.getHopServerConfig();
        this.variables = this.serverConfig == null ? Variables.getADefaultVariableSpace() : this.serverConfig.getVariables();
    }

    public BaseHttpServlet(WorkflowMap workflowMap) {
        this.workflowMap = workflowMap;
        this.jettyMode = true;
        this.serverConfig = workflowMap.getHopServerConfig();
        this.variables = this.serverConfig == null ? Variables.getADefaultVariableSpace() : this.serverConfig.getVariables();
    }

    public BaseHttpServlet(PipelineMap pipelineMap, WorkflowMap workflowMap) {
        this.pipelineMap = pipelineMap;
        this.workflowMap = workflowMap;
        this.jettyMode = true;
        this.serverConfig = pipelineMap.getHopServerConfig();
        this.variables = this.serverConfig == null ? Variables.getADefaultVariableSpace() : this.serverConfig.getVariables();
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public PipelineMap getPipelineMap() {
        if (this.pipelineMap == null) {
            return HopServerSingleton.getInstance().getPipelineMap();
        }
        return this.pipelineMap;
    }

    public WorkflowMap getWorkflowMap() {
        if (this.workflowMap == null) {
            return HopServerSingleton.getInstance().getWorkflowMap();
        }
        return this.workflowMap;
    }

    public boolean isJettyMode() {
        return this.jettyMode;
    }

    public void setJettyMode(boolean jettyMode) {
        this.jettyMode = jettyMode;
    }

    public void logMinimal(String s) {
        this.log.logMinimal(s);
    }

    public void logBasic(String s) {
        this.log.logBasic(s);
    }

    public void logError(String s) {
        this.log.logError(s);
    }

    public void logError(String s, Throwable e) {
        this.log.logError(s, e);
    }

    public void logBasic(String s, Object ... arguments) {
        this.log.logBasic(s, arguments);
    }

    public void logDetailed(String s, Object ... arguments) {
        this.log.logDetailed(s, arguments);
    }

    public void logError(String s, Object ... arguments) {
        this.log.logError(s, arguments);
    }

    public void logDetailed(String s) {
        this.log.logDetailed(s);
    }

    public void logDebug(String s) {
        this.log.logDebug(s);
    }

    public void logRowlevel(String s) {
        this.log.logRowlevel(s);
    }

    public void setup(PipelineMap pipelineMap, WorkflowMap workflowMap) {
        this.pipelineMap = pipelineMap;
        this.workflowMap = workflowMap;
        this.serverConfig = pipelineMap.getHopServerConfig();
        this.variables = this.serverConfig.getVariables();
    }

    public void setPipelineMap(PipelineMap pipelineMap) {
        this.pipelineMap = pipelineMap;
    }

    public void setWorkflowMap(WorkflowMap workflowMap) {
        this.workflowMap = workflowMap;
    }

    public HopServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(HopServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }
}

