/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.Variable;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.i18n.BaseMessages;

public class Const {
    private static final Class<?> PKG = Const.class;
    public static final int TIMEOUT_GET_MILLIS = 50;
    public static final int TIMEOUT_PUT_MILLIS = 50;
    public static final int ROWS_UPDATE = 50000;
    public static final int ROWS_IN_ROWSET = 10000;
    public static final int FETCH_SIZE = 10000;
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String CR = System.getProperty("line.separator");
    @Variable(scope=VariableScope.SYSTEM, description="The name of the history folder in which the Hop local audit manager saves data.")
    public static final String HOP_AUDIT_FOLDER = Const.NVL(System.getProperty("HOP_AUDIT_FOLDER"), System.getProperty("user.dir") + File.separator + "audit");
    @Variable(scope=VariableScope.SYSTEM, description="The name of the history folder in which the Hop local audit manager saves data.")
    public static final String HOP_CONFIG_FOLDER = Const.NVL(System.getProperty("HOP_CONFIG_FOLDER"), System.getProperty("user.dir") + File.separator + "config");
    @Variable(scope=VariableScope.SYSTEM, value="N", description="Set this variable to 'Y' to automatically create config file when it's missing.")
    public static final String HOP_AUTO_CREATE_CONFIG = "HOP_AUTO_CREATE_CONFIG";
    @Variable(scope=VariableScope.SYSTEM, description="The variable which points to the alternative location for the Hop metadata.")
    public static final String HOP_METADATA_FOLDER = "HOP_METADATA_FOLDER";
    @Variable(scope=VariableScope.SYSTEM, description="The variable which points to a shared folder with JDBC drivers in them.")
    public static final String HOP_SHARED_JDBC_FOLDER = "HOP_SHARED_JDBC_FOLDER";
    @Variable(scope=VariableScope.SYSTEM, description="The operating system the hop platform runs on.")
    public static final String HOP_PLATFORM_OS = "HOP_PLATFORM_OS";
    @Variable(scope=VariableScope.SYSTEM, description="The runtime that is being used.")
    public static final String HOP_PLATFORM_RUNTIME = "HOP_PLATFORM_RUNTIME";
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_PLUGIN_BASE_FOLDERS = "plugins";
    public static final Date MIN_DATE = new Date(-2208992400000L);
    public static final Date MAX_DATE = new Date(7258114799468L);
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2199;
    public static final int RIGHT = 400;
    public static final int LENGTH = 350;
    public static final int MARGIN = 4;
    public static final int MIDDLE_PCT = 35;
    public static final int FORM_MARGIN = 5;
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final char DEFAULT_DECIMAL_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getDecimalSeparator();
    public static final char DEFAULT_GROUPING_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getGroupingSeparator();
    public static final String DEFAULT_CURRENCY_SYMBOL = new DecimalFormatSymbols(DEFAULT_LOCALE).getCurrencySymbol();
    public static final String DEFAULT_NUMBER_FORMAT = ((DecimalFormat)NumberFormat.getInstance()).toPattern();
    public static final String NULL_STRING = "";
    public static final String NULL_NUMBER = "";
    public static final String NULL_DATE = "";
    public static final String NULL_BIGNUMBER = "";
    public static final String NULL_BOOLEAN = "";
    public static final String NULL_INTEGER = "";
    public static final String NULL_BINARY = "";
    public static final String NULL_NONE = "";
    public static final int ROUND_HALF_CEILING = -1;
    private static String[] dateFormats;
    private static String[] numberFormats;
    public static final String GENERALIZED_DATE_TIME_FORMAT = "yyyyddMM_hhmmss";
    public static final String GENERALIZED_DATE_TIME_FORMAT_MILLIS = "yyyyddMM_hhmmssSSS";
    public static final String XML_ENCODING = "UTF-8";
    public static final String HOP_CONFIG = "hop-config.json";
    public static final String INTERNAL_VARIABLE_PREFIX = "Internal";
    public static final String INTERNAL_VARIABLE_WORKFLOW_FILENAME_FOLDER = "Internal.Workflow.Filename.Folder";
    public static final String INTERNAL_VARIABLE_WORKFLOW_FILENAME_NAME = "Internal.Workflow.Filename.Name";
    public static final String INTERNAL_VARIABLE_WORKFLOW_NAME = "Internal.Workflow.Name";
    public static final String INTERNAL_VARIABLE_ENTRY_CURRENT_FOLDER = "Internal.Entry.Current.Folder";
    public static final Set<String> INTERNAL_PIPELINE_VARIABLES;
    public static final Set<String> INTERNAL_WORKFLOW_VARIABLES;
    public static final String INTERNAL_VARIABLE_PIPELINE_FILENAME_DIRECTORY = "Internal.Pipeline.Filename.Directory";
    public static final String INTERNAL_VARIABLE_PIPELINE_FILENAME_NAME = "Internal.Pipeline.Filename.Name";
    public static final String INTERNAL_VARIABLE_PIPELINE_NAME = "Internal.Pipeline.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORM_PARTITION_ID = "Internal.Transform.Partition.ID";
    public static final String INTERNAL_VARIABLE_TRANSFORM_PARTITION_NR = "Internal.Transform.Partition.Number";
    public static final String INTERNAL_VARIABLE_TRANSFORM_NAME = "Internal.Transform.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORM_COPYNR = "Internal.Transform.CopyNr";
    public static final int MAX_NR_LOG_LINES = 5000;
    public static final int MAX_NR_HISTORY_LINES = 50;
    public static final int HISTORY_LINES_FETCH_SIZE = 10;
    public static final int MAX_LOG_LINE_TIMEOUT_MINUTES = 720;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int INFO = 3;
    public static final int SHOW_MESSAGE_DIALOG_DB_TEST_DEFAULT = 0;
    public static final int SHOW_MESSAGE_DIALOG_DB_TEST_SUCCESS = 1;
    public static final int NOTE_MARGIN = 5;
    public static final int MAX_UNDO = 100;
    @Variable(value="0", description="The log size limit for all pipelines and workflows that don't have the \"log size limit\" property set in their respective properties.")
    public static final String HOP_LOG_SIZE_LIMIT = "HOP_LOG_SIZE_LIMIT";
    @Variable(description="The name of the variable that defines the timer used for detecting server nodes")
    public static final String HOP_SERVER_DETECTION_TIMER = "HOP_SERVER_DETECTION_TIMER";
    @Variable(value="N", description="NULL vs Empty String. If this setting is set to 'Y', an empty string and null are different. Otherwise they are not")
    public static final String HOP_EMPTY_STRING_DIFFERS_FROM_NULL = "HOP_EMPTY_STRING_DIFFERS_FROM_NULL";
    @Variable(value="N", description="System wide flag to allow lenient string to number conversion for backward compatibility. If this setting is set to 'Y', an string starting with digits will be converted successfully into a number. (example: 192.168.1.1 will be converted into 192 or 192.168 or 192168 depending on the decimal and grouping symbol). The default (N) will be to throw an error if non-numeric symbols are found in the string.")
    public static final String HOP_LENIENT_STRING_TO_NUMBER_CONVERSION = "HOP_LENIENT_STRING_TO_NUMBER_CONVERSION";
    @Variable(description="You can use this variable to speed up hostname lookup. Hostname lookup is performed by Hop so that it is capable of logging the server on which a workflow or pipeline is executed.")
    public static final String HOP_SYSTEM_HOSTNAME = "HOP_SYSTEM_HOSTNAME";
    @Variable(scope=VariableScope.APPLICATION, value="0", description="The maximum number of log lines that are kept internally by Hop. Set to 0 to keep all rows (default)")
    public static final String HOP_MAX_LOG_SIZE_IN_LINES = "HOP_MAX_LOG_SIZE_IN_LINES";
    @Variable(scope=VariableScope.APPLICATION, value="1440", description="The maximum age (in minutes) of a log line while being kept internally by Hop. Set to 0 to keep all rows indefinitely (default)")
    public static final String HOP_MAX_LOG_TIMEOUT_IN_MINUTES = "HOP_MAX_LOG_TIMEOUT_IN_MINUTES";
    @Variable(scope=VariableScope.SYSTEM, value="N", description="Set this variable to 'Y' to redirect stderr to Hop logging.")
    public static final String HOP_REDIRECT_STDERR = "HOP_REDIRECT_STDERR";
    @Variable(scope=VariableScope.SYSTEM, value="N", description="Set this variable to 'Y' to redirect stdout to Hop logging.")
    public static final String HOP_REDIRECT_STDOUT = "HOP_REDIRECT_STDOUT";
    @Variable(scope=VariableScope.SYSTEM, value="N", description="Set this variable to 'Y' to log stack traces in a simpler, more human readable format.")
    public static final String HOP_SIMPLE_STACK_TRACES = "HOP_SIMPLE_STACK_TRACES";
    @Variable(value="1440", description="This project variable will set a time-out after which waiting, completed or stopped pipelines and workflows will be automatically cleaned up. The default value is 1440 (one day).")
    public static final String HOP_SERVER_OBJECT_TIMEOUT_MINUTES = "HOP_SERVER_OBJECT_TIMEOUT_MINUTES";
    @Variable(value="0", description="The maximum number of transform performance snapshots to keep in memory. Set to 0 to keep all snapshots indefinitely (default)")
    public static final String HOP_TRANSFORM_PERFORMANCE_SNAPSHOT_LIMIT = "HOP_TRANSFORM_PERFORMANCE_SNAPSHOT_LIMIT";
    @Variable(value="5000", description="The maximum age (in minutes) of a log line while being kept internally by Hop. Set to 0 to keep all rows indefinitely (default)")
    public static final String HOP_MAX_WORKFLOW_TRACKER_SIZE = "HOP_MAX_WORKFLOW_TRACKER_SIZE";
    @Variable(value="5000", description="The maximum number of action results kept in memory for logging purposes.")
    public static final String HOP_MAX_ACTIONS_LOGGED = "HOP_MAX_ACTIONS_LOGGED";
    @Variable(value="10000", description="The maximum number of logging registry entries kept in memory for logging purposes")
    public static final String HOP_MAX_LOGGING_REGISTRY_SIZE = "HOP_MAX_LOGGING_REGISTRY_SIZE";
    @Variable(scope=VariableScope.APPLICATION, value="1000", description="The hop log tab refresh delay.")
    public static final String HOP_LOG_TAB_REFRESH_DELAY = "HOP_LOG_TAB_REFRESH_DELAY";
    @Variable(scope=VariableScope.APPLICATION, value="1000", description="The hop log tab refresh period.")
    public static final String HOP_LOG_TAB_REFRESH_PERIOD = "HOP_LOG_TAB_REFRESH_PERIOD";
    @Variable(description="A comma delimited list of classes to scan for plugin annotations")
    public static final String HOP_PLUGIN_CLASSES = "HOP_PLUGIN_CLASSES";
    @Variable(scope=VariableScope.SYSTEM, description="The variable which points to the alternative location for plugins.")
    public static final String HOP_PLUGIN_BASE_FOLDERS = "HOP_PLUGIN_BASE_FOLDERS";
    @Variable(description="Name of the environment variable that contains the size of the pipeline rowset size. This overwrites values that you set pipeline settings")
    public static final String HOP_PIPELINE_ROWSET_SIZE = "HOP_PIPELINE_ROWSET_SIZE";
    public static final String VERSION_COMMENT_INITIAL_VERSION = "Creation of initial version";
    public static final String VERSION_COMMENT_EDIT_VERSION = "Modification by user";
    @Variable(value="Hop", description="Specifies the password encoder plugin to use by ID (Hop is the default).")
    public static final String HOP_PASSWORD_ENCODER_PLUGIN = "HOP_PASSWORD_ENCODER_PLUGIN";
    public static final String HOP_TWO_WAY_PASSWORD_ENCODER_SEED = "HOP_TWO_WAY_PASSWORD_ENCODER_SEED";
    @Variable(value="50", description="The name of the variable that optionally contains an alternative rowset get timeout (in ms). This only makes a difference for extremely short lived pipelines.")
    public static final String HOP_ROWSET_GET_TIMEOUT = "HOP_ROWSET_GET_TIMEOUT";
    @Variable(value="50", description="The name of the variable that optionally contains an alternative rowset put timeout (in ms). This only makes a difference for extremely short lived pipelines.")
    public static final String HOP_ROWSET_PUT_TIMEOUT = "HOP_ROWSET_PUT_TIMEOUT";
    @Variable(value="N", description="Set this variable to 'Y' if you want to test a more efficient batching row set.")
    public static final String HOP_BATCHING_ROWSET = "HOP_BATCHING_ROWSET";
    @Variable(value="1024", description="This project variable is used by the Text File Output transform. It defines the max number of simultaneously open files within the transform. The transform will close/reopen files as necessary to insure the max is not exceeded")
    public static final String HOP_FILE_OUTPUT_MAX_STREAM_COUNT = "HOP_FILE_OUTPUT_MAX_STREAM_COUNT";
    @Variable(value="0", description="This project variable is used by the Text File Output transform. It defines the max number of milliseconds between flushes of files opened by the transform.")
    public static final String HOP_FILE_OUTPUT_MAX_STREAM_LIFE = "HOP_FILE_OUTPUT_MAX_STREAM_LIFE";
    @Variable(value="N", description="Set this variable to 'Y' to disable standard Hop logging to the console. (stdout)")
    public static final String HOP_DISABLE_CONSOLE_LOGGING = "HOP_DISABLE_CONSOLE_LOGGING";
    @Variable(description="The name of the variable containing an alternative default number format")
    public static final String HOP_DEFAULT_NUMBER_FORMAT = "HOP_DEFAULT_NUMBER_FORMAT";
    @Variable(description="The name of the variable containing an alternative default bignumber format")
    public static final String HOP_DEFAULT_BIGNUMBER_FORMAT = "HOP_DEFAULT_BIGNUMBER_FORMAT";
    @Variable(description="The name of the variable containing an alternative default integer format")
    public static final String HOP_DEFAULT_INTEGER_FORMAT = "HOP_DEFAULT_INTEGER_FORMAT";
    @Variable(description="The name of the variable containing an alternative default date format")
    public static final String HOP_DEFAULT_DATE_FORMAT = "HOP_DEFAULT_DATE_FORMAT";
    @Variable(value="N", description="Set this variable to 'Y' to set the minimum to NULL if NULL is within an aggregate. Otherwise by default NULL is ignored by the MIN aggregate and MIN is set to the minimum value that is not NULL. See also the variable HOP_AGGREGATION_ALL_NULLS_ARE_ZERO.")
    public static final String HOP_AGGREGATION_MIN_NULL_IS_VALUED = "HOP_AGGREGATION_MIN_NULL_IS_VALUED";
    @Variable(value="N", description="Set this variable to 'Y' to return 0 when all values within an aggregate are NULL. Otherwise by default a NULL is returned when all values are NULL.")
    public static final String HOP_AGGREGATION_ALL_NULLS_ARE_ZERO = "HOP_AGGREGATION_ALL_NULLS_ARE_ZERO";
    @Variable(description="The name of the variable containing an alternative default timestamp format")
    public static final String HOP_DEFAULT_TIMESTAMP_FORMAT = "HOP_DEFAULT_TIMESTAMP_FORMAT";
    @Variable(value="N", description="Set this variable to 'N' to preserve enclosure symbol after splitting the string in the Split fields transform. Changing it to true will remove first and last enclosure symbol from the resulting string chunks.")
    public static final String HOP_SPLIT_FIELDS_REMOVE_ENCLOSURE = "HOP_SPLIT_FIELDS_REMOVE_ENCLOSURE";
    @Variable(value="N", description="Set this variable to 'Y' to allow your pipeline to pass 'null' fields and/or empty types.")
    public static final String HOP_ALLOW_EMPTY_FIELD_NAMES_AND_TYPES = "HOP_ALLOW_EMPTY_FIELD_NAMES_AND_TYPES";
    @Variable(value="N", description="Set this variable to 'N' to preserve global log variables defined in pipeline / workflow Properties -> Log panel. Changing it to 'Y' will clear it when export pipeline / workflow.")
    public static final String HOP_GLOBAL_LOG_VARIABLES_CLEAR_ON_EXPORT = "HOP_GLOBAL_LOG_VARIABLES_CLEAR_ON_EXPORT";
    private static String[] emptyPaddedSpacesStrings;
    public static final ReleaseType RELEASE;
    @Variable(value="N", description="Set this variable to 'Y' to precede transform/action name in log lines with the complete path to the transform/action. Useful to perfectly identify where a problem happened in our process.")
    public static final String HOP_LOG_MARK_MAPPINGS = "HOP_LOG_MARK_MAPPINGS";
    @Variable(description="A variable to configure jetty option: acceptors for Hop server")
    public static final String HOP_SERVER_JETTY_ACCEPTORS = "HOP_SERVER_JETTY_ACCEPTORS";
    @Variable(description="A variable to configure jetty option: acceptQueueSize for Hop server")
    public static final String HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE = "HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE";
    @Variable(description="A variable to configure jetty option: lowResourcesMaxIdleTime for Hop server")
    public static final String HOP_SERVER_JETTY_RES_MAX_IDLE_TIME = "HOP_SERVER_JETTY_RES_MAX_IDLE_TIME";
    @Variable(description="Defines the default encoding for servlets, leave it empty to use Java default encoding")
    public static final String HOP_DEFAULT_SERVLET_ENCODING = "HOP_DEFAULT_SERVLET_ENCODING";
    @Variable(description="A variable to configure refresh for Hop server workflow/pipeline status page")
    public static final String HOP_SERVER_REFRESH_STATUS = "HOP_SERVER_REFRESH_STATUS";
    public static final String S3VFS_USE_TEMPORARY_FILE_ON_UPLOAD_DATA = "s3.vfs.useTempFileOnUploadData";
    @Variable(description="A variable to configure Tab size")
    public static final String HOP_MAX_TAB_LENGTH = "HOP_MAX_TAB_LENGTH";
    public static final String VFS_USER_DIR_IS_ROOT = "vfs.sftp.userDirIsRoot";
    @Variable(description="A variable to configure the minimum allowed ratio between de- and inflated bytes to detect a zipbomb")
    public static final String HOP_ZIP_MIN_INFLATE_RATIO = "HOP_ZIP_MIN_INFLATE_RATIO";
    public static final Double HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT;
    @Variable(description="")
    public static final String HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT_STRING;
    @Variable(description="A variable to configure the maximum file size of a single zip entry")
    public static final String HOP_ZIP_MAX_ENTRY_SIZE = "HOP_ZIP_MAX_ENTRY_SIZE";
    public static final Long HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT;
    @Variable(description="")
    public static final String HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT_STRING;
    @Variable(description="A variable to configure the maximum number of characters of text that are extracted before an exception is thrown during extracting text from documents")
    public static final String HOP_ZIP_MAX_TEXT_SIZE = "HOP_ZIP_MAX_TEXT_SIZE";
    public static final Long HOP_ZIP_MAX_TEXT_SIZE_DEFAULT;
    @Variable(description="")
    public static final String HOP_ZIP_MAX_TEXT_SIZE_DEFAULT_STRING;
    @Variable(description="This is the name of the variable which when set should contains the path to a file which will be included in the serialization of pipelines and workflows")
    public static final String HOP_LICENSE_HEADER_FILE = "HOP_LICENSE_HEADER_FILE";
    public static final String I18N_PREFIX = "i18n:";
    public static final String CONNECTION_GROUP = "CONNECTION_GROUP";
    @Variable(scope=VariableScope.ENGINE, value="20", description="This is the default polling frequency for the transforms input buffer (in ms)")
    public static final String HOP_DEFAULT_BUFFER_POLLING_WAITTIME = "HOP_DEFAULT_BUFFER_POLLING_WAITTIME";
    private static String cachedHostname;

    public static final boolean isUsingSimpleStackTraces() {
        String property = System.getProperty(HOP_SIMPLE_STACK_TRACES);
        return "y".equalsIgnoreCase(property) || "true".equalsIgnoreCase(property);
    }

    public static double round(double f, int places) {
        return Const.round(f, places, 6);
    }

    public static double round(double f, int places, int roundingMode) {
        if (Double.isNaN(f) || f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY) {
            return f;
        }
        BigDecimal bdtemp = Const.round(BigDecimal.valueOf(f), places, roundingMode);
        return bdtemp.doubleValue();
    }

    public static BigDecimal round(BigDecimal f, int places, int roundingMode) {
        if (roundingMode == -1) {
            if (f.signum() >= 0) {
                return Const.round(f, places, 4);
            }
            return Const.round(f, places, 5);
        }
        return f.setScale(places, roundingMode);
    }

    public static long round(long f, int places, int roundingMode) {
        if (places >= 0) {
            return f;
        }
        BigDecimal bdtemp = Const.round(BigDecimal.valueOf(f), places, roundingMode);
        return bdtemp.longValue();
    }

    public static int toInt(String str, int def) {
        int retval;
        if (str == null) {
            return def;
        }
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static long toLong(String str, long def) {
        long retval;
        if (str == null) {
            return def;
        }
        try {
            retval = Long.parseLong(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static double toDouble(String str, double def) {
        double retval;
        if (str == null) {
            return def;
        }
        try {
            retval = Double.parseDouble(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static Date toDate(String str, Date def) {
        if (str == null) {
            return def;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || Character.isWhitespace(c);
    }

    public static String ltrim(String source) {
        int from;
        if (source == null) {
            return null;
        }
        for (from = 0; from < source.length() && Const.isSpace(source.charAt(from)); ++from) {
        }
        return source.substring(from);
    }

    public static String rtrim(String source) {
        int max;
        if (source == null) {
            return null;
        }
        for (max = source.length(); max > 0 && Const.isSpace(source.charAt(max - 1)); --max) {
        }
        return source.substring(0, max);
    }

    public static String trim(String str) {
        int min;
        if (str == null) {
            return null;
        }
        int max = str.length() - 1;
        for (min = 0; min <= max && Const.isSpace(str.charAt(min)); ++min) {
        }
        while (max >= 0 && Const.isSpace(str.charAt(max))) {
            --max;
        }
        if (max < min) {
            return "";
        }
        return str.substring(min, max + 1);
    }

    public static String rightPad(String ret, int limit) {
        if (ret == null) {
            return Const.rightPad(new StringBuilder(), limit);
        }
        return Const.rightPad(new StringBuilder(ret), limit);
    }

    public static String rightPad(StringBuffer ret, int limit) {
        if (ret != null) {
            while (ret.length() < limit) {
                ret.append("                    ");
            }
            ret.setLength(limit);
            return ret.toString();
        }
        return null;
    }

    public static String rightPad(StringBuilder ret, int limit) {
        if (ret != null) {
            while (ret.length() < limit) {
                ret.append("                    ");
            }
            ret.setLength(limit);
            return ret.toString();
        }
        return null;
    }

    public static String replace(String string, String repl, String with) {
        if (string != null && repl != null && with != null) {
            return string.replaceAll(Pattern.quote(repl), Matcher.quoteReplacement(with));
        }
        return null;
    }

    public static void repl(StringBuffer str, String code, String repl) {
        if (code == null || repl == null || code.length() == 0 || repl.length() == 0 || str == null || str.length() == 0) {
            return;
        }
        String aString = str.toString();
        str.setLength(0);
        str.append(aString.replaceAll(Pattern.quote(code), Matcher.quoteReplacement(repl)));
    }

    public static void repl(StringBuilder str, String code, String repl) {
        if (code == null || repl == null || str == null) {
            return;
        }
        String aString = str.toString();
        str.setLength(0);
        str.append(aString.replaceAll(Pattern.quote(code), Matcher.quoteReplacement(repl)));
    }

    public static int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getSystemOs() {
        return System.getProperty("os.name");
    }

    public static String getHopPlatformOs() {
        return System.getProperty(HOP_PLATFORM_OS, "");
    }

    public static String getHopPlatformRuntime() {
        return System.getProperty(HOP_PLATFORM_RUNTIME);
    }

    public static String getQuoteCharByOS() {
        if (Const.isWindows()) {
            return "\"";
        }
        return "'";
    }

    public static String optionallyQuoteStringByOS(String string) {
        String quote = Const.getQuoteCharByOS();
        if (Utils.isEmpty(string)) {
            return quote;
        }
        if (string.contains(quote) || string.indexOf(32) < 0 && string.indexOf(61) < 0) {
            return string;
        }
        return quote + string + quote;
    }

    public static boolean isWindows() {
        return Const.getHopPlatformOs().startsWith("Windows") || Const.getSystemOs().startsWith("Windows");
    }

    public static boolean isLinux() {
        return Const.getHopPlatformOs().startsWith("Linux") || Const.getSystemOs().startsWith("Linux");
    }

    public static boolean isOSX() {
        return Const.getHopPlatformOs().startsWith("Darwin") || Const.getSystemOs().toUpperCase().contains("OS X");
    }

    public static boolean isKDE() {
        return StringUtils.isNotBlank((String)System.getenv("KDE_SESSION_VERSION"));
    }

    public static String getHostname() {
        if (cachedHostname != null) {
            return cachedHostname;
        }
        String systemHostname = EnvUtil.getSystemProperty(HOP_SYSTEM_HOSTNAME);
        if (!Utils.isEmpty(systemHostname)) {
            cachedHostname = systemHostname;
            return systemHostname;
        }
        String lastHostname = "localhost";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                InetAddress in;
                NetworkInterface nwi = en.nextElement();
                Enumeration<InetAddress> ip = nwi.getInetAddresses();
                while (ip.hasMoreElements() && ((lastHostname = (in = ip.nextElement()).getHostName()).equalsIgnoreCase("localhost") || lastHostname.indexOf(58) >= 0)) {
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        cachedHostname = lastHostname;
        return lastHostname;
    }

    public static String getHostnameReal() {
        String systemHostname = EnvUtil.getSystemProperty(HOP_SYSTEM_HOSTNAME);
        if (!Utils.isEmpty(systemHostname)) {
            return systemHostname;
        }
        if (Const.isWindows()) {
            return System.getenv("COMPUTERNAME");
        }
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null) {
            return hostname;
        }
        try {
            Process pr = Runtime.getRuntime().exec("hostname");
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = br.readLine();
            if (line != null) {
                return line;
            }
            pr.waitFor();
            br.close();
        }
        catch (IOException | InterruptedException e) {
            return Const.getHostname();
        }
        return Const.getHostname();
    }

    public static String getIPAddress() throws Exception {
        Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
        while (enumInterfaces.hasMoreElements()) {
            NetworkInterface nwi = enumInterfaces.nextElement();
            Enumeration<InetAddress> ip = nwi.getInetAddresses();
            while (ip.hasMoreElements()) {
                InetAddress in = ip.nextElement();
                if (in.isLoopbackAddress() || in.toString().indexOf(58) >= 0) continue;
                return in.getHostAddress();
            }
        }
        return "127.0.0.1";
    }

    public static String getIPAddress(String networkInterfaceName) throws SocketException {
        NetworkInterface networkInterface = NetworkInterface.getByName(networkInterfaceName);
        Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
        while (ipAddresses.hasMoreElements()) {
            InetAddress inetAddress = ipAddresses.nextElement();
            if (inetAddress.isLoopbackAddress() || inetAddress.toString().indexOf(58) >= 0) continue;
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static String getMACAddress() throws Exception {
        String ip = Const.getIPAddress();
        String mac = "none";
        String os = Const.getSystemOs();
        String s = "";
        boolean errorOccured = false;
        if (os.equalsIgnoreCase("Windows NT") || os.equalsIgnoreCase("Windows 2000") || os.equalsIgnoreCase("Windows XP") || os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows 98") || os.equalsIgnoreCase("Windows Me") || os.startsWith("Windows")) {
            try {
                Process p = Runtime.getRuntime().exec("nbtstat -a " + ip);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (!s.contains("MAC")) continue;
                        int idx = s.indexOf(61);
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("Linux")) {
            try {
                Process p = Runtime.getRuntime().exec("/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("HWaddr");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 7);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("Solaris")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("ether");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 6);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("HP-UX")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/lanscan -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (!s.contains("MAC")) continue;
                        int idx = s.indexOf("0x");
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        }
        return Const.trim(mac);
    }

    private static final boolean procDone(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static String getHopLocalServerPasswordFile() {
        return "pwd/hop.pwd";
    }

    public static String getBaseDocUrl() {
        String url = BaseMessages.getString(PKG, "Const.BaseDocUrl", new String[0]);
        String version = Const.class.getPackage().getImplementationVersion();
        if (version == null || version.endsWith("SNAPSHOT")) {
            version = "next";
        }
        return url + version + "/";
    }

    public static String getDocUrl(String uri) {
        Object docUrl = Const.getBaseDocUrl();
        if (!Utils.isEmpty(uri)) {
            docUrl = uri.startsWith("http") ? uri : (uri.startsWith("/") ? (String)docUrl + uri.substring(1) : (String)docUrl + uri);
        }
        return docUrl;
    }

    public static String getEnvironmentVariable(String variable, String deflt) {
        return System.getProperty(variable, deflt);
    }

    public static String NVL(String source, String def) {
        if (source == null || source.length() == 0) {
            return def;
        }
        return source;
    }

    public static String nullToEmpty(String source) {
        if (source == null) {
            return "";
        }
        return source;
    }

    public static int indexOfString(String lookup, String[] array) {
        if (array == null) {
            return -1;
        }
        if (lookup == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookup.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int[] indexsOfStrings(String[] lookup, String[] array) {
        int[] indexes = new int[lookup.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Const.indexOfString(lookup[i], array);
        }
        return indexes;
    }

    public static int[] indexesOfFoundStrings(String[] lookup, String[] array) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int i = 0; i < lookup.length; ++i) {
            int idx = Const.indexOfString(lookup[i], array);
            if (idx < 0) continue;
            indexesList.add(idx);
        }
        int[] indexes = new int[indexesList.size()];
        for (int i = 0; i < indexesList.size(); ++i) {
            indexes[i] = (Integer)indexesList.get(i);
        }
        return indexes;
    }

    public static List<Integer> indexesOfFoundStrings(List<String> lookup, List<String> list) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int i = 0; i < lookup.size(); ++i) {
            int idx = Const.indexOfString(lookup.get(i), list);
            if (idx < 0) continue;
            indexesList.add(idx);
        }
        int[] indexes = new int[indexesList.size()];
        for (int i = 0; i < indexesList.size(); ++i) {
            indexes[i] = (Integer)indexesList.get(i);
        }
        return indexesList;
    }

    public static int indexOfString(String lookup, List<String> list) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String compare = list.get(i);
            if (!lookup.equalsIgnoreCase(compare)) continue;
            return i;
        }
        return -1;
    }

    public static String[] sortStrings(String[] input) {
        Arrays.sort(input);
        return input;
    }

    public static String[] splitString(String string, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int sepLen = separator.length();
        int from = 0;
        int end = string.length() - sepLen + 1;
        for (int i = from; i < end; i += sepLen) {
            if (!string.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            list.add(Const.nullToEmpty(string.substring(from, i)));
            from = i + sepLen;
        }
        if (from + sepLen <= string.length()) {
            list.add(Const.nullToEmpty(string.substring(from, string.length())));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitString(String string, char separator) {
        return Const.splitString(string, separator, false);
    }

    public static String[] splitString(String string, char separator, boolean escape) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int from = 0;
        int end = string.length();
        for (int i = from; i < end; ++i) {
            boolean found;
            boolean bl = found = string.charAt(i) == separator;
            if (found && escape && i > 0) {
                found &= string.charAt(i - 1) != '\\';
            }
            if (!found) continue;
            list.add(Const.nullToEmpty(string.substring(from, i)));
            from = i + 1;
        }
        if (from + 1 <= string.length()) {
            list.add(Const.nullToEmpty(string.substring(from, string.length())));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitPath(String path, String separator) {
        int from;
        if (path == null || path.length() == 0 || path.equals(separator)) {
            return new String[0];
        }
        while (path.endsWith(separator)) {
            path = path.substring(0, path.length() - 1);
        }
        int sepLen = separator.length();
        int nrSeparators = 1;
        for (int i = from = path.startsWith(separator) ? sepLen : 0; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            ++nrSeparators;
        }
        String[] spath = new String[nrSeparators];
        int nr = 0;
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            spath[nr] = path.substring(from, i);
            ++nr;
            from = i + sepLen;
        }
        if (nr < spath.length) {
            spath[nr] = path.substring(from);
        }
        if (spath.length == 0 && path.length() > 0) {
            spath = new String[]{path};
        }
        return spath;
    }

    public static String[] splitString(String stringToSplit, String delimiter, String enclosure) {
        return Const.splitString(stringToSplit, delimiter, enclosure, false);
    }

    public static String[] splitString(String stringToSplit, String delimiter, String enclosure, boolean removeEnclosure) {
        return Const.splitString(stringToSplit, delimiter, enclosure, removeEnclosure, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitString(String stringToSplit, String delimiter, String enclosure, boolean removeEnclosure, String escape) {
        ArrayList<String> splitList = null;
        boolean withEnclosure = StringUtils.isNotEmpty((String)enclosure);
        boolean withEscape = StringUtils.isNotEmpty((String)escape);
        boolean concatWithNext = false;
        if (stringToSplit == null) {
            return null;
        }
        if (delimiter == null) {
            return new String[]{stringToSplit};
        }
        String[] delimiterSplit = stringToSplit.split(Pattern.quote(delimiter));
        StringBuilder concatSplit = null;
        if (delimiterSplit != null && delimiterSplit.length > 0) {
            splitList = new ArrayList<String>();
            for (String string : delimiterSplit) {
                boolean oddNumberOfEnclosures;
                void var14_14;
                if (withEnclosure && !string.contains(enclosure)) {
                    if (concatSplit != null) {
                        concatSplit.append(delimiter);
                        concatSplit.append(string);
                        continue;
                    }
                    splitList.add(string);
                    continue;
                }
                boolean addSplit = false;
                if (withEscape) {
                    if (concatWithNext) {
                        concatWithNext = false;
                        addSplit = true;
                    }
                    if (string.equals(escape)) {
                        String string2 = delimiter;
                        concatWithNext = true;
                    } else if (string.endsWith(escape)) {
                        String string3 = string.substring(0, string.length() - escape.length()) + delimiter;
                        concatWithNext = true;
                    }
                    if (addSplit) {
                        void var14_18;
                        int lastSplitIndex = splitList.size() - 1;
                        String string4 = (String)splitList.get(lastSplitIndex) + (String)var14_18;
                        splitList.remove(lastSplitIndex);
                    }
                }
                int numEnclosures = withEnclosure ? StringUtils.countMatches((String)var14_14, (String)enclosure) : 0;
                boolean bl = oddNumberOfEnclosures = numEnclosures % 2 != 0;
                if (concatSplit == null) {
                    concatSplit = new StringBuilder((String)var14_14);
                    addSplit |= !oddNumberOfEnclosures;
                } else {
                    concatSplit.append(delimiter);
                    concatSplit.append((String)var14_14);
                    addSplit = oddNumberOfEnclosures;
                }
                if (!addSplit) continue;
                String splitResult = concatSplit.toString();
                if (withEnclosure && removeEnclosure) {
                    splitResult = Const.removeEnclosure(splitResult, enclosure);
                }
                splitList.add(splitResult);
                concatSplit = null;
                addSplit = false;
            }
        }
        return splitList != null ? splitList.toArray(new String[splitList.size()]) : new String[]{};
    }

    private static String removeEnclosure(String stringToSplit, String enclosure) {
        int lastIndex;
        int firstIndex = stringToSplit.indexOf(enclosure);
        if (firstIndex == (lastIndex = stringToSplit.lastIndexOf(enclosure))) {
            return stringToSplit;
        }
        StrBuilder strBuilder = new StrBuilder(stringToSplit);
        strBuilder.replace(firstIndex, enclosure.length() + firstIndex, "");
        strBuilder.replace(lastIndex - enclosure.length(), lastIndex, "");
        return strBuilder.toString();
    }

    public static String[] getDistinctStrings(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return new String[0];
        }
        HashSet set = new HashSet();
        Collections.addAll(set, strings);
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        return list.toArray(new String[0]);
    }

    public static String getStackTracker(Throwable e) {
        if (Const.isUsingSimpleStackTraces()) {
            return Const.getSimpleStackTrace(e);
        }
        return Const.getClassicStackTrace(e);
    }

    public static String getClassicStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String string = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String getSimpleStackTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder();
        result.append(ExceptionUtils.getMessage((Throwable)aThrowable));
        result.append(CR);
        result.append("Root cause: ");
        result.append(ExceptionUtils.getRootCauseMessage((Throwable)aThrowable));
        return result.toString();
    }

    public static String createFilename(String name) {
        StringBuilder filename = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                filename.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            filename.append('_');
        }
        return filename.toString().toLowerCase();
    }

    public static String createFilename(String directory, String name, String extension) {
        if (directory.endsWith(FILE_SEPARATOR)) {
            return directory + Const.createFilename(name) + extension;
        }
        return directory + FILE_SEPARATOR + Const.createFilename(name) + extension;
    }

    public static String createName(String filename) {
        if (Utils.isEmpty(filename)) {
            return filename;
        }
        String pureFilename = Const.filenameOnly(filename);
        if (pureFilename.endsWith(".hpl") || pureFilename.endsWith(".hwf") || pureFilename.endsWith(".xml")) {
            pureFilename = pureFilename.substring(0, pureFilename.length() - 4);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pureFilename.length(); ++i) {
            char c = pureFilename.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append(' ');
                continue;
            }
            if (c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String filenameOnly(String sFullPath) {
        if (Utils.isEmpty(sFullPath)) {
            return sFullPath;
        }
        int idx = sFullPath.lastIndexOf(FILE_SEPARATOR);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        idx = sFullPath.lastIndexOf(47);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        return sFullPath;
    }

    public static String[] getDateFormats() {
        if (dateFormats == null) {
            int dateFormatsCount = Const.toInt(BaseMessages.getString(PKG, "Const.DateFormat.Count", new String[0]), 0);
            dateFormats = new String[dateFormatsCount];
            for (int i = 1; i <= dateFormatsCount; ++i) {
                Const.dateFormats[i - 1] = BaseMessages.getString(PKG, "Const.DateFormat" + Integer.toString(i), new String[0]);
            }
        }
        return dateFormats;
    }

    public static String[] getNumberFormats() {
        if (numberFormats == null) {
            int numberFormatsCount = Const.toInt(BaseMessages.getString(PKG, "Const.NumberFormat.Count", new String[0]), 0);
            numberFormats = new String[numberFormatsCount + 1];
            Const.numberFormats[0] = DEFAULT_NUMBER_FORMAT;
            for (int i = 1; i <= numberFormatsCount; ++i) {
                Const.numberFormats[i] = BaseMessages.getString(PKG, "Const.NumberFormat" + Integer.toString(i), new String[0]);
            }
        }
        return numberFormats;
    }

    public static String[] getConversionFormats() {
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        System.arraycopy(dats, 0, formats, 0, dats.length);
        for (int x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        return formats;
    }

    public static String trimToType(String string, int trimType) {
        switch (trimType) {
            case 3: {
                return Const.trim(string);
            }
            case 1: {
                return Const.ltrim(string);
            }
            case 2: {
                return Const.rtrim(string);
            }
        }
        return string;
    }

    public static String safeAppendDirectory(String dir, String file) {
        boolean fileHasSeparator;
        boolean dirHasSeparator = dir.lastIndexOf(FILE_SEPARATOR) == dir.length() - 1;
        boolean bl = fileHasSeparator = file.indexOf(FILE_SEPARATOR) == 0;
        if (dirHasSeparator && !fileHasSeparator || !dirHasSeparator && fileHasSeparator) {
            return dir + file;
        }
        if (dirHasSeparator && fileHasSeparator) {
            return dir + file.substring(1);
        }
        return dir + FILE_SEPARATOR + file;
    }

    public static String[] getEmptyPaddedStrings() {
        if (emptyPaddedSpacesStrings == null) {
            emptyPaddedSpacesStrings = new String[250];
            for (int i = 0; i < emptyPaddedSpacesStrings.length; ++i) {
                Const.emptyPaddedSpacesStrings[i] = Const.rightPad("", i);
            }
        }
        return emptyPaddedSpacesStrings;
    }

    public static int getPercentageFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long totalFreeMemory = freeMemory + (maxMemory - allocatedMemory);
        return (int)Math.round(100.0 * (double)totalFreeMemory / (double)maxMemory);
    }

    public static String removeDigits(String input) {
        if (Utils.isEmpty(input)) {
            return null;
        }
        StringBuilder digitsOnly = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static String getDigitsOnly(String input) {
        if (Utils.isEmpty(input)) {
            return null;
        }
        StringBuilder digitsOnly = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static Date removeTimeFromDate(Date input) {
        if (input == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(input);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String escapeHtml(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeHtml((String)content);
    }

    public static String unEscapeHtml(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.unescapeHtml((String)content);
    }

    public static String unEscapeXml(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.unescapeXml((String)content);
    }

    public static String escapeSql(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeSql((String)content);
    }

    public static String removeCRLF(String in) {
        if (in != null && in.length() > 0) {
            int inLen = in.length();
            int posn = 0;
            char[] tmp = new char[inLen];
            for (int i = 0; i < inLen; ++i) {
                char ch = in.charAt(i);
                if (ch == '\n' || ch == '\r') continue;
                tmp[posn] = ch;
                ++posn;
            }
            return new String(tmp, 0, posn);
        }
        return "";
    }

    public static String removeChar(String in, char badChar) {
        if (in != null && in.length() > 0) {
            int inLen = in.length();
            int posn = 0;
            char[] tmp = new char[inLen];
            for (int i = 0; i < inLen; ++i) {
                char ch = in.charAt(i);
                if (ch == badChar) continue;
                tmp[posn] = ch;
                ++posn;
            }
            return new String(tmp, 0, posn);
        }
        return "";
    }

    public static String removeCR(String in) {
        return Const.removeChar(in, '\r');
    }

    public static String removeLF(String in) {
        return Const.removeChar(in, '\n');
    }

    public static String removeTAB(String in) {
        return Const.removeChar(in, '\t');
    }

    public static Date addTimeToDate(Date input, String time, String dateFormat) throws HopException {
        if (Utils.isEmpty(time)) {
            return input;
        }
        if (input == null) {
            return null;
        }
        String dateformatString = Const.NVL(dateFormat, "HH:mm:ss");
        int t = Const.decodeTime(time, dateformatString);
        return new Date(input.getTime() + (long)t);
    }

    public static int decodeTime(String s, String dateFormat) throws HopException {
        SimpleDateFormat f = new SimpleDateFormat(dateFormat);
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        f.setTimeZone(utcTimeZone);
        f.setLenient(false);
        ParsePosition p = new ParsePosition(0);
        Date d = f.parse(s, p);
        if (d == null) {
            throw new HopException("Invalid time value " + dateFormat + ": \"" + s + "\".");
        }
        return (int)d.getTime();
    }

    public static int getOccurenceString(String string, String searchFor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int counter = 0;
        int len = searchFor.length();
        if (len > 0) {
            int start = string.indexOf(searchFor);
            while (start != -1) {
                ++counter;
                start = string.indexOf(searchFor, start + len);
            }
        }
        return counter;
    }

    public static String[] getAvailableFontNames() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        String[] fontName = new String[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            fontName[i] = fonts[i].getFontName();
        }
        return fontName;
    }

    public static String protectXmlCdata(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return "<![CDATA[" + content + "]]>";
    }

    public static int getOcuranceString(String string, String searchFor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Pattern p = Pattern.compile(searchFor);
        Matcher m = p.matcher(string);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String escapeXml(String content) {
        if (Utils.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeXml((String)content);
    }

    public static String lpad(String valueToPad, String filler, int size) {
        if (size == 0 || valueToPad == null || filler == null) {
            return valueToPad;
        }
        int vSize = valueToPad.length();
        int fSize = filler.length();
        if (vSize >= size || fSize == 0) {
            return valueToPad;
        }
        int tgt = size - vSize;
        StringBuilder sb = new StringBuilder(size);
        sb.append(filler);
        while (sb.length() < tgt) {
            sb.append((CharSequence)sb);
        }
        sb.append(valueToPad);
        return sb.substring(Math.max(0, sb.length() - size));
    }

    public static String rpad(String valueToPad, String filler, int size) {
        if (size == 0 || valueToPad == null || filler == null) {
            return valueToPad;
        }
        int vSize = valueToPad.length();
        int fSize = filler.length();
        if (vSize >= size || fSize == 0) {
            return valueToPad;
        }
        int tgt = size - vSize;
        StringBuilder sb1 = new StringBuilder(size);
        sb1.append(filler);
        while (sb1.length() < tgt) {
            sb1.append((CharSequence)sb1);
        }
        StringBuilder sb = new StringBuilder(valueToPad);
        sb.append((CharSequence)sb1);
        return sb.substring(0, size);
    }

    public static boolean classIsOrExtends(Class<?> clazz, Class<?> superClass) {
        if (clazz.equals(Object.class)) {
            return false;
        }
        return clazz.equals(superClass) || Const.classIsOrExtends(clazz.getSuperclass(), superClass);
    }

    public static String getDeprecatedPrefix() {
        return " " + BaseMessages.getString(PKG, "Const.Deprecated", new String[0]);
    }

    static {
        INTERNAL_PIPELINE_VARIABLES = Set.of(INTERNAL_VARIABLE_ENTRY_CURRENT_FOLDER, INTERNAL_VARIABLE_PIPELINE_FILENAME_DIRECTORY, INTERNAL_VARIABLE_PIPELINE_FILENAME_NAME, INTERNAL_VARIABLE_PIPELINE_NAME);
        INTERNAL_WORKFLOW_VARIABLES = Set.of(INTERNAL_VARIABLE_ENTRY_CURRENT_FOLDER, INTERNAL_VARIABLE_WORKFLOW_FILENAME_FOLDER, INTERNAL_VARIABLE_WORKFLOW_FILENAME_NAME, INTERNAL_VARIABLE_WORKFLOW_NAME);
        RELEASE = ReleaseType.GA;
        HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT = 0.01;
        HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT_STRING = String.valueOf(HOP_ZIP_MIN_INFLATE_RATIO_DEFAULT);
        HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT = 0xFFFFFFFFL;
        HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT_STRING = String.valueOf(HOP_ZIP_MAX_ENTRY_SIZE_DEFAULT);
        HOP_ZIP_MAX_TEXT_SIZE_DEFAULT = 0xA00000L;
        HOP_ZIP_MAX_TEXT_SIZE_DEFAULT_STRING = String.valueOf(HOP_ZIP_MAX_TEXT_SIZE_DEFAULT);
    }

    public static enum ReleaseType {
        RELEASE_CANDIDATE{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.PreviewRelease.HelpAboutText", new String[0]);
            }
        }
        ,
        MILESTONE{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.Candidate.HelpAboutText", new String[0]);
            }
        }
        ,
        PREVIEW{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.Milestone.HelpAboutText", new String[0]);
            }
        }
        ,
        GA{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.GA.HelpAboutText", new String[0]);
            }
        };


        public abstract String getMessage();
    }
}

