/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class Result
implements Cloneable {
    public static final String XML_TAG = "result";
    public static final String XML_FILES_TAG = "result-file";
    public static final String XML_FILE_TAG = "result-file";
    public static final String XML_ROWS_TAG = "result-rows";
    private long nrErrors = 0L;
    private long nrLinesInput = 0L;
    private long nrLinesOutput = 0L;
    private long nrLinesUpdated = 0L;
    private long nrLinesRead = 0L;
    private long nrLinesWritten = 0L;
    private long nrLinesDeleted;
    private long nrFilesRetrieved;
    private boolean result = false;
    private long entryNr = 0L;
    private int exitStatus = 0;
    private List<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
    private Map<String, ResultFile> resultFiles = new ConcurrentHashMap<String, ResultFile>();
    public boolean stopped = false;
    private long nrLinesRejected;
    private String logChannelId;
    private String logText;
    private long elapsedTimeMillis;
    private String executionId;

    public Result() {
    }

    public Result(int nr) {
        this();
        this.entryNr = nr;
    }

    public Result lightClone() {
        try {
            Result result = (Result)super.clone();
            result.setRows(null);
            if (this.resultFiles != null) {
                ConcurrentHashMap<String, ResultFile> clonedFiles = new ConcurrentHashMap<String, ResultFile>();
                Collection<ResultFile> files = this.resultFiles.values();
                for (ResultFile file : files) {
                    clonedFiles.put(file.getFile().toString(), file.clone());
                }
                result.setResultFiles(clonedFiles);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Result clone() {
        try {
            Result result = (Result)super.clone();
            if (this.rows != null) {
                ArrayList<RowMetaAndData> clonedRows = new ArrayList<RowMetaAndData>();
                for (int i = 0; i < this.rows.size(); ++i) {
                    clonedRows.add(this.rows.get(i).clone());
                }
                result.setRows(clonedRows);
            }
            if (this.resultFiles != null) {
                ConcurrentHashMap<String, ResultFile> clonedFiles = new ConcurrentHashMap<String, ResultFile>();
                Collection<ResultFile> files = this.resultFiles.values();
                for (ResultFile file : files) {
                    clonedFiles.put(file.getFile().toString(), file.clone());
                }
                result.setResultFiles(clonedFiles);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "nr=" + this.entryNr + ", errors=" + this.nrErrors + ", exit_status=" + this.exitStatus + (String)(this.stopped ? " (Stopped)" : ", result=" + this.result);
    }

    public long getNrFilesRetrieved() {
        return this.nrFilesRetrieved;
    }

    public void setNrFilesRetrieved(long filesRetrieved) {
        this.nrFilesRetrieved = filesRetrieved;
    }

    public long getEntryNr() {
        return this.entryNr;
    }

    public void setEntryNr(long entryNr) {
        this.entryNr = entryNr;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public long getNrErrors() {
        return this.nrErrors;
    }

    public void setNrErrors(long nrErrors) {
        this.nrErrors = nrErrors;
    }

    public long getNrLinesInput() {
        return this.nrLinesInput;
    }

    public void setNrLinesInput(long nrLinesInput) {
        this.nrLinesInput = nrLinesInput;
    }

    public long getNrLinesOutput() {
        return this.nrLinesOutput;
    }

    public void setNrLinesOutput(long nrLinesOutput) {
        this.nrLinesOutput = nrLinesOutput;
    }

    public long getNrLinesRead() {
        return this.nrLinesRead;
    }

    public void setNrLinesRead(long nrLinesRead) {
        this.nrLinesRead = nrLinesRead;
    }

    public long getNrLinesUpdated() {
        return this.nrLinesUpdated;
    }

    public void setNrLinesUpdated(long nrLinesUpdated) {
        this.nrLinesUpdated = nrLinesUpdated;
    }

    public long getNrLinesWritten() {
        return this.nrLinesWritten;
    }

    public void setNrLinesWritten(long nrLinesWritten) {
        this.nrLinesWritten = nrLinesWritten;
    }

    public long getNrLinesDeleted() {
        return this.nrLinesDeleted;
    }

    public void setNrLinesDeleted(long nrLinesDeleted) {
        this.nrLinesDeleted = nrLinesDeleted;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public List<RowMetaAndData> getRows() {
        return this.rows;
    }

    public void setRows(List<RowMetaAndData> rows) {
        this.rows = rows;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void clear() {
        this.nrLinesInput = 0L;
        this.nrLinesOutput = 0L;
        this.nrLinesRead = 0L;
        this.nrLinesWritten = 0L;
        this.nrLinesUpdated = 0L;
        this.nrLinesRejected = 0L;
        this.nrLinesDeleted = 0L;
        this.nrErrors = 0L;
        this.nrFilesRetrieved = 0L;
        this.logText = null;
    }

    public void add(Result res) {
        this.nrLinesInput += res.getNrLinesInput();
        this.nrLinesOutput += res.getNrLinesOutput();
        this.nrLinesRead += res.getNrLinesRead();
        this.nrLinesWritten += res.getNrLinesWritten();
        this.nrLinesUpdated += res.getNrLinesUpdated();
        this.nrLinesRejected += res.getNrLinesRejected();
        this.nrLinesDeleted += res.getNrLinesDeleted();
        this.nrErrors += res.getNrErrors();
        this.nrFilesRetrieved += res.getNrFilesRetrieved();
        this.resultFiles.putAll(res.getResultFiles());
        this.logChannelId = res.getLogChannelId();
        this.logText = res.getLogText();
        this.rows.addAll(res.getRows());
    }

    @JsonIgnore
    public String getXml() {
        try {
            StringBuilder xml = new StringBuilder();
            xml.append(XmlHandler.openTag(XML_TAG));
            this.setBasicXmlAttrs(xml);
            xml.append(XmlHandler.openTag("result-file"));
            for (ResultFile resultFile : this.resultFiles.values()) {
                xml.append(resultFile.getXml());
            }
            xml.append(XmlHandler.closeTag("result-file"));
            xml.append(XmlHandler.openTag(XML_ROWS_TAG));
            boolean firstRow = true;
            IRowMeta rowMeta = null;
            for (RowMetaAndData row : this.rows) {
                if (firstRow) {
                    firstRow = false;
                    rowMeta = row.getRowMeta();
                    xml.append(rowMeta.getMetaXml());
                }
                xml.append(rowMeta.getDataXml(row.getData()));
            }
            xml.append(XmlHandler.closeTag(XML_ROWS_TAG));
            xml.append(XmlHandler.closeTag(XML_TAG));
            return xml.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error encoding workflow result as XML", e);
        }
    }

    private StringBuilder setBasicXmlAttrs(StringBuilder xml) {
        xml.append(XmlHandler.addTagValue("lines_input", this.nrLinesInput));
        xml.append(XmlHandler.addTagValue("lines_output", this.nrLinesOutput));
        xml.append(XmlHandler.addTagValue("lines_read", this.nrLinesRead));
        xml.append(XmlHandler.addTagValue("lines_written", this.nrLinesWritten));
        xml.append(XmlHandler.addTagValue("lines_updated", this.nrLinesUpdated));
        xml.append(XmlHandler.addTagValue("lines_rejected", this.nrLinesRejected));
        xml.append(XmlHandler.addTagValue("lines_deleted", this.nrLinesDeleted));
        xml.append(XmlHandler.addTagValue("nr_errors", this.nrErrors));
        xml.append(XmlHandler.addTagValue("nr_files_retrieved", this.nrFilesRetrieved));
        xml.append(XmlHandler.addTagValue("entry_nr", this.entryNr));
        xml.append(XmlHandler.addTagValue(XML_TAG, this.result));
        xml.append(XmlHandler.addTagValue("exit_status", this.exitStatus));
        xml.append(XmlHandler.addTagValue("is_stopped", this.stopped));
        xml.append(XmlHandler.addTagValue("log_channel_id", this.logChannelId));
        xml.append(XmlHandler.addTagValue("log_text", this.logText));
        xml.append(XmlHandler.addTagValue("elapsedTimeMillis", this.elapsedTimeMillis));
        xml.append(XmlHandler.addTagValue("executionId", this.executionId));
        return xml;
    }

    @JsonIgnore
    public String getBasicXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag(XML_TAG));
        this.setBasicXmlAttrs(xml);
        xml.append(XmlHandler.closeTag(XML_TAG));
        return xml.toString();
    }

    public Result(Node node) throws HopException {
        this();
        this.nrLinesInput = Const.toLong(XmlHandler.getTagValue(node, "lines_input"), 0L);
        this.nrLinesOutput = Const.toLong(XmlHandler.getTagValue(node, "lines_output"), 0L);
        this.nrLinesRead = Const.toLong(XmlHandler.getTagValue(node, "lines_read"), 0L);
        this.nrLinesWritten = Const.toLong(XmlHandler.getTagValue(node, "lines_written"), 0L);
        this.nrLinesUpdated = Const.toLong(XmlHandler.getTagValue(node, "lines_updated"), 0L);
        this.nrLinesRejected = Const.toLong(XmlHandler.getTagValue(node, "lines_rejected"), 0L);
        this.nrLinesDeleted = Const.toLong(XmlHandler.getTagValue(node, "lines_deleted"), 0L);
        this.nrErrors = Const.toLong(XmlHandler.getTagValue(node, "nr_errors"), 0L);
        this.nrFilesRetrieved = Const.toLong(XmlHandler.getTagValue(node, "nr_files_retrieved"), 0L);
        this.entryNr = Const.toLong(XmlHandler.getTagValue(node, "entry_nr"), 0L);
        this.result = "Y".equalsIgnoreCase(XmlHandler.getTagValue(node, XML_TAG));
        this.exitStatus = Integer.parseInt(XmlHandler.getTagValue(node, "exit_status"));
        this.stopped = "Y".equalsIgnoreCase(XmlHandler.getTagValue(node, "is_stopped"));
        this.logChannelId = XmlHandler.getTagValue(node, "log_channel_id");
        this.logText = XmlHandler.getTagValue(node, "log_text");
        this.elapsedTimeMillis = Const.toLong(XmlHandler.getTagValue(node, "elapsedTimeMillis"), 0L);
        this.executionId = XmlHandler.getTagValue(node, "executionId");
        Node resultFilesNode = XmlHandler.getSubNode(node, "result-file");
        int nrResultFiles = XmlHandler.countNodes(resultFilesNode, "result-file");
        for (int i = 0; i < nrResultFiles; ++i) {
            try {
                ResultFile resultFile = new ResultFile(XmlHandler.getSubNodeByNr(resultFilesNode, "result-file", i));
                this.resultFiles.put(resultFile.getFile().toString(), resultFile);
                continue;
            }
            catch (HopFileException e) {
                throw new HopException("Unexpected error reading back a ResultFile object from XML", e);
            }
        }
        Node resultRowsNode = XmlHandler.getSubNode(node, XML_ROWS_TAG);
        List<Node> resultNodes = XmlHandler.getNodes(resultRowsNode, "row-data");
        if (!resultNodes.isEmpty()) {
            RowMeta rowMeta = new RowMeta(XmlHandler.getSubNode(resultRowsNode, "row-meta"));
            for (Node resultNode : resultNodes) {
                Object[] rowData = rowMeta.getRow(resultNode);
                this.rows.add(new RowMetaAndData(rowMeta, rowData));
            }
        }
    }

    public Map<String, ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    @JsonIgnore
    public List<ResultFile> getResultFilesList() {
        return new ArrayList<ResultFile>(this.resultFiles.values());
    }

    public void setResultFiles(Map<String, ResultFile> usedFiles) {
        this.resultFiles = usedFiles;
    }

    public long getNrLinesRejected() {
        return this.nrLinesRejected;
    }

    public void setNrLinesRejected(long nrLinesRejected) {
        this.nrLinesRejected = nrLinesRejected;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public void increaseLinesRead(long incr) {
        this.nrLinesRead += incr;
    }

    public void increaseLinesWritten(long incr) {
        this.nrLinesWritten += incr;
    }

    public void increaseLinesInput(long incr) {
        this.nrLinesInput += incr;
    }

    public void increaseLinesOutput(long incr) {
        this.nrLinesOutput += incr;
    }

    public void increaseLinesUpdated(long incr) {
        this.nrLinesUpdated += incr;
    }

    public void increaseLinesDeleted(long incr) {
        this.nrLinesDeleted += incr;
    }

    public void increaseLinesRejected(long incr) {
        this.nrLinesRejected += incr;
    }

    public void increaseErrors(long incr) {
        this.nrErrors += incr;
    }

    public String getLogText() {
        return this.logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }
}

