/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseTestResults;
import org.apache.hop.core.database.IDatabaseFactory;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;

public class DatabaseFactory
implements IDatabaseFactory {
    private static final Class<?> PKG = Database.class;
    private boolean success;
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("Database factory", LoggingObjectType.GENERAL, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionTestReport(IVariables variables, DatabaseMeta databaseMeta) throws HopDatabaseException {
        this.success = true;
        StringBuilder report = new StringBuilder();
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionOk", databaseMeta.getName()) + Const.CR);
        }
        catch (HopException e) {
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", databaseMeta.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
            this.success = false;
        }
        finally {
            db.disconnect();
        }
        this.appendConnectionInfo(variables, report, db, databaseMeta);
        report.append(Const.CR);
        return report.toString();
    }

    @Override
    public DatabaseTestResults getConnectionTestResults(IVariables variables, DatabaseMeta databaseMeta) throws HopDatabaseException {
        DatabaseTestResults databaseTestResults = new DatabaseTestResults();
        String message = this.getConnectionTestReport(variables, databaseMeta);
        databaseTestResults.setMessage(message);
        databaseTestResults.setSuccess(this.success);
        return databaseTestResults;
    }

    private StringBuilder appendConnectionInfo(IVariables variables, StringBuilder report, Database db, DatabaseMeta databaseMeta) {
        if (databaseMeta.getIDatabase().getPluginId() == "GENERIC") {
            String customDriverClass = databaseMeta.getAttributes().get("CUSTOM_DRIVER_CLASS");
            this.append(report, "GenericDatabaseMeta.report.customUrl", db.resolve(databaseMeta.getManualUrl()));
            this.append(report, "GenericDatabaseMeta.report.customDriverClass", db.resolve(customDriverClass));
            return report;
        }
        this.append(report, "DatabaseMeta.report.Hostname", db.resolve(databaseMeta.getHostname()));
        this.append(report, "DatabaseMeta.report.Port", db.resolve(databaseMeta.getPort()));
        this.append(report, "DatabaseMeta.report.DatabaseName", db.resolve(databaseMeta.getDatabaseName()));
        String url = "";
        try {
            url = databaseMeta.getURL(variables);
        }
        catch (HopDatabaseException e) {
            url = e.toString();
        }
        this.append(report, "DatabaseMeta.report.Url", url);
        return report;
    }

    private void append(StringBuilder report, String label, String text) {
        report.append(BaseMessages.getString(PKG, label, new String[0])).append('\t').append(text).append(Const.CR);
    }
}

