/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.input;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.input.MappingInput;
import org.apache.hop.pipeline.transforms.input.MappingInputData;
import org.w3c.dom.Node;

@Transform(id="MappingInput", name="i18n::BaseTransform.TypeLongDesc.MappingInput", description="i18n::BaseTransform.TypeTooltipDesc.MappingInput", image="MPI.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Mapping", keywords={"i18n::MappingInputMeta.keyword"}, documentationUrl="/pipeline/transforms/mapping-input.html")
public class MappingInputMeta
extends BaseTransformMeta<MappingInput, MappingInputData> {
    private static final Class<?> PKG = MappingInputMeta.class;
    private String[] fieldName;
    private int[] fieldType;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private volatile IRowMeta inputRowMeta;

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        MappingInputMeta retval = (MappingInputMeta)((Object)super.clone());
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, nrFields);
        System.arraycopy(this.fieldLength, 0, retval.fieldLength, 0, nrFields);
        System.arraycopy(this.fieldPrecision, 0, retval.fieldPrecision, 0, nrFields);
        return retval;
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
        this.fieldType = new int[nrFields];
        this.fieldLength = new int[nrFields];
        this.fieldPrecision = new int[nrFields];
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldType[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type"));
                this.fieldLength[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            xml.append("      <field>").append(Const.CR);
            xml.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            xml.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.fieldType[i])));
            xml.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            xml.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            xml.append("      </field>").append(Const.CR);
        }
        xml.append("    </fields>").append(Const.CR);
        return xml.toString();
    }

    public void setDefault() {
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 2;
            this.fieldLength[i] = 30;
            this.fieldPrecision[i] = -1;
        }
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        block7: {
            block6: {
                if (this.inputRowMeta == null || this.inputRowMeta.isEmpty()) break block6;
                row.mergeRowMeta(this.inputRowMeta);
                if (row.isEmpty()) break block7;
                for (int i = 0; i < this.fieldName.length; ++i) {
                    if (row.indexOfValue(this.fieldName[i]) >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnknownField", (String[])new String[]{this.fieldName[i]}));
                }
                break block7;
            }
            if (row.isEmpty()) {
                for (int i = 0; i < this.fieldName.length; ++i) {
                    if (Utils.isEmpty((CharSequence)this.fieldName[i])) continue;
                    int valueType = this.fieldType[i];
                    if (valueType == 0) {
                        valueType = 2;
                    }
                    try {
                        IValueMeta v = ValueMetaFactory.createValueMeta((String)this.fieldName[i], (int)valueType);
                        v.setLength(this.fieldLength[i]);
                        v.setPrecision(this.fieldPrecision[i]);
                        v.setOrigin(origin);
                        row.addValueMeta(v);
                        continue;
                    }
                    catch (HopPluginException e) {
                        throw new HopTransformException((Throwable)e);
                    }
                }
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NotReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.TransformReceivingDatasFromPreviousOne", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void setInputRowMeta(IRowMeta inputRowMeta) {
        this.inputRowMeta = inputRowMeta;
    }

    public IRowMeta getInputRowMeta() {
        return this.inputRowMeta;
    }
}

