/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.mongo.wrapper.field.MongodbInputDiscoverFieldsImpl;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MongoDbInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MongoDbInputMeta.class;
    private MetaSelectionLine<MongoDbConnection> wConnection;
    private TextVar wFieldsName;
    private CCombo wCollection;
    private TextVar wJsonField;
    private StyledTextComp wJsonQuery;
    private Label wlJsonQuery;
    private Button wbQueryIsPipeline;
    private Button wbOutputAsJson;
    private TableView wFields;
    private Button wbExecuteForEachRow;
    private final MongoDbInputMeta input;

    public MongoDbInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (MongoDbInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CCombo lastControl = this.wTransformName;
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wInputOptionsTab = new CTabItem(wTabFolder, 0);
        wInputOptionsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.InputOptionsTab.TabTitle", (String[])new String[0]));
        Composite wInputOptionsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wInputOptionsComp);
        FormLayout inputLayout = new FormLayout();
        inputLayout.marginWidth = 3;
        inputLayout.marginHeight = 3;
        wInputOptionsComp.setLayout((Layout)inputLayout);
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, MongoDbConnection.class, wInputOptionsComp, 0, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ConnectionName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ConnectionName.Tooltip", (String[])new String[0]));
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, 0);
        this.wConnection.setLayoutData((Object)fdConnection);
        lastControl = this.wConnection;
        try {
            this.wConnection.fillItems();
        }
        catch (HopException e2) {
            new ErrorDialog(this.shell, "Error", "Error loading list of MongoDB connection names", (Exception)((Object)e2));
        }
        Label wlCollection = new Label(wInputOptionsComp, 131072);
        wlCollection.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Collection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCollection);
        FormData fdlCollection = new FormData();
        fdlCollection.left = new FormAttachment(0, 0);
        fdlCollection.right = new FormAttachment(middle, -margin);
        fdlCollection.top = new FormAttachment(lastControl, margin);
        wlCollection.setLayoutData((Object)fdlCollection);
        Button wbGetCollections = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)wbGetCollections);
        wbGetCollections.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.GetCollections.Button", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(lastControl, 0);
        wbGetCollections.setLayoutData((Object)fd);
        wbGetCollections.addListener(13, e -> this.getCollectionNames());
        this.wCollection = new CCombo(wInputOptionsComp, 2048);
        this.props.setLook((Control)this.wCollection);
        this.wCollection.addModifyListener(lsMod);
        FormData fdCollection = new FormData();
        fdCollection.left = new FormAttachment(middle, 0);
        fdCollection.top = new FormAttachment(lastControl, margin);
        fdCollection.right = new FormAttachment((Control)wbGetCollections, 0);
        this.wCollection.setLayoutData((Object)fdCollection);
        lastControl = this.wCollection;
        this.wCollection.addListener(13, e -> this.updateQueryTitleInfo());
        this.wCollection.addListener(16, e -> this.updateQueryTitleInfo());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wInputOptionsComp.setLayoutData((Object)fd);
        wInputOptionsComp.layout();
        wInputOptionsTab.setControl((Control)wInputOptionsComp);
        CTabItem wMongoQueryTab = new CTabItem(wTabFolder, 0);
        wMongoQueryTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.QueryTab.TabTitle", (String[])new String[0]));
        Composite wQueryComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wQueryComp);
        FormLayout queryLayout = new FormLayout();
        queryLayout.marginWidth = 3;
        queryLayout.marginHeight = 3;
        wQueryComp.setLayout((Layout)queryLayout);
        Label wlFieldsName = new Label(wQueryComp, 131072);
        wlFieldsName.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.FieldsName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFieldsName);
        FormData fdlFieldsName = new FormData();
        fdlFieldsName.left = new FormAttachment(0, 0);
        fdlFieldsName.right = new FormAttachment(middle, -margin);
        fdlFieldsName.bottom = new FormAttachment(100, -margin);
        wlFieldsName.setLayoutData((Object)fdlFieldsName);
        this.wFieldsName = new TextVar(this.variables, wQueryComp, 18436);
        this.props.setLook((Control)this.wFieldsName);
        this.wFieldsName.addModifyListener(lsMod);
        FormData fdFieldsName = new FormData();
        fdFieldsName.left = new FormAttachment(middle, 0);
        fdFieldsName.bottom = new FormAttachment(100, -margin);
        fdFieldsName.right = new FormAttachment(100, 0);
        this.wFieldsName.setLayoutData((Object)fdFieldsName);
        lastControl = this.wFieldsName;
        Label executeForEachRLab = new Label(wQueryComp, 131072);
        executeForEachRLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ExecuteForEachRow.Label", (String[])new String[0]));
        this.props.setLook((Control)executeForEachRLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.bottom = new FormAttachment((Control)lastControl, -2 * margin);
        fd.right = new FormAttachment(middle, -margin);
        executeForEachRLab.setLayoutData((Object)fd);
        this.wbExecuteForEachRow = new Button(wQueryComp, 32);
        this.props.setLook((Control)this.wbExecuteForEachRow);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)executeForEachRLab, 0, 0x1000000);
        this.wbExecuteForEachRow.setLayoutData((Object)fd);
        lastControl = executeForEachRLab;
        Label queryIsPipelineL = new Label(wQueryComp, 131072);
        queryIsPipelineL.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Pipeline.Label", (String[])new String[0]));
        this.props.setLook((Control)queryIsPipelineL);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)lastControl, -2 * margin);
        fd.left = new FormAttachment(0, -margin);
        fd.right = new FormAttachment(middle, -margin);
        queryIsPipelineL.setLayoutData((Object)fd);
        this.wbQueryIsPipeline = new Button(wQueryComp, 32);
        this.props.setLook((Control)this.wbQueryIsPipeline);
        fd = new FormData();
        fd.top = new FormAttachment((Control)queryIsPipelineL, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        this.wbQueryIsPipeline.setLayoutData((Object)fd);
        this.wbQueryIsPipeline.addListener(13, e -> this.updateQueryTitleInfo());
        lastControl = queryIsPipelineL;
        this.wlJsonQuery = new Label(wQueryComp, 0);
        this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlJsonQuery);
        FormData fdlJsonQuery = new FormData();
        fdlJsonQuery.left = new FormAttachment(0, 0);
        fdlJsonQuery.right = new FormAttachment(100, -margin);
        fdlJsonQuery.top = new FormAttachment(0, margin);
        this.wlJsonQuery.setLayoutData((Object)fdlJsonQuery);
        this.wJsonQuery = new StyledTextComp(this.variables, wQueryComp, 19202);
        this.props.setLook((Control)this.wJsonQuery, 1);
        this.wJsonQuery.addModifyListener(lsMod);
        FormData fdJsonQuery = new FormData();
        fdJsonQuery.left = new FormAttachment(0, 0);
        fdJsonQuery.top = new FormAttachment((Control)this.wlJsonQuery, margin);
        fdJsonQuery.right = new FormAttachment(100, -2 * margin);
        fdJsonQuery.bottom = new FormAttachment((Control)lastControl, -2 * margin);
        this.wJsonQuery.setLayoutData((Object)fdJsonQuery);
        lastControl = this.wJsonQuery;
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wQueryComp.setLayoutData((Object)fd);
        wQueryComp.layout();
        wMongoQueryTab.setControl((Control)wQueryComp);
        CTabItem wMongoFieldsTab = new CTabItem(wTabFolder, 0);
        wMongoFieldsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Label outputJLab = new Label(wFieldsComp, 131072);
        outputJLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.OutputJson.Label", (String[])new String[0]));
        this.props.setLook((Control)outputJLab);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -2 * margin);
        outputJLab.setLayoutData((Object)fd);
        this.wbOutputAsJson = new Button(wFieldsComp, 32);
        this.props.setLook((Control)this.wbOutputAsJson);
        fd = new FormData();
        fd.top = new FormAttachment((Control)outputJLab, 0, 0x1000000);
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        this.wbOutputAsJson.setLayoutData((Object)fd);
        this.wbOutputAsJson.addListener(13, e -> {
            this.input.setChanged();
            this.wGet.setEnabled(!this.wbOutputAsJson.getSelection());
            this.wJsonField.setEnabled(this.wbOutputAsJson.getSelection());
        });
        lastControl = this.wbOutputAsJson;
        Label wlJsonField = new Label(wFieldsComp, 131072);
        wlJsonField.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlJsonField);
        FormData fdlJsonField = new FormData();
        fdlJsonField.left = new FormAttachment(0, 0);
        fdlJsonField.right = new FormAttachment(middle, -margin);
        fdlJsonField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlJsonField.setLayoutData((Object)fdlJsonField);
        this.wJsonField = new TextVar(this.variables, wFieldsComp, 18436);
        this.props.setLook((Control)this.wJsonField);
        this.wJsonField.addModifyListener(lsMod);
        FormData fdJsonField = new FormData();
        fdJsonField.left = new FormAttachment(middle, 0);
        fdJsonField.top = new FormAttachment((Control)lastControl, margin);
        fdJsonField.right = new FormAttachment(100, 0);
        this.wJsonField.setLayoutData((Object)fdJsonField);
        lastControl = this.wJsonField;
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Button.GetFields", (String[])new String[0]));
        this.props.setLook((Control)this.wGet);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)fd);
        this.wGet.addListener(13, e -> {
            MongoDbInputMeta newMeta = (MongoDbInputMeta)((Object)((Object)this.input.clone()));
            this.getFields(newMeta);
        });
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_PATH", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_TYPE", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_INDEXED", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_ARRAYINFO", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_PERCENTAGE", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_DISPARATE_TYPES", (String[])new String[0]), 1, false)};
        colinf[2].setComboValues(ValueMetaFactory.getAllValueMetaNames());
        colinf[4].setReadOnly(true);
        colinf[5].setReadOnly(true);
        colinf[6].setReadOnly(true);
        this.wFields = new TableView(this.variables, wFieldsComp, 65538, colinf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lastControl, margin * 2);
        fd.bottom = new FormAttachment((Control)this.wGet, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fd);
        wFieldsComp.layout();
        wMongoFieldsTab.setControl((Control)wFieldsComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wTransformName, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fd);
        this.getData(this.input);
        this.input.setChanged(this.changed);
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData(MongoDbInputMeta meta) {
        this.wConnection.setText(Const.NVL((String)meta.getConnectionName(), (String)""));
        this.wFieldsName.setText(Const.NVL((String)meta.getFieldsName(), (String)""));
        this.wCollection.setText(Const.NVL((String)meta.getCollection(), (String)""));
        this.wJsonField.setText(Const.NVL((String)meta.getJsonFieldName(), (String)""));
        this.wJsonQuery.setText(Const.NVL((String)meta.getJsonQuery(), (String)""));
        this.wbQueryIsPipeline.setSelection(meta.isQueryIsPipeline());
        this.wbOutputAsJson.setSelection(meta.isOutputJson());
        this.wbExecuteForEachRow.setSelection(meta.getExecuteForEachIncomingRow());
        this.refreshFields(meta.getMongoFields());
        this.wJsonField.setEnabled(meta.isOutputJson());
        this.wGet.setEnabled(!meta.isOutputJson());
        this.updateQueryTitleInfo();
        this.wTransformName.selectAll();
    }

    private void updateQueryTitleInfo() {
        if (this.wbQueryIsPipeline.getSelection()) {
            this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label2", (String[])new String[0]) + ": db." + Const.NVL((String)this.wCollection.getText(), (String)"n/a") + ".aggregate(...");
            this.wFieldsName.setEnabled(false);
        } else {
            this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label", (String[])new String[0]));
            this.wFieldsName.setEnabled(true);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MongoDbInputMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setFieldsName(this.wFieldsName.getText());
        meta.setCollection(this.wCollection.getText());
        meta.setJsonFieldName(this.wJsonField.getText());
        meta.setJsonQuery(this.wJsonQuery.getText());
        meta.setOutputJson(this.wbOutputAsJson.getSelection());
        meta.setQueryIsPipeline(this.wbQueryIsPipeline.getSelection());
        meta.setExecuteForEachIncomingRow(this.wbExecuteForEachRow.getSelection());
        int numNonEmpty = this.wFields.nrNonEmpty();
        if (numNonEmpty > 0) {
            ArrayList<MongoField> outputFields = new ArrayList<MongoField>();
            for (int i = 0; i < numNonEmpty; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                MongoField newField = new MongoField();
                newField.fieldName = item.getText(1).trim();
                newField.fieldPath = item.getText(2).trim();
                newField.hopType = item.getText(3).trim();
                if (!StringUtils.isEmpty((String)item.getText(4))) {
                    newField.indexedValues = MongoDbInputData.indexedValsList(item.getText(4).trim());
                }
                outputFields.add(newField);
            }
            meta.setMongoFields(outputFields);
        }
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    public boolean isTableDisposed() {
        return this.wFields.isDisposed();
    }

    private void refreshFields(List<MongoField> fields) {
        if (fields == null) {
            return;
        }
        this.wFields.clearAll();
        for (MongoField f : fields) {
            TableItem item = new TableItem(this.wFields.table, 0);
            this.updateTableItem(item, f);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    public void updateFieldTableFields(List<MongoField> fields) {
        HashMap<String, MongoField> fieldMap = new HashMap<String, MongoField>(fields.size());
        for (MongoField field : fields) {
            fieldMap.put(field.fieldName, field);
        }
        int index = 0;
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        for (TableItem tableItem : this.wFields.getTable().getItems()) {
            String name = tableItem.getText(1);
            MongoField mongoField = (MongoField)fieldMap.remove(name);
            if (mongoField == null) {
                indicesToRemove.add(index);
            } else {
                this.updateTableItem(tableItem, mongoField);
            }
            ++index;
        }
        int[] indicesArray = new int[indicesToRemove.size()];
        for (int i = 0; i < indicesArray.length; ++i) {
            indicesArray[i] = (Integer)indicesToRemove.get(i);
        }
        for (MongoField mongoField : fieldMap.values()) {
            TableItem item = new TableItem(this.wFields.table, 0);
            this.updateTableItem(item, mongoField);
        }
        this.wFields.setRowNums();
        this.wFields.remove(indicesArray);
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void updateTableItem(TableItem tableItem, MongoField mongoField) {
        if (!StringUtils.isEmpty((String)mongoField.fieldName)) {
            tableItem.setText(1, mongoField.fieldName);
        }
        if (!StringUtils.isEmpty((String)mongoField.fieldPath)) {
            tableItem.setText(2, mongoField.fieldPath);
        }
        if (!StringUtils.isEmpty((String)mongoField.hopType)) {
            tableItem.setText(3, mongoField.hopType);
        }
        if (mongoField.indexedValues != null && mongoField.indexedValues.size() > 0) {
            tableItem.setText(4, MongoDbInputData.indexedValsList(mongoField.indexedValues));
        }
        if (!StringUtils.isEmpty((String)mongoField.arrayIndexInfo)) {
            tableItem.setText(5, mongoField.arrayIndexInfo);
        }
        if (!StringUtils.isEmpty((String)mongoField.occurrenceFraction)) {
            tableItem.setText(6, mongoField.occurrenceFraction);
        }
        if (mongoField.disparateTypes) {
            tableItem.setText(7, "Y");
        }
    }

    private boolean checkForUnresolved(MongoDbInputMeta meta, String title) {
        boolean notOk;
        String query = this.variables.resolve(meta.getJsonQuery());
        boolean bl = notOk = query.contains("${") || query.contains("?{");
        if (notOk) {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, title, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs", (String[])new String[0]));
            smd.open();
        }
        return !notOk;
    }

    public void handleNotificationException(Exception exception) {
        new ErrorDialog(this.shell, this.transformName, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.ErrorDuringSampling", (String[])new String[0]), exception);
    }

    private void getFields(MongoDbInputMeta meta) {
        if (!StringUtils.isEmpty((String)this.wConnection.getText()) && !StringUtils.isEmpty((String)this.wCollection.getText())) {
            EnterNumberDialog end = new EnterNumberDialog(this.shell, 100, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SampleDocuments.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SampleDocuments.Message", (String[])new String[0]));
            int samples = end.open();
            if (samples > 0) {
                this.getInfo(meta);
                boolean current = meta.getExecuteForEachIncomingRow();
                meta.setExecuteForEachIncomingRow(false);
                if (!this.checkForUnresolved(meta, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs.SamplingTitle", (String[])new String[0]))) {
                    return;
                }
                try {
                    MongoDbInputDialog.discoverFields(meta, this.variables, samples, this.metadataProvider);
                    meta.setExecuteForEachIncomingRow(current);
                    this.refreshFields(meta.getMongoFields());
                }
                catch (HopException e) {
                    new ErrorDialog(this.shell, this.transformName, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.ErrorDuringSampling", (String[])new String[0]), (Exception)((Object)e));
                }
            }
        } else {
            Object missingConDetails = "";
            if (StringUtils.isEmpty((String)this.wConnection.getText())) {
                missingConDetails = (String)missingConDetails + " connection name";
            }
            if (StringUtils.isEmpty((String)this.wCollection.getText())) {
                missingConDetails = (String)missingConDetails + " collection";
            }
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConDetails}));
            smd.open();
        }
    }

    private void preview() {
        MongoDbInputMeta oneMeta = new MongoDbInputMeta();
        this.getInfo(oneMeta);
        oneMeta.setExecuteForEachIncomingRow(false);
        if (!this.checkForUnresolved(oneMeta, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs.PreviewTitle", (String[])new String[0]))) {
            return;
        }
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionNames() {
        try {
            String connectionName = this.variables.resolve(this.wConnection.getText());
            String current = this.wCollection.getText();
            this.wCollection.removeAll();
            MongoDbConnection connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
            String databaseName = this.variables.resolve(connection.getDbName());
            if (!StringUtils.isEmpty((String)connectionName)) {
                MongoDbInputMeta meta = new MongoDbInputMeta();
                this.getInfo(meta);
                try {
                    Set<String> collections;
                    MongoClientWrapper wrapper = connection.createWrapper(this.variables, (ILogChannel)this.log);
                    try {
                        collections = wrapper.getCollectionsNames(databaseName);
                    }
                    finally {
                        wrapper.dispose();
                    }
                    for (String c : collections) {
                        this.wCollection.add(c);
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                }
            } else {
                Object missingConnDetails = "";
                if (StringUtils.isEmpty((String)connectionName)) {
                    missingConnDetails = (String)missingConnDetails + "connection name";
                }
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConnDetails}));
                smd.open();
            }
            if (!StringUtils.isEmpty((String)current)) {
                this.wCollection.setText(current);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting collections", e);
        }
    }

    public static boolean discoverFields(MongoDbInputMeta meta, IVariables variables, int docsToSample, IHopMetadataProvider metadataProvider) throws HopException {
        String connectionName = variables.resolve(meta.getConnectionName());
        try {
            MongodbInputDiscoverFieldsImpl discoverFields;
            List<MongoField> discoveredFields;
            MongoDbConnection connection = (MongoDbConnection)metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
            if (connection == null) {
                throw new HopException("Unable to find connection " + connectionName);
            }
            String collection = variables.resolve(meta.getCollection());
            String query = variables.resolve(meta.getJsonQuery());
            String fields = variables.resolve(meta.getFieldsName());
            int numDocsToSample = docsToSample;
            if (numDocsToSample < 1) {
                numDocsToSample = 100;
            }
            if ((discoveredFields = (discoverFields = new MongodbInputDiscoverFieldsImpl()).discoverFields(variables, connection, collection, query, fields, meta.isQueryIsPipeline(), numDocsToSample, meta)).size() > 0) {
                meta.setMongoFields(discoveredFields);
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof HopException) {
                throw (HopException)((Object)e);
            }
            throw new HopException("Unable to discover fields from MongoDB", (Throwable)e);
        }
        return false;
    }
}

