/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilesrowcount;

import java.io.Closeable;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountData;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountMeta;

public class GetFilesRowsCount
extends BaseTransform<GetFilesRowsCountMeta, GetFilesRowsCountData> {
    private static final Class<?> PKG = GetFilesRowsCountMeta.class;

    public GetFilesRowsCount(TransformMeta transformMeta, GetFilesRowsCountMeta meta, GetFilesRowsCountData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] getOneRow() throws HopException {
        Object[] r;
        if (!this.openNextFile()) {
            return null;
        }
        try {
            if (((GetFilesRowsCountMeta)this.meta).isFileField()) {
                r = (Object[])((GetFilesRowsCountData)this.data).readrow.clone();
                r = RowDataUtil.resizeArray((Object[])r, (int)((GetFilesRowsCountData)this.data).outputRowMeta.size());
            } else {
                r = RowDataUtil.allocateRowData((int)((GetFilesRowsCountData)this.data).outputRowMeta.size());
            }
            if (((GetFilesRowsCountMeta)this.meta).isSmartCount() && ((GetFilesRowsCountData)this.data).foundData) {
                ++((GetFilesRowsCountData)this.data).rownr;
            }
            r[((GetFilesRowsCountData)this.data).totalpreviousfields] = ((GetFilesRowsCountData)this.data).rownr;
            if (((GetFilesRowsCountMeta)this.meta).includeCountFiles()) {
                r[((GetFilesRowsCountData)this.data).totalpreviousfields + 1] = ((GetFilesRowsCountData)this.data).filenr;
            }
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new HopException("Unable to read row from file", (Throwable)e);
        }
        return r;
    }

    public boolean processRow() throws HopException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (!((GetFilesRowsCountMeta)this.meta).isFileField() && ((GetFilesRowsCountData)this.data).last_file || ((GetFilesRowsCountMeta)this.meta).isFileField()) {
                this.putRow(((GetFilesRowsCountData)this.data).outputRowMeta, outputRowData);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.TotalRowsFiles", (String[])new String[0]), new Object[]{((GetFilesRowsCountData)this.data).rownr, ((GetFilesRowsCountData)this.data).filenr});
                }
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.ErrorInTransformRunning", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void getRowNumber() throws HopException {
        try {
            if (((GetFilesRowsCountData)this.data).file.getType() == FileType.FILE) {
                int n;
                ((GetFilesRowsCountData)this.data).fr = HopVfs.getInputStream((FileObject)((GetFilesRowsCountData)this.data).file);
                byte[] buf = new byte[8192];
                boolean prevCR = false;
                while ((n = ((GetFilesRowsCountData)this.data).fr.read(buf)) != -1) {
                    for (int i = 0; i < n; ++i) {
                        ((GetFilesRowsCountData)this.data).foundData = true;
                        if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("CRLF")) {
                            if (buf[i] == 13 || buf[i] == 10) {
                                if (buf[i] == 13) {
                                    prevCR = true;
                                    continue;
                                }
                                if (buf[i] != 10 || !prevCR) continue;
                                ++((GetFilesRowsCountData)this.data).rownr;
                                ((GetFilesRowsCountData)this.data).foundData = false;
                                prevCR = false;
                                continue;
                            }
                            prevCR = false;
                            continue;
                        }
                        if (buf[i] != ((GetFilesRowsCountData)this.data).separator) continue;
                        ++((GetFilesRowsCountData)this.data).rownr;
                        ((GetFilesRowsCountData)this.data).foundData = false;
                    }
                }
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.RowsInFile", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString(), "" + ((GetFilesRowsCountData)this.data).rownr}));
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (((GetFilesRowsCountData)this.data).fr != null) {
                BaseTransform.closeQuietly((Closeable)((GetFilesRowsCountData)this.data).fr);
                ((GetFilesRowsCountData)this.data).fr = null;
            }
        }
    }

    private boolean openNextFile() {
        if (((GetFilesRowsCountData)this.data).last_file) {
            return false;
        }
        try {
            if (!((GetFilesRowsCountMeta)this.meta).isFileField()) {
                if (((GetFilesRowsCountData)this.data).filenr >= (long)((GetFilesRowsCountData)this.data).files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                ((GetFilesRowsCountData)this.data).last_file = ((GetFilesRowsCountData)this.data).filenr == (long)(((GetFilesRowsCountData)this.data).files.nrOfFiles() - 1);
                ((GetFilesRowsCountData)this.data).file = ((GetFilesRowsCountData)this.data).files.getFile((int)((GetFilesRowsCountData)this.data).filenr);
            } else {
                ((GetFilesRowsCountData)this.data).readrow = this.getRow();
                if (((GetFilesRowsCountData)this.data).readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    ((GetFilesRowsCountData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((GetFilesRowsCountData)this.data).outputRowMeta = ((GetFilesRowsCountData)this.data).inputRowMeta.clone();
                    ((GetFilesRowsCountMeta)this.meta).getFields(((GetFilesRowsCountData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((GetFilesRowsCountData)this.data).totalpreviousfields = ((GetFilesRowsCountData)this.data).inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)((GetFilesRowsCountMeta)this.meta).getOutputFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                    }
                    if (((GetFilesRowsCountData)this.data).indexOfFilenameField < 0) {
                        ((GetFilesRowsCountData)this.data).indexOfFilenameField = this.getInputRowMeta().indexOfValue(((GetFilesRowsCountMeta)this.meta).getOutputFilenameField());
                        if (((GetFilesRowsCountData)this.data).indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.ErrorFindingField", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField()}));
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Exception.CouldnotFindField", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(((GetFilesRowsCountData)this.data).readrow, ((GetFilesRowsCountData)this.data).indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FilenameInStream", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField(), filename}));
                }
                ((GetFilesRowsCountData)this.data).file = HopVfs.getFileObject((String)filename);
                if (((GetFilesRowsCountMeta)this.meta).isFileField()) {
                    ((GetFilesRowsCountData)this.data).rownr = 0L;
                }
            }
            ++((GetFilesRowsCountData)this.data).filenr;
            if (((GetFilesRowsCountMeta)this.meta).isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, ((GetFilesRowsCountData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.OpeningFile", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString()}));
            }
            this.getRowNumber();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileOpened", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.UnableToOpenFile", (String[])new String[]{"" + ((GetFilesRowsCountData)this.data).filenr, ((GetFilesRowsCountData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("CUSTOM") && Utils.isEmpty((CharSequence)((GetFilesRowsCountMeta)this.meta).getRowSeparator())) {
                this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Msg", (String[])new String[0])});
                this.setErrors(1L);
                this.stopAll();
            } else if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("CARRIAGERETURN") || ((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("LF")) {
                ((GetFilesRowsCountData)this.data).separator = (char)13;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\n"});
                }
            } else if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("LINEFEED") || ((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("CR")) {
                ((GetFilesRowsCountData)this.data).separator = (char)10;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\r"});
                }
            } else if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("TAB")) {
                ((GetFilesRowsCountData)this.data).separator = (char)9;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\t"});
                }
            } else if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat().equals("CRLF")) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\r\\n"});
                }
            } else {
                ((GetFilesRowsCountData)this.data).separator = this.resolve(((GetFilesRowsCountMeta)this.meta).getRowSeparator()).charAt(0);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " " + ((GetFilesRowsCountData)this.data).separator});
                }
            }
            if (!((GetFilesRowsCountMeta)this.meta).isFileField()) {
                ((GetFilesRowsCountData)this.data).files = ((GetFilesRowsCountMeta)this.meta).getFiles((IVariables)this);
                if (((GetFilesRowsCountData)this.data).files == null || ((GetFilesRowsCountData)this.data).files.nrOfFiles() == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoFiles", (String[])new String[0]));
                    return false;
                }
                try {
                    ((GetFilesRowsCountData)this.data).outputRowMeta = new RowMeta();
                    ((GetFilesRowsCountMeta)this.meta).getFields(((GetFilesRowsCountData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                }
                catch (Exception e) {
                    this.logError("Error initializing transform: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            ((GetFilesRowsCountData)this.data).rownr = 0L;
            ((GetFilesRowsCountData)this.data).filenr = 0L;
            ((GetFilesRowsCountData)this.data).totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GetFilesRowsCountData)this.data).file != null) {
            try {
                ((GetFilesRowsCountData)this.data).file.close();
                ((GetFilesRowsCountData)this.data).file = null;
            }
            catch (Exception e) {
                this.log.logError("Error closing file", (Throwable)e);
            }
        }
        if (((GetFilesRowsCountData)this.data).fr != null) {
            BaseTransform.closeQuietly((Closeable)((GetFilesRowsCountData)this.data).fr);
            ((GetFilesRowsCountData)this.data).fr = null;
        }
        if (((GetFilesRowsCountData)this.data).lineStringBuilder != null) {
            ((GetFilesRowsCountData)this.data).lineStringBuilder = null;
        }
        super.dispose();
    }
}

