/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.SubtaskAccess;
import org.apache.flink.runtime.operators.coordination.util.IncompleteFuturesTracker;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

final class ExecutionSubtaskAccess
implements SubtaskAccess {
    private final Execution taskExecution;
    private final OperatorID operator;
    private final IncompleteFuturesTracker futuresTracker;

    ExecutionSubtaskAccess(Execution taskExecution, OperatorID operator) {
        this.taskExecution = taskExecution;
        this.operator = operator;
        this.futuresTracker = new IncompleteFuturesTracker();
        taskExecution.getTerminalStateFuture().thenAccept(state -> this.futuresTracker.failAllFutures(new FlinkException("Task is no longer running")));
    }

    @Override
    public Callable<CompletableFuture<Acknowledge>> createEventSendAction(SerializedValue<OperatorEvent> event) {
        return () -> {
            CompletableFuture<Acknowledge> result = this.taskExecution.sendOperatorEvent(this.operator, event);
            this.futuresTracker.trackFutureWhileIncomplete(result);
            return result;
        };
    }

    @Override
    public int getSubtaskIndex() {
        return this.taskExecution.getParallelSubtaskIndex();
    }

    @Override
    public ExecutionAttemptID currentAttempt() {
        return this.taskExecution.getAttemptId();
    }

    @Override
    public String subtaskName() {
        return this.taskExecution.getVertexWithAttempt();
    }

    @Override
    public CompletableFuture<?> hasSwitchedToRunning() {
        return this.taskExecution.getInitializingOrRunningFuture();
    }

    @Override
    public boolean isStillRunning() {
        return this.taskExecution.getState() == ExecutionState.RUNNING || this.taskExecution.getState() == ExecutionState.INITIALIZING;
    }

    @Override
    public void triggerTaskFailover(Throwable cause) {
        this.taskExecution.fail(cause);
    }

    static final class ExecutionJobVertexSubtaskAccess
    implements SubtaskAccess.SubtaskAccessFactory {
        private final ExecutionJobVertex ejv;
        private final OperatorID operator;

        ExecutionJobVertexSubtaskAccess(ExecutionJobVertex ejv, OperatorID operator) {
            this.ejv = (ExecutionJobVertex)Preconditions.checkNotNull((Object)ejv);
            this.operator = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)operator)));
        }

        @Override
        public SubtaskAccess getAccessForSubtask(int subtask) {
            if (subtask < 0 || subtask >= this.ejv.getParallelism()) {
                throw new IllegalArgumentException("Subtask index out of bounds [0, " + this.ejv.getParallelism() + ')');
            }
            Execution taskExecution = this.ejv.getTaskVertices()[subtask].getCurrentExecutionAttempt();
            return new ExecutionSubtaskAccess(taskExecution, this.operator);
        }
    }
}

