/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.datagrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridDataMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridFieldMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataGridDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DataGridMeta.class;
    private CTabFolder wTabFolder;
    private Composite wDataComp;
    private TableView wFields;
    private TableView wData;
    private final DataGridMeta input;
    private final DataGridMeta dataGridMeta;
    private ModifyListener lsMod;
    private static final String SYSTEM_COMBO_YES = "System.Combo.Yes";

    public DataGridDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (DataGridMeta)((Object)in);
        this.dataGridMeta = this.input.clone();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        CTabItem wMetaTab = new CTabItem(this.wTabFolder, 0);
        wMetaTab.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.Meta.Label", (String[])new String[0]));
        Composite wMetaComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMetaComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wMetaComp.setLayout((Layout)fileLayout);
        int FieldsRows = this.input.getDataGridFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Format.Column", (String[])new String[0]), 2, Const.getDateFormats()), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView(this.variables, wMetaComp, 67586, colinf, FieldsRows, false, this.lsMod, this.props, true, null, false);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        wMetaComp.layout();
        wMetaTab.setControl((Control)wMetaComp);
        CTabItem wDataTab = new CTabItem(this.wTabFolder, 0);
        wDataTab.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.Data.Label", (String[])new String[0]));
        this.wDataComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wDataComp);
        FormLayout filesettingLayout = new FormLayout();
        filesettingLayout.marginWidth = 3;
        filesettingLayout.marginHeight = 3;
        this.wDataComp.setLayout((Layout)fileLayout);
        this.addDataGrid(false);
        FormData fdDataComp = new FormData();
        fdDataComp.left = new FormAttachment(0, 0);
        fdDataComp.top = new FormAttachment(0, 0);
        fdDataComp.right = new FormAttachment(100, 0);
        fdDataComp.bottom = new FormAttachment(100, 0);
        this.wDataComp.setLayoutData((Object)fdDataComp);
        this.wDataComp.layout();
        wDataTab.setControl((Control)this.wDataComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        this.wTabFolder.setSelection(0);
        this.wTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DataGridDialog.this.addDataGrid(true);
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addDataGrid(boolean refresh) {
        if (refresh) {
            this.getMetaInfo(this.dataGridMeta);
        }
        if (refresh) {
            this.getDataInfo(this.dataGridMeta);
            for (Control control : this.wDataComp.getChildren()) {
                control.dispose();
            }
        }
        ColumnInfo[] columns = new ColumnInfo[this.dataGridMeta.getDataGridFields().size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new ColumnInfo(this.dataGridMeta.getDataGridFields().get(i).getName(), 1, false, false);
        }
        List<DataGridDataMeta> lines = this.dataGridMeta.getDataLines();
        this.wData = new TableView(this.variables, this.wDataComp, 0, columns, lines.size(), this.lsMod, this.props);
        this.wData.setSortable(false);
        for (int i = 0; i < lines.size(); ++i) {
            DataGridDataMeta line = lines.get(i);
            TableItem item = this.wData.table.getItem(i);
            for (int f = 0; f < line.getDatalines().size(); ++f) {
                item.setText(f + 1, Const.NVL((String)line.getDatalines().get(f), (String)""));
            }
        }
        this.wData.setRowNums();
        this.wData.optWidth(true);
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        this.wData.setLayoutData((Object)fdData);
        this.wTabFolder.layout(true, true);
        this.wFields.nrNonEmpty();
        this.wFields.setTableViewModifyListener(new TableView.ITableViewModifyListener(){

            private Integer getIdxByValue(List<Integer> list, Integer value) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).equals(value)) continue;
                    return i;
                }
                return null;
            }

            public void moveRow(int position1, int position2) {
                if (!DataGridDialog.this.wFields.getNonEmptyIndexes().contains(position1) || !DataGridDialog.this.wFields.getNonEmptyIndexes().contains(position2)) {
                    DataGridDialog.this.wFields.nrNonEmpty();
                    return;
                }
                Integer fieldRealPosition1 = this.getIdxByValue(DataGridDialog.this.wFields.getNonEmptyIndexes(), position1);
                Integer fieldRealPosition2 = this.getIdxByValue(DataGridDialog.this.wFields.getNonEmptyIndexes(), position2);
                if (fieldRealPosition1 == null || fieldRealPosition2 == null) {
                    return;
                }
                int dataPosition1 = fieldRealPosition1 + 1;
                int dataPosition2 = fieldRealPosition2 + 1;
                for (TableItem item : DataGridDialog.this.wData.table.getItems()) {
                    String value1 = item.getText(dataPosition1);
                    String value2 = item.getText(dataPosition2);
                    item.setText(dataPosition2, value1);
                    item.setText(dataPosition1, value2);
                }
                DataGridDialog.this.wFields.nrNonEmpty();
            }

            public void insertRow(int rowIndex) {
                DataGridDialog.this.wFields.nrNonEmpty();
            }

            public void cellFocusLost(int rowIndex) {
                List nonEmptyIndexesBeforeChanges = DataGridDialog.this.wFields.getNonEmptyIndexes();
                DataGridDialog.this.wFields.nrNonEmpty();
                List nonEmptyIndexesAfterChanges = DataGridDialog.this.wFields.getNonEmptyIndexes();
                if (CollectionUtils.isEqualCollection((Collection)nonEmptyIndexesBeforeChanges, (Collection)nonEmptyIndexesAfterChanges)) {
                    return;
                }
                Collection disjunction = CollectionUtils.disjunction((Iterable)nonEmptyIndexesBeforeChanges, (Iterable)nonEmptyIndexesAfterChanges);
                Integer disjunctionIdx = (Integer)disjunction.toArray()[0];
                if (nonEmptyIndexesAfterChanges.contains(disjunctionIdx)) {
                    Integer idxByValue = this.getIdxByValue(nonEmptyIndexesAfterChanges, disjunctionIdx);
                    if (idxByValue == null) {
                        return;
                    }
                    Integer n = idxByValue;
                    Integer n2 = idxByValue = Integer.valueOf(idxByValue + 1);
                    TableColumn column = new TableColumn(DataGridDialog.this.wData.table, 0, idxByValue.intValue());
                    column.pack();
                } else {
                    Integer removeColumn = this.getIdxByValue(nonEmptyIndexesBeforeChanges, disjunctionIdx);
                    if (removeColumn == null) {
                        return;
                    }
                    Integer n = removeColumn;
                    Integer n3 = removeColumn = Integer.valueOf(removeColumn + 1);
                    DataGridDialog.this.wData.table.getColumn(removeColumn.intValue()).dispose();
                    DataGridDialog.this.wFields.nrNonEmpty();
                }
            }

            public void delete(int[] items) {
                Arrays.sort(items);
                for (int i = items.length - 1; i >= 0; --i) {
                    int index = items[i];
                    if (!DataGridDialog.this.wFields.getNonEmptyIndexes().contains(index)) continue;
                    Integer removeColumn = this.getIdxByValue(DataGridDialog.this.wFields.getNonEmptyIndexes(), index);
                    if (removeColumn == null) {
                        return;
                    }
                    Integer n = removeColumn;
                    Integer n2 = removeColumn = Integer.valueOf(removeColumn + 1);
                    DataGridDialog.this.wData.table.getColumn(removeColumn.intValue()).dispose();
                }
                DataGridDialog.this.wFields.nrNonEmpty();
            }
        });
        this.wFields.setContentListener(modifyEvent -> this.wFields.nrNonEmpty());
    }

    public void getData() {
        this.getMetaData();
        this.addDataGrid(false);
    }

    private void getMetaData() {
        int nrFields = this.input.getDataGridFields().size();
        if (nrFields > this.wFields.table.getItemCount()) {
            nrFields = this.wFields.table.getItemCount();
        }
        for (int i = 0; i < nrFields; ++i) {
            if (this.input.getDataGridFields().get(i).getName() == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, this.input.getDataGridFields().get(i).getName());
            String type = this.input.getDataGridFields().get(i).getType();
            String format = this.input.getDataGridFields().get(i).getFormat();
            String length = this.input.getDataGridFields().get(i).getLenght() < 0 ? "" : "" + this.input.getDataGridFields().get(i).getLenght();
            String prec = this.input.getDataGridFields().get(i).getPrecision() < 0 ? "" : "" + this.input.getDataGridFields().get(i).getPrecision();
            String curr = this.input.getDataGridFields().get(i).getCurrency();
            String group = this.input.getDataGridFields().get(i).getGroup();
            String decim = this.input.getDataGridFields().get(i).getDecimal();
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
            item.setText(col, Boolean.TRUE.equals(this.input.getDataGridFields().get(i).isEmptyString()) ? BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(DataGridMeta meta) {
        this.getMetaInfo(meta);
        this.getDataInfo(meta);
    }

    private void getMetaInfo(DataGridMeta meta) {
        int nrFields = this.wFields.nrNonEmpty();
        meta.getDataGridFields().clear();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            DataGridFieldMeta field = new DataGridFieldMeta();
            int col = 1;
            field.setName(item.getText(col++));
            field.setType(item.getText(col++));
            field.setFormat(item.getText(col++));
            String slength = item.getText(col++);
            String sprec = item.getText(col++);
            field.setCurrency(item.getText(col++));
            field.setDecimal(item.getText(col++));
            field.setGroup(item.getText(col++));
            try {
                field.setLenght(Integer.parseInt(slength));
            }
            catch (Exception e) {
                field.setLenght(-1);
            }
            try {
                field.setPrecision(Integer.parseInt(sprec));
            }
            catch (Exception e) {
                field.setPrecision(-1);
            }
            field.setEmptyString(BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(col)));
            if (Boolean.TRUE.equals(field.isEmptyString())) {
                field.setType("String");
            }
            meta.getDataGridFields().add(field);
        }
    }

    private void getDataInfo(DataGridMeta meta) {
        ArrayList<DataGridDataMeta> data = new ArrayList<DataGridDataMeta>();
        int nrLines = this.wData.table.getItemCount();
        int nrFields = meta.getDataGridFields().size();
        for (int i = 0; i < nrLines; ++i) {
            DataGridDataMeta line = new DataGridDataMeta();
            TableItem item = this.wData.table.getItem(i);
            for (int f = 0; f < nrFields; ++f) {
                line.getDatalines().add(item.getText(f + 1));
            }
            data.add(line);
        }
        meta.setDataLines(data);
    }

    private void preview() {
        DataGridMeta oneMeta = new DataGridMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"DataGridDialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataGridDialog.EnterPreviewSize.Message", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }
}

