/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class MetadataRequestData
implements ApiMessage {
    private List<MetadataRequestTopic> topics;
    private boolean allowAutoTopicCreation;
    private boolean includeClusterAuthorizedOperations;
    private boolean includeTopicAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema[] SCHEMAS;

    public MetadataRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public MetadataRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public MetadataRequestData() {
        this.topics = new ArrayList<MetadataRequestTopic>();
        this.allowAutoTopicCreation = true;
        this.includeClusterAuthorizedOperations = false;
        this.includeTopicAuthorizedOperations = false;
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<MetadataRequestTopic> newCollection;
        int arrayLength;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                if (_version < 1) throw new RuntimeException("non-nullable field topics was serialized as null");
                this.topics = null;
            } else {
                newCollection = new ArrayList<MetadataRequestTopic>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        }
        this.allowAutoTopicCreation = _version >= 4 ? _readable.readByte() != 0 : true;
        this.includeClusterAuthorizedOperations = _version >= 8 ? _readable.readByte() != 0 : false;
        this.includeTopicAuthorizedOperations = _version >= 8 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version < 9) return;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 9) {
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                for (MetadataRequestTopic topicsElement : this.topics) {
                    topicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topics == null) {
            if (_version < 1) throw new NullPointerException();
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topics.size());
            for (MetadataRequestTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 4) {
            _writable.writeByte(this.allowAutoTopicCreation ? (byte)1 : 0);
        } else if (!this.allowAutoTopicCreation) {
            throw new UnsupportedVersionException("Attempted to write a non-default allowAutoTopicCreation at version " + _version);
        }
        if (_version >= 8) {
            _writable.writeByte(this.includeClusterAuthorizedOperations ? (byte)1 : 0);
        } else if (this.includeClusterAuthorizedOperations) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeClusterAuthorizedOperations at version " + _version);
        }
        if (_version >= 8) {
            _writable.writeByte(this.includeTopicAuthorizedOperations ? (byte)1 : 0);
        } else if (this.includeTopicAuthorizedOperations) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeTopicAuthorizedOperations at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            return;
        } else {
            if (_numTaggedFields <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        if ((_nestedObjects = struct.getArray("topics")) == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<MetadataRequestTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new MetadataRequestTopic((Struct)nestedObject, _version));
            }
        }
        this.allowAutoTopicCreation = _version >= 4 ? struct.getBoolean("allow_auto_topic_creation") : true;
        this.includeClusterAuthorizedOperations = _version >= 8 ? struct.getBoolean("include_cluster_authorized_operations") : false;
        this.includeTopicAuthorizedOperations = _version >= 8 ? struct.getBoolean("include_topic_authorized_operations") : false;
        if (_version >= 9 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 9) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (MetadataRequestTopic element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
        }
        if (_version >= 4) {
            struct.set("allow_auto_topic_creation", (Object)this.allowAutoTopicCreation);
        }
        if (_version >= 8) {
            struct.set("include_cluster_authorized_operations", (Object)this.includeClusterAuthorizedOperations);
        }
        if (_version >= 8) {
            struct.set("include_topic_authorized_operations", (Object)this.includeTopicAuthorizedOperations);
        }
        if (_version >= 9) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (this.topics == null) {
            _size = _version >= 9 ? ++_size : (_size += 4);
        } else {
            int _arraySize = 0;
            _arraySize = _version >= 9 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
            for (MetadataRequestTopic topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 4) {
            ++_size;
        }
        if (_version >= 8) {
            ++_size;
        }
        if (_version >= 8) {
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 9) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataRequestData)) {
            return false;
        }
        MetadataRequestData other = (MetadataRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.allowAutoTopicCreation != other.allowAutoTopicCreation) {
            return false;
        }
        if (this.includeClusterAuthorizedOperations != other.includeClusterAuthorizedOperations) {
            return false;
        }
        return this.includeTopicAuthorizedOperations == other.includeTopicAuthorizedOperations;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.allowAutoTopicCreation ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.includeClusterAuthorizedOperations ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.includeTopicAuthorizedOperations ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "MetadataRequestData(topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", allowAutoTopicCreation=" + (this.allowAutoTopicCreation ? "true" : "false") + ", includeClusterAuthorizedOperations=" + (this.includeClusterAuthorizedOperations ? "true" : "false") + ", includeTopicAuthorizedOperations=" + (this.includeTopicAuthorizedOperations ? "true" : "false") + ")";
    }

    public List<MetadataRequestTopic> topics() {
        return this.topics;
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public boolean includeClusterAuthorizedOperations() {
        return this.includeClusterAuthorizedOperations;
    }

    public boolean includeTopicAuthorizedOperations() {
        return this.includeTopicAuthorizedOperations;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MetadataRequestData setTopics(List<MetadataRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public MetadataRequestData setAllowAutoTopicCreation(boolean v) {
        this.allowAutoTopicCreation = v;
        return this;
    }

    public MetadataRequestData setIncludeClusterAuthorizedOperations(boolean v) {
        this.includeClusterAuthorizedOperations = v;
        return this;
    }

    public MetadataRequestData setIncludeTopicAuthorizedOperations(boolean v) {
        this.includeTopicAuthorizedOperations = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."))));
        SCHEMA_8 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."));
        SCHEMA_9 = new Schema(new Field("topics", CompactArrayOf.nullable(MetadataRequestTopic.SCHEMA_9), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
    }

    public static class MetadataRequestTopic
    implements Message {
        private String name;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;

        public MetadataRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MetadataRequestTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MetadataRequestTopic() {
            this.name = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 9;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataRequestTopic");
            }
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataRequestTopic");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataRequestTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            if (_version >= 9 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MetadataRequestTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 9) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            if (_version >= 9) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataRequestTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 9 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 9) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataRequestTopic)) {
                return false;
            }
            MetadataRequestTopic other = (MetadataRequestTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MetadataRequestTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name.")))))))));
            SCHEMA_9 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }
}

