/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.SetMultimap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final TransformHierarchy transforms;
    private Set<String> usedFullNames = new HashSet<String>();
    private @Nullable CoderRegistry coderRegistry;
    private @Nullable SchemaRegistry schemaRegistry;
    private final Multimap<String, PTransform<?, ?>> instancePerName = ArrayListMultimap.create();
    private final PipelineOptions defaultOptions;

    public static Pipeline create() {
        Pipeline pipeline = new Pipeline(PipelineOptionsFactory.create());
        LOG.debug("Creating {}", (Object)pipeline);
        return pipeline;
    }

    public static Pipeline create(PipelineOptions options) {
        PipelineRunner.fromOptions(options);
        Pipeline pipeline = new Pipeline(options);
        LOG.debug("Creating {}", (Object)pipeline);
        return pipeline;
    }

    public PBegin begin() {
        return PBegin.in(this);
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PBegin, OutputT> root) {
        return this.begin().apply(root);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PBegin, OutputT> root) {
        return this.begin().apply(name, root);
    }

    @Internal
    public static Pipeline forTransformHierarchy(TransformHierarchy transforms, PipelineOptions options) {
        return new Pipeline(transforms, options);
    }

    @Internal
    public PipelineOptions getOptions() {
        return this.defaultOptions;
    }

    @Internal
    public void replaceAll(List<PTransformOverride> overrides) {
        for (PTransformOverride override : overrides) {
            this.replace(override);
        }
        this.checkNoMoreMatches(overrides);
    }

    private void checkNoMoreMatches(final List<PTransformOverride> overrides) {
        this.traverseTopologically(new PipelineVisitor.Defaults(){
            SetMultimap<TransformHierarchy.Node, PTransformOverride> matched = HashMultimap.create();

            @Override
            public PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (!node.isRootNode()) {
                    this.checkForMatches(node);
                }
                if (this.matched.containsKey((Object)node)) {
                    return PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
                }
                return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (node.isRootNode()) {
                    Preconditions.checkState((boolean)this.matched.isEmpty(), (String)"Found nodes that matched overrides. Matches: %s", this.matched);
                }
            }

            @Override
            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                this.checkForMatches(node);
            }

            private void checkForMatches(TransformHierarchy.Node node) {
                for (PTransformOverride override : overrides) {
                    if (!override.getMatcher().matchesDuringValidation(node.toAppliedPTransform(this.getPipeline()))) continue;
                    this.matched.put((Object)node, (Object)override);
                }
            }
        });
    }

    private void replace(final PTransformOverride override) {
        final HashSet matches = new HashSet();
        final HashSet freedNodes = new HashSet();
        this.traverseTopologically(new PipelineVisitor.Defaults(){

            @Override
            public PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (!node.isRootNode() && freedNodes.contains(node.getEnclosingNode())) {
                    freedNodes.add(node);
                    return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }
                if (!node.isRootNode() && override.getMatcher().matches(node.toAppliedPTransform(this.getPipeline()))) {
                    matches.add(node);
                    freedNodes.add(node);
                }
                return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                if (freedNodes.contains(node.getEnclosingNode())) {
                    freedNodes.add(node);
                } else if (override.getMatcher().matches(node.toAppliedPTransform(this.getPipeline()))) {
                    matches.add(node);
                    freedNodes.add(node);
                }
            }
        });
        for (TransformHierarchy.Node freedNode : freedNodes) {
            this.usedFullNames.remove(freedNode.getFullName());
        }
        for (TransformHierarchy.Node match : matches) {
            this.applyReplacement(match, override.getOverrideFactory());
        }
    }

    public PipelineResult run() {
        return this.run(this.defaultOptions);
    }

    public PipelineResult run(PipelineOptions options) {
        PipelineRunner<PipelineResult> runner = PipelineRunner.fromOptions(options);
        LOG.debug("Running {} via {}", (Object)this, runner);
        try {
            this.validate(options);
            return runner.run(this);
        }
        catch (UserCodeException e) {
            throw new PipelineExecutionException(e.getCause());
        }
    }

    public CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = CoderRegistry.createDefault();
        }
        return this.coderRegistry;
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public SchemaRegistry getSchemaRegistry() {
        if (this.schemaRegistry == null) {
            this.schemaRegistry = SchemaRegistry.createDefault();
        }
        return this.schemaRegistry;
    }

    @Deprecated
    public void setCoderRegistry(CoderRegistry coderRegistry) {
        this.coderRegistry = coderRegistry;
    }

    @Internal
    public void traverseTopologically(PipelineVisitor visitor) {
        visitor.enterPipeline(this);
        this.transforms.visit(visitor);
        visitor.leavePipeline(this);
    }

    @Internal
    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(InputT input, PTransform<? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(transform.getName(), input, transform);
    }

    @Internal
    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(String name, InputT input, PTransform<? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(name, input, transform);
    }

    private Pipeline(TransformHierarchy transforms, PipelineOptions options) {
        this.transforms = transforms;
        this.defaultOptions = options;
    }

    protected Pipeline(PipelineOptions options) {
        this(new TransformHierarchy(ResourceHints.fromOptions(options)), options);
    }

    public String toString() {
        return "Pipeline#" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InputT extends PInput, OutputT extends POutput> OutputT applyInternal(String name, InputT input, PTransform<? super InputT, OutputT> transform) {
        String namePrefix = this.transforms.getCurrent().getFullName();
        String uniqueName = this.uniquifyInternal(namePrefix, name);
        String builtName = this.buildName(namePrefix, name);
        this.instancePerName.put((Object)builtName, transform);
        LOG.debug("Adding {} to {}", transform, (Object)this);
        this.transforms.pushNode(uniqueName, input, transform);
        try {
            this.transforms.finishSpecifyingInput();
            OutputT output = transform.expand(input);
            this.transforms.setOutput((POutput)output);
            OutputT OutputT = output;
            return OutputT;
        }
        finally {
            this.transforms.popNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> void applyReplacement(TransformHierarchy.Node original, PTransformOverrideFactory<InputT, OutputT, TransformT> replacementFactory) {
        PTransformOverrideFactory.PTransformReplacement<InputT, OutputT> replacement = replacementFactory.getReplacementTransform(original.toAppliedPTransform(this));
        if (replacement.getTransform() == original.getTransform()) {
            return;
        }
        InputT originalInput = replacement.getInput();
        Map<TupleTag<?>, PCollection<?>> originalOutputs = original.getOutputs();
        LOG.debug("Replacing {} with {}", (Object)original, replacement);
        this.transforms.replaceNode(original, (PInput)originalInput, replacement.getTransform());
        try {
            OutputT newOutput = replacement.getTransform().expand(originalInput);
            Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> originalToReplacement = replacementFactory.mapOutputs(original.getOutputs(), newOutput);
            this.transforms.setOutput((POutput)newOutput);
            this.transforms.replaceOutputs(originalToReplacement);
            Preconditions.checkState((boolean)ImmutableSet.copyOf(originalOutputs.values()).equals((Object)ImmutableSet.copyOf(this.transforms.getCurrent().getOutputs().values())), (String)"After replacing %s with %s, outputs were not rewired correctly: Original outputs %s became %s.", (Object)original, (Object)this.transforms.getCurrent(), originalOutputs, this.transforms.getCurrent().getOutputs());
        }
        finally {
            this.transforms.popNode();
        }
    }

    @VisibleForTesting
    void validate(PipelineOptions options) {
        this.traverseTopologically(new ValidateVisitor(options));
        Collection errors = Collections2.filter(this.instancePerName.asMap().entrySet(), (Predicate)Predicates.not(new IsUnique()));
        if (!errors.isEmpty()) {
            switch (options.getStableUniqueNames()) {
                case OFF: {
                    break;
                }
                case WARNING: {
                    LOG.warn("The following transforms do not have stable unique names: {}", (Object)Joiner.on((String)", ").join(Iterables.transform((Iterable)errors, (Function)new KeysExtractor())));
                    break;
                }
                case ERROR: {
                    throw new IllegalStateException(String.format("Pipeline update will not be possible because the following transforms do not have stable unique names: %s.", Joiner.on((String)", ").join(Iterables.transform((Iterable)errors, (Function)new KeysExtractor()))) + "\n\nConflicting instances:\n" + Joiner.on((String)"\n").join(Iterables.transform((Iterable)errors, (Function)new UnstableNameToMessage(this.instancePerName))) + "\n\nYou can fix it adding a name when you call apply(): pipeline.apply(<name>, <transform>).");
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized value for stable unique names: " + (Object)((Object)options.getStableUniqueNames()));
                }
            }
        }
    }

    private String uniquifyInternal(String namePrefix, String origName) {
        String name = origName;
        int suffixNum = 2;
        String candidate;
        while (!this.usedFullNames.add(candidate = this.buildName(namePrefix, name))) {
            name = origName + suffixNum++;
        }
        return candidate;
    }

    private String buildName(String namePrefix, String name) {
        return namePrefix.isEmpty() ? name : namePrefix + "/" + name;
    }

    private static class IsUnique<K, V>
    implements Predicate<Map.Entry<K, Collection<V>>> {
        private IsUnique() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public boolean apply(@Nonnull Map.Entry<K, Collection<V>> input) {
            return input != null && input.getValue().size() == 1;
        }
    }

    private static class KeysExtractor
    implements Function<Map.Entry<String, Collection<PTransform<?, ?>>>, String> {
        private KeysExtractor() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public String apply(@Nonnull Map.Entry<String, Collection<PTransform<?, ?>>> input) {
            return input.getKey();
        }
    }

    private static class UnstableNameToMessage
    implements Function<Map.Entry<String, Collection<PTransform<?, ?>>>, String> {
        private final Multimap<String, PTransform<?, ?>> instances;

        private UnstableNameToMessage(Multimap<String, PTransform<?, ?>> instancePerName) {
            this.instances = instancePerName;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public String apply(@Nonnull Map.Entry<String, Collection<PTransform<?, ?>>> input) {
            Collection values = this.instances.get((Object)input.getKey());
            return "- name=" + input.getKey() + ":\n" + Joiner.on((String)"\n").join(Iterables.transform((Iterable)values, (Function)new TransformToMessage()));
        }
    }

    private static class TransformToMessage
    implements Function<PTransform<?, ?>, String> {
        private TransformToMessage() {
        }

        public String apply(PTransform<?, ?> transform) {
            return "    - " + transform;
        }
    }

    private static class ValidateVisitor
    extends PipelineVisitor.Defaults {
        private final PipelineOptions options;

        public ValidateVisitor(PipelineOptions options) {
            this.options = options;
        }

        @Override
        public PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
            if (node.getTransform() != null) {
                node.getTransform().validate(this.options);
            }
            return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            node.getTransform().validate(this.options);
        }
    }

    @Internal
    public static interface PipelineVisitor {
        public void enterPipeline(Pipeline var1);

        public CompositeBehavior enterCompositeTransform(TransformHierarchy.Node var1);

        public void leaveCompositeTransform(TransformHierarchy.Node var1);

        public void visitPrimitiveTransform(TransformHierarchy.Node var1);

        public void visitValue(PValue var1, TransformHierarchy.Node var2);

        public void leavePipeline(Pipeline var1);

        public static class Defaults
        implements PipelineVisitor {
            private @Nullable Pipeline pipeline;

            protected Pipeline getPipeline() {
                if (this.pipeline == null) {
                    throw new IllegalStateException("Illegal access to pipeline after visitor traversal was completed");
                }
                return this.pipeline;
            }

            @Override
            public void enterPipeline(Pipeline pipeline) {
                this.pipeline = (Pipeline)Preconditions.checkNotNull((Object)pipeline);
            }

            @Override
            public CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                return CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void leaveCompositeTransform(TransformHierarchy.Node node) {
            }

            @Override
            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
            }

            @Override
            public void visitValue(PValue value, TransformHierarchy.Node producer) {
            }

            @Override
            public void leavePipeline(Pipeline pipeline) {
                this.pipeline = null;
            }
        }

        public static enum CompositeBehavior {
            ENTER_TRANSFORM,
            DO_NOT_ENTER_TRANSFORM;

        }
    }

    public static class PipelineExecutionException
    extends RuntimeException {
        public PipelineExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

