/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.concurrent.GuardedBy;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.utils.CountingInputStream;
import org.apache.beam.repackaged.core.org.apache.commons.compress.utils.IOUtils;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BlockBasedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class AvroSource<T>
extends BlockBasedSource<T> {
    private static final long DEFAULT_MIN_BUNDLE_SIZE = 128000L;
    private static final DatumReaderFactory<?> GENERIC_DATUM_READER_FACTORY = GenericDatumReader::new;
    private static final DatumReaderFactory<?> REFLECT_DATUM_READER_FACTORY = ReflectDatumReader::new;
    private final Mode<T> mode;
    private static final Map<String, Schema> schemaLogicalReferenceCache = new WeakHashMap<String, Schema>();
    private static final Map<String, String> schemaStringLogicalReferenceCache = new WeakHashMap<String, String>();

    private static Mode<GenericRecord> readGenericRecordsWithSchema(String schema, @Nullable DatumReaderFactory<?> factory) {
        return new Mode<GenericRecord>(GenericRecord.class, schema, null, null, factory);
    }

    private static <T> Mode<T> readGeneratedClasses(Class<T> clazz, @Nullable DatumReaderFactory<?> factory) {
        return new Mode(clazz, ReflectData.get().getSchema(clazz).toString(), null, null, factory);
    }

    private static <T> Mode<T> parseGenericRecords(SerializableFunction<GenericRecord, T> parseFn, Coder<T> outputCoder, @Nullable DatumReaderFactory<?> factory) {
        return new Mode(GenericRecord.class, null, parseFn, outputCoder, factory);
    }

    public static AvroSource<GenericRecord> from(ValueProvider<String> fileNameOrPattern) {
        return new AvroSource<GenericRecord>(fileNameOrPattern, EmptyMatchTreatment.DISALLOW, 128000L, AvroSource.readGenericRecordsWithSchema(null, null));
    }

    public static AvroSource<GenericRecord> from(MatchResult.Metadata metadata) {
        return new AvroSource<GenericRecord>(metadata, 128000L, 0L, metadata.sizeBytes(), AvroSource.readGenericRecordsWithSchema(null, null));
    }

    public static AvroSource<GenericRecord> from(String fileNameOrPattern) {
        return AvroSource.from(ValueProvider.StaticValueProvider.of(fileNameOrPattern));
    }

    public AvroSource<T> withEmptyMatchTreatment(EmptyMatchTreatment emptyMatchTreatment) {
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), emptyMatchTreatment, this.getMinBundleSize(), this.mode);
    }

    public AvroSource<GenericRecord> withSchema(String schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        return new AvroSource<GenericRecord>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.readGenericRecordsWithSchema(schema, ((Mode)this.mode).readerFactory));
    }

    public AvroSource<GenericRecord> withSchema(Schema schema) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
        return this.withSchema(schema.toString());
    }

    public <X> AvroSource<X> withSchema(Class<X> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<X>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), AvroSource.readGeneratedClasses(clazz, ((Mode)this.mode).readerFactory));
        }
        return new AvroSource<X>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.readGeneratedClasses(clazz, ((Mode)this.mode).readerFactory));
    }

    public <X> AvroSource<X> withParseFn(SerializableFunction<GenericRecord, X> parseFn, Coder<X> coder) {
        Preconditions.checkArgument((parseFn != null ? 1 : 0) != 0, (Object)"parseFn can not be null");
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<X>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), AvroSource.parseGenericRecords(parseFn, coder, ((Mode)this.mode).readerFactory));
        }
        return new AvroSource<X>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), AvroSource.parseGenericRecords(parseFn, coder, ((Mode)this.mode).readerFactory));
    }

    public AvroSource<T> withMinBundleSize(long minBundleSize) {
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), minBundleSize, this.getStartOffset(), this.getEndOffset(), this.mode);
        }
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), minBundleSize, this.mode);
    }

    public AvroSource<T> withDatumReaderFactory(DatumReaderFactory<?> factory) {
        Mode newMode = ((Mode)this.mode).withReaderFactory(factory);
        if (this.getMode() == FileBasedSource.Mode.SINGLE_FILE_OR_SUBRANGE) {
            return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), newMode);
        }
        return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), newMode);
    }

    private AvroSource(ValueProvider<String> fileNameOrPattern, EmptyMatchTreatment emptyMatchTreatment, long minBundleSize, Mode<T> mode) {
        super(fileNameOrPattern, emptyMatchTreatment, minBundleSize);
        this.mode = mode;
    }

    private AvroSource(MatchResult.Metadata metadata, long minBundleSize, long startOffset, long endOffset, Mode<T> mode) {
        super(metadata, minBundleSize, startOffset, endOffset);
        this.mode = mode;
    }

    @Override
    public void validate() {
        super.validate();
        ((Mode)this.mode).validate();
    }

    @Deprecated
    public BlockBasedSource<T> createForSubrangeOfFile(String fileName, long start, long end) throws IOException {
        return this.createForSubrangeOfFile(FileSystems.matchSingleFileSpec(fileName), start, end);
    }

    @Override
    public BlockBasedSource<T> createForSubrangeOfFile(MatchResult.Metadata fileMetadata, long start, long end) {
        return new AvroSource<T>(fileMetadata, this.getMinBundleSize(), start, end, this.mode);
    }

    @Override
    protected BlockBasedSource.BlockBasedReader<T> createSingleFileReader(PipelineOptions options) {
        return new AvroReader(this);
    }

    @Override
    public Coder<T> getOutputCoder() {
        return ((Mode)this.mode).getOutputCoder();
    }

    @VisibleForTesting
    @Nullable String getReaderSchemaString() {
        return ((Mode)this.mode).readerSchemaString;
    }

    @VisibleForTesting
    static AvroMetadata readMetadataFromFile(ResourceId fileResource) throws IOException {
        byte[] syncMarker;
        String codec = null;
        String schemaString = null;
        try (InputStream stream = Channels.newInputStream(FileSystems.open(fileResource));){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(stream, null);
            byte[] magic = new byte[DataFileConstants.MAGIC.length];
            decoder.readFixed(magic);
            if (!Arrays.equals(magic, DataFileConstants.MAGIC)) {
                throw new IOException("Missing Avro file signature: " + fileResource);
            }
            ByteBuffer valueBuffer = ByteBuffer.allocate(512);
            long numRecords = decoder.readMapStart();
            while (numRecords > 0L) {
                for (long recordIndex = 0L; recordIndex < numRecords; ++recordIndex) {
                    String key = decoder.readString();
                    valueBuffer = decoder.readBytes(valueBuffer);
                    byte[] bytes = new byte[valueBuffer.remaining()];
                    valueBuffer.get(bytes);
                    if (key.equals("avro.codec")) {
                        codec = new String(bytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!key.equals("avro.schema")) continue;
                    schemaString = new String(bytes, StandardCharsets.UTF_8);
                }
                numRecords = decoder.mapNext();
            }
            if (codec == null) {
                codec = "null";
            }
            syncMarker = new byte[16];
            decoder.readFixed(syncMarker);
        }
        Preconditions.checkState((schemaString != null ? 1 : 0) != 0, (String)"No schema present in Avro file metadata %s", (Object)fileResource);
        return new AvroMetadata(syncMarker, codec, schemaString);
    }

    private static synchronized String internSchemaString(String schema) {
        String internSchema = schemaStringLogicalReferenceCache.get(schema);
        if (internSchema != null) {
            return internSchema;
        }
        schemaStringLogicalReferenceCache.put(schema, schema);
        return schema;
    }

    private static synchronized Schema internOrParseSchemaString(String schemaString) {
        Schema schema = schemaLogicalReferenceCache.get(schemaString);
        if (schema != null) {
            return schema;
        }
        Schema.Parser parser = new Schema.Parser();
        schema = parser.parse(schemaString);
        schemaLogicalReferenceCache.put(schemaString, schema);
        return schema;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.getMode()) {
            case SINGLE_FILE_OR_SUBRANGE: {
                return new AvroSource<T>(this.getSingleFileMetadata(), this.getMinBundleSize(), this.getStartOffset(), this.getEndOffset(), this.mode);
            }
            case FILEPATTERN: {
                return new AvroSource<T>(this.getFileOrPatternSpecProvider(), this.getEmptyMatchTreatment(), this.getMinBundleSize(), this.mode);
            }
        }
        throw new InvalidObjectException(String.format("Unknown mode %s for AvroSource %s", new Object[]{this.getMode(), this}));
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static class AvroReader<T>
    extends BlockBasedSource.BlockBasedReader<T> {
        private @Nullable AvroMetadata metadata;
        private @Nullable AvroBlock<T> currentBlock;
        private final Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private long currentBlockOffset = 0L;
        @GuardedBy(value="progressLock")
        private long currentBlockSizeBytes = 0L;
        private @Nullable PushbackInputStream stream;
        private @Nullable CountingInputStream countStream;
        private @Nullable BinaryDecoder decoder;

        public AvroReader(AvroSource<T> source) {
            super(source);
        }

        @Override
        public synchronized AvroSource<T> getCurrentSource() {
            return (AvroSource)super.getCurrentSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readNextBlock() throws IOException {
            long numRecords;
            long startOfNextBlock;
            Object object = this.progressLock;
            synchronized (object) {
                startOfNextBlock = this.currentBlockOffset + this.currentBlockSizeBytes;
            }
            long preHeaderCount = this.countStream.getBytesRead();
            this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)this.countStream, this.decoder);
            try {
                numRecords = this.decoder.readLong();
            }
            catch (EOFException e) {
                return false;
            }
            long blockSize = this.decoder.readLong();
            long headerSize = this.countStream.getBytesRead() - preHeaderCount;
            byte[] data = new byte[(int)blockSize];
            int bytesRead = IOUtils.readFully(this.stream, data);
            Preconditions.checkState((blockSize == (long)bytesRead ? 1 : 0) != 0, (String)"Only able to read %s/%s bytes in the block before EOF reached.", (int)bytesRead, (long)blockSize);
            this.currentBlock = new AvroBlock(data, numRecords, ((AvroSource)this.getCurrentSource()).mode, this.metadata.getSchemaString(), this.metadata.getCodec());
            byte[] syncMarker = this.metadata.getSyncMarker();
            byte[] readSyncMarker = new byte[syncMarker.length];
            long syncMarkerOffset = startOfNextBlock + headerSize + blockSize;
            bytesRead = IOUtils.readFully(this.stream, readSyncMarker);
            Preconditions.checkState((bytesRead == syncMarker.length ? 1 : 0) != 0, (String)"Only able to read %s/%s bytes of Avro sync marker at position %s before EOF reached.", (Object)bytesRead, (Object)syncMarker.length, (Object)syncMarkerOffset);
            if (!Arrays.equals(syncMarker, readSyncMarker)) {
                throw new IllegalStateException(String.format("Expected the bytes [%d,%d) in file %s to be a sync marker, but found %s", syncMarkerOffset, syncMarkerOffset + (long)syncMarker.length, this.getCurrentSource().getFileOrPatternSpec(), Arrays.toString(readSyncMarker)));
            }
            Object object2 = this.progressLock;
            synchronized (object2) {
                this.currentBlockOffset = startOfNextBlock;
                this.currentBlockSizeBytes = headerSize + blockSize + (long)syncMarker.length;
            }
            return true;
        }

        @Override
        public AvroBlock<T> getCurrentBlock() {
            return this.currentBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentBlockOffset() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentBlockSize() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.currentBlockSizeBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSplitPointsRemaining() {
            if (this.isDone()) {
                return 0L;
            }
            Object object = this.progressLock;
            synchronized (object) {
                if (this.currentBlockOffset + this.currentBlockSizeBytes >= this.getCurrentSource().getEndOffset()) {
                    return 1L;
                }
            }
            return super.getSplitPointsRemaining();
        }

        private PushbackInputStream createStream(ReadableByteChannel channel) {
            return new PushbackInputStream(Channels.newInputStream(channel), this.metadata.getSyncMarker().length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void startReading(ReadableByteChannel channel) throws IOException {
            try {
                this.metadata = AvroSource.readMetadataFromFile(this.getCurrentSource().getSingleFileMetadata().resourceId());
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading metadata from file " + this.getCurrentSource().getSingleFileMetadata(), e);
            }
            long startOffset = this.getCurrentSource().getStartOffset();
            byte[] syncMarker = this.metadata.getSyncMarker();
            long syncMarkerLength = syncMarker.length;
            if (startOffset != 0L) {
                long position = Math.max(0L, startOffset - syncMarkerLength);
                ((SeekableByteChannel)channel).position(position);
                startOffset = position;
            }
            this.stream = this.createStream(channel);
            this.countStream = new CountingInputStream(this.stream);
            Object object = this.progressLock;
            synchronized (object) {
                this.currentBlockOffset = startOffset + AvroReader.advancePastNextSyncMarker(this.stream, syncMarker);
                this.currentBlockSizeBytes = 0L;
            }
        }

        static long advancePastNextSyncMarker(PushbackInputStream stream, byte[] syncMarker) throws IOException {
            int read;
            Seeker seeker = new Seeker(syncMarker);
            byte[] syncBuffer = new byte[syncMarker.length];
            long totalBytesConsumed = 0L;
            int mark = -1;
            do {
                if ((read = stream.read(syncBuffer)) < 0) continue;
                mark = seeker.find(syncBuffer, read);
                totalBytesConsumed += (long)read;
            } while (mark < 0 && read > 0);
            if (mark >= 0) {
                stream.unread(syncBuffer, mark + 1, read - (mark + 1));
                totalBytesConsumed -= (long)(read - (mark + 1));
            }
            return totalBytesConsumed;
        }

        static class Seeker {
            private byte[] marker;
            private byte[] searchBuffer;
            private int available = 0;

            public Seeker(byte[] marker) {
                this.marker = marker;
                this.searchBuffer = new byte[marker.length];
            }

            public int find(byte[] buffer, int length) {
                for (int i = 0; i < length; ++i) {
                    System.arraycopy(this.searchBuffer, 1, this.searchBuffer, 0, this.searchBuffer.length - 1);
                    this.searchBuffer[this.searchBuffer.length - 1] = buffer[i];
                    this.available = Math.min(this.available + 1, this.searchBuffer.length);
                    if (!ByteBuffer.wrap(this.searchBuffer, this.searchBuffer.length - this.available, this.available).equals(ByteBuffer.wrap(this.marker))) continue;
                    this.available = 0;
                    return i;
                }
                return -1;
            }
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    static class AvroBlock<T>
    extends BlockBasedSource.Block<T> {
        private final Mode<T> mode;
        private final long numRecords;
        private @Nullable T currentRecord;
        private long currentRecordIndex = 0L;
        private final DatumReader<?> reader;
        private final BinaryDecoder decoder;

        private static InputStream decodeAsInputStream(byte[] data, String codec) throws IOException {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            switch (codec) {
                case "snappy": {
                    return new SnappyCompressorInputStream(byteStream, 65536);
                }
                case "deflate": {
                    Inflater inflater = new Inflater(true);
                    return new InflaterInputStream(byteStream, inflater);
                }
                case "xz": {
                    return new XZCompressorInputStream(byteStream);
                }
                case "bzip2": {
                    return new BZip2CompressorInputStream(byteStream);
                }
                case "null": {
                    return byteStream;
                }
            }
            throw new IllegalArgumentException("Unsupported codec: " + codec);
        }

        AvroBlock(byte[] data, long numRecords, Mode<T> mode, String writerSchemaString, String codec) throws IOException {
            this.mode = mode;
            this.numRecords = numRecords;
            Preconditions.checkNotNull((Object)writerSchemaString, (Object)"writerSchemaString");
            Schema writerSchema = AvroSource.internOrParseSchemaString(writerSchemaString);
            Schema readerSchema = AvroSource.internOrParseSchemaString((String)MoreObjects.firstNonNull((Object)((Mode)mode).readerSchemaString, (Object)writerSchemaString));
            this.reader = ((Mode)mode).createReader(writerSchema, readerSchema);
            this.decoder = codec.equals("null") ? DecoderFactory.get().binaryDecoder(data, null) : DecoderFactory.get().binaryDecoder(AvroBlock.decodeAsInputStream(data, codec), null);
        }

        @Override
        public T getCurrentRecord() {
            return this.currentRecord;
        }

        @Override
        public boolean readNextRecord() throws IOException {
            if (this.currentRecordIndex >= this.numRecords) {
                return false;
            }
            Object record = this.reader.read(null, (Decoder)this.decoder);
            this.currentRecord = ((Mode)this.mode).parseFn == null ? record : ((Mode)this.mode).parseFn.apply((GenericRecord)record);
            ++this.currentRecordIndex;
            return true;
        }

        @Override
        public double getFractionOfBlockConsumed() {
            return (double)this.currentRecordIndex / (double)this.numRecords;
        }
    }

    @VisibleForTesting
    static class AvroMetadata {
        private final byte[] syncMarker;
        private final String codec;
        private final String schemaString;

        AvroMetadata(byte[] syncMarker, String codec, String schemaString) {
            this.syncMarker = (byte[])Preconditions.checkNotNull((Object)syncMarker, (Object)"syncMarker");
            this.codec = (String)Preconditions.checkNotNull((Object)codec, (Object)"codec");
            this.schemaString = AvroSource.internSchemaString((String)Preconditions.checkNotNull((Object)schemaString, (Object)"schemaString"));
        }

        public String getSchemaString() {
            return this.schemaString;
        }

        public String getCodec() {
            return this.codec;
        }

        public byte[] getSyncMarker() {
            return this.syncMarker;
        }
    }

    private static class Mode<T>
    implements Serializable {
        private final Class<?> type;
        private @Nullable String readerSchemaString;
        private final @Nullable SerializableFunction<GenericRecord, T> parseFn;
        private final @Nullable Coder<T> outputCoder;
        private final @Nullable DatumReaderFactory<?> readerFactory;

        private Mode(Class<?> type, @Nullable String readerSchemaString, @Nullable SerializableFunction<GenericRecord, T> parseFn, @Nullable Coder<T> outputCoder, @Nullable DatumReaderFactory<?> readerFactory) {
            this.type = type;
            this.readerSchemaString = AvroSource.internSchemaString(readerSchemaString);
            this.parseFn = parseFn;
            this.outputCoder = outputCoder;
            this.readerFactory = readerFactory;
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            this.readerSchemaString = AvroSource.internSchemaString(this.readerSchemaString);
        }

        private Coder<T> getOutputCoder() {
            if (this.parseFn == null) {
                return AvroCoder.of(this.type, AvroSource.internOrParseSchemaString(this.readerSchemaString));
            }
            return this.outputCoder;
        }

        private void validate() {
            if (this.parseFn == null) {
                Preconditions.checkArgument((this.readerSchemaString != null ? 1 : 0) != 0, (Object)"schema must be specified using withSchema() when not using a parse fn");
            }
        }

        private Mode<T> withReaderFactory(DatumReaderFactory<?> factory) {
            return new Mode<T>(this.type, this.readerSchemaString, this.parseFn, this.outputCoder, factory);
        }

        private DatumReader<?> createReader(Schema writerSchema, Schema readerSchema) {
            DatumReaderFactory factory = this.readerFactory;
            if (factory == null) {
                factory = this.type == GenericRecord.class ? GENERIC_DATUM_READER_FACTORY : REFLECT_DATUM_READER_FACTORY;
            }
            return factory.apply(writerSchema, readerSchema);
        }
    }

    @FunctionalInterface
    public static interface DatumReaderFactory<T>
    extends Serializable {
        public DatumReader<T> apply(Schema var1, Schema var2);
    }
}

