/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public abstract class FileBasedSink<UserT, DestinationT, OutputT>
implements Serializable,
HasDisplayData {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedSink.class);
    static final String TEMP_DIRECTORY_PREFIX = ".temp-beam";
    private final DynamicDestinations<?, DestinationT, OutputT> dynamicDestinations;
    private final WritableByteChannelFactory writableByteChannelFactory;
    private final ValueProvider<ResourceId> tempDirectoryProvider;

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public static ResourceId convertToFileResourceIfPossible(String outputPrefix) {
        try {
            return FileSystems.matchNewResource(outputPrefix, false);
        }
        catch (Exception e) {
            return FileSystems.matchNewResource(outputPrefix, true);
        }
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public FileBasedSink(ValueProvider<ResourceId> tempDirectoryProvider, DynamicDestinations<?, DestinationT, OutputT> dynamicDestinations) {
        this(tempDirectoryProvider, dynamicDestinations, Compression.UNCOMPRESSED);
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public FileBasedSink(ValueProvider<ResourceId> tempDirectoryProvider, DynamicDestinations<?, DestinationT, OutputT> dynamicDestinations, WritableByteChannelFactory writableByteChannelFactory) {
        this.tempDirectoryProvider = ValueProvider.NestedValueProvider.of(tempDirectoryProvider, new ExtractDirectory());
        this.dynamicDestinations = (DynamicDestinations)Preconditions.checkNotNull(dynamicDestinations);
        this.writableByteChannelFactory = writableByteChannelFactory;
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public FileBasedSink(ValueProvider<ResourceId> tempDirectoryProvider, DynamicDestinations<?, DestinationT, OutputT> dynamicDestinations, Compression compression) {
        this(tempDirectoryProvider, dynamicDestinations, CompressionType.fromCanonical(compression));
    }

    public DynamicDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public ValueProvider<ResourceId> getTempDirectoryProvider() {
        return this.tempDirectoryProvider;
    }

    public void validate(PipelineOptions options) {
    }

    public abstract WriteOperation<DestinationT, OutputT> createWriteOperation();

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        this.getDynamicDestinations().populateDisplayData(builder);
    }

    protected final WritableByteChannelFactory getWritableByteChannelFactory() {
        return this.writableByteChannelFactory;
    }

    public static interface WritableByteChannelFactory
    extends OutputFileHints {
        public WritableByteChannel create(WritableByteChannel var1) throws IOException;
    }

    public static interface OutputFileHints
    extends Serializable {
        public @Nullable String getMimeType();

        public @Nullable String getSuggestedFilenameSuffix();
    }

    public static final class FileResultCoder<DestinationT>
    extends StructuredCoder<FileResult<DestinationT>> {
        private static final Coder<String> FILENAME_CODER = StringUtf8Coder.of();
        private static final Coder<Integer> SHARD_CODER = VarIntCoder.of();
        private static final Coder<PaneInfo> PANE_INFO_CODER = NullableCoder.of(PaneInfo.PaneInfoCoder.INSTANCE);
        private final Coder<BoundedWindow> windowCoder;
        private final Coder<DestinationT> destinationCoder;

        protected FileResultCoder(Coder<BoundedWindow> windowCoder, Coder<DestinationT> destinationCoder) {
            this.windowCoder = NullableCoder.of(windowCoder);
            this.destinationCoder = destinationCoder;
        }

        public static <DestinationT> FileResultCoder<DestinationT> of(Coder<BoundedWindow> windowCoder, Coder<DestinationT> destinationCoder) {
            return new FileResultCoder<DestinationT>(windowCoder, destinationCoder);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        @Override
        public void encode(FileResult<DestinationT> value, OutputStream outStream) throws IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            FILENAME_CODER.encode(value.getTempFilename().toString(), outStream);
            this.windowCoder.encode(value.getWindow(), outStream);
            PANE_INFO_CODER.encode(value.getPaneInfo(), outStream);
            SHARD_CODER.encode(value.getShard(), outStream);
            this.destinationCoder.encode(value.getDestination(), outStream);
        }

        @Override
        public FileResult<DestinationT> decode(InputStream inStream) throws IOException {
            String tempFilename = FILENAME_CODER.decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo paneInfo = PANE_INFO_CODER.decode(inStream);
            int shard = SHARD_CODER.decode(inStream);
            DestinationT destination = this.destinationCoder.decode(inStream);
            return new FileResult<DestinationT>(FileSystems.matchNewResource(tempFilename, false), shard, window, paneInfo, destination);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            FILENAME_CODER.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
            PANE_INFO_CODER.verifyDeterministic();
            SHARD_CODER.verifyDeterministic();
            this.destinationCoder.verifyDeterministic();
        }
    }

    public static final class FileResult<DestinationT> {
        private final ResourceId tempFilename;
        private final int shard;
        private final BoundedWindow window;
        private final PaneInfo paneInfo;
        private final DestinationT destination;

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public FileResult(ResourceId tempFilename, int shard, BoundedWindow window, PaneInfo paneInfo, DestinationT destination) {
            Preconditions.checkArgument((window != null ? 1 : 0) != 0, (Object)"window can not be null");
            Preconditions.checkArgument((paneInfo != null ? 1 : 0) != 0, (Object)"paneInfo can not be null");
            this.tempFilename = tempFilename;
            this.shard = shard;
            this.window = window;
            this.paneInfo = paneInfo;
            this.destination = destination;
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public ResourceId getTempFilename() {
            return this.tempFilename;
        }

        public int getShard() {
            return this.shard;
        }

        public FileResult<DestinationT> withShard(int shard) {
            return new FileResult<DestinationT>(this.tempFilename, shard, this.window, this.paneInfo, this.destination);
        }

        public @Nullable BoundedWindow getWindow() {
            return this.window;
        }

        public PaneInfo getPaneInfo() {
            return this.paneInfo;
        }

        public DestinationT getDestination() {
            return this.destination;
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public ResourceId getDestinationFile(boolean windowedWrites, DynamicDestinations<?, DestinationT, ?> dynamicDestinations, int numShards, OutputFileHints outputFileHints) {
            Preconditions.checkArgument((this.getShard() != -1 ? 1 : 0) != 0);
            Preconditions.checkArgument((numShards > 0 ? 1 : 0) != 0);
            FilenamePolicy policy = dynamicDestinations.getFilenamePolicy(this.destination);
            if (windowedWrites) {
                return policy.windowedFilename(this.getShard(), numShards, this.getWindow(), this.getPaneInfo(), outputFileHints);
            }
            return policy.unwindowedFilename(this.getShard(), numShards, outputFileHints);
        }

        public String toString() {
            return MoreObjects.toStringHelper(FileResult.class).add("tempFilename", (Object)this.tempFilename).add("shard", this.shard).add("window", (Object)this.window).add("paneInfo", (Object)this.paneInfo).toString();
        }
    }

    public static abstract class Writer<DestinationT, OutputT> {
        private static final Logger LOG = LoggerFactory.getLogger(Writer.class);
        private final WriteOperation<DestinationT, OutputT> writeOperation;
        private @Nullable String id;
        private @Nullable DestinationT destination;
        private @Nullable ResourceId outputFile;
        private @Nullable WritableByteChannel channel;
        private final @Nullable String mimeType;

        public Writer(WriteOperation<DestinationT, OutputT> writeOperation, String mimeType) {
            Preconditions.checkNotNull(writeOperation);
            this.writeOperation = writeOperation;
            this.mimeType = mimeType;
        }

        protected abstract void prepareWrite(WritableByteChannel var1) throws Exception;

        protected void writeHeader() throws Exception {
        }

        protected void writeFooter() throws Exception {
        }

        protected void finishWrite() throws Exception {
        }

        @VisibleForTesting
        static String spreadUid(String uId) {
            return String.format("%08x%s", uId.hashCode(), uId);
        }

        public final void open(String uId) throws Exception {
            this.id = Writer.spreadUid(uId);
            ResourceId tempDirectory = this.getWriteOperation().getTempDirectory();
            this.outputFile = tempDirectory.resolve(this.id, ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            Verify.verifyNotNull((Object)this.outputFile, (String)"FileSystems are not allowed to return null from resolve: %s", (Object[])new Object[]{tempDirectory});
            WritableByteChannelFactory factory = ((FileBasedSink)this.getWriteOperation().getSink()).writableByteChannelFactory;
            String channelMimeType = (String)MoreObjects.firstNonNull((Object)factory.getMimeType(), (Object)this.mimeType);
            CreateOptions.StandardCreateOptions createOptions = ((CreateOptions.StandardCreateOptions.Builder)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType(channelMimeType)).setExpectFileToNotExist(true)).build();
            WritableByteChannel tempChannel = FileSystems.create(this.outputFile, createOptions);
            try {
                this.channel = factory.create(tempChannel);
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(tempChannel, this.outputFile, e);
            }
            try {
                LOG.debug("Preparing write to {}.", (Object)this.outputFile);
                this.prepareWrite(this.channel);
                LOG.debug("Writing header to {}.", (Object)this.outputFile);
                this.writeHeader();
            }
            catch (Exception e) {
                LOG.error("Beginning write to {} failed, closing channel.", (Object)this.outputFile, (Object)e);
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            LOG.debug("Starting write of bundle {} to {}.", (Object)this.id, (Object)this.outputFile);
        }

        public abstract void write(OutputT var1) throws Exception;

        public ResourceId getOutputFile() {
            return this.outputFile;
        }

        private static void closeChannelAndThrow(WritableByteChannel channel, ResourceId filename, Exception prior) throws Exception {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOG.error("Closing channel for {} failed.", (Object)filename, (Object)e);
                prior.addSuppressed(e);
            }
            throw prior;
        }

        public final void cleanup() throws Exception {
            if (this.outputFile != null) {
                LOG.info("Deleting temporary file {}", (Object)this.outputFile);
                FileSystems.delete(Collections.singletonList(this.outputFile), MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
            }
        }

        public final void close() throws Exception {
            Preconditions.checkState((this.outputFile != null ? 1 : 0) != 0, (Object)"FileResult.close cannot be called with a null outputFile");
            LOG.debug("Closing {}", (Object)this.outputFile);
            try {
                this.writeFooter();
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            try {
                this.finishWrite();
            }
            catch (Exception e) {
                Writer.closeChannelAndThrow(this.channel, this.outputFile, e);
            }
            if (this.channel.isOpen()) {
                LOG.debug("Closing channel to {}.", (Object)this.outputFile);
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    throw new IOException(String.format("Failed closing channel to %s", this.outputFile), e);
                }
            }
            LOG.info("Successfully wrote temporary file {}", (Object)this.outputFile);
        }

        public WriteOperation<DestinationT, OutputT> getWriteOperation() {
            return this.writeOperation;
        }

        void setDestination(DestinationT destination) {
            this.destination = destination;
        }

        public DestinationT getDestination() {
            return this.destination;
        }
    }

    public static abstract class WriteOperation<DestinationT, OutputT>
    implements Serializable {
        protected final FileBasedSink<?, DestinationT, OutputT> sink;
        private final ValueProvider<ResourceId> baseTempDirectory;
        private TempSubDirType tempSubdirType;
        private final UUID subdirUUID;
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        protected boolean windowedWrites;

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        protected static ResourceId buildTemporaryFilename(ResourceId tempDirectory, String filename) throws IOException {
            return tempDirectory.resolve(filename, ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public WriteOperation(FileBasedSink<?, DestinationT, OutputT> sink) {
            this(sink, sink.getTempDirectoryProvider(), TempSubDirType.UNIQUE);
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public WriteOperation(FileBasedSink<?, DestinationT, OutputT> sink, ResourceId tempDirectory) {
            this(sink, ValueProvider.StaticValueProvider.of(tempDirectory), TempSubDirType.NONE);
        }

        private WriteOperation(FileBasedSink<?, DestinationT, OutputT> sink, ValueProvider<ResourceId> tempDirectory, TempSubDirType tempSubdirType) {
            this.sink = sink;
            this.baseTempDirectory = tempDirectory;
            this.tempSubdirType = tempSubdirType;
            this.subdirUUID = UUID.randomUUID();
            this.windowedWrites = false;
        }

        public ResourceId getTempDirectory() {
            String tempDirName;
            if (this.tempSubdirType == TempSubDirType.NONE) {
                return this.baseTempDirectory.get();
            }
            if (this.tempSubdirType == TempSubDirType.UNIQUE) {
                tempDirName = String.format(".temp-beam-%s", this.subdirUUID);
            } else {
                assert (this.tempSubdirType == TempSubDirType.CONSISTENT);
                tempDirName = FileBasedSink.TEMP_DIRECTORY_PREFIX;
            }
            return this.baseTempDirectory.get().getCurrentDirectory().resolve(tempDirName, ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        }

        public abstract Writer<DestinationT, OutputT> createWriter() throws Exception;

        public void setWindowedWrites() {
            this.windowedWrites = true;
            this.tempSubdirType = TempSubDirType.CONSISTENT;
        }

        public void removeTemporaryFiles(Collection<ResourceId> filenames) throws IOException {
            this.removeTemporaryFiles(filenames, !this.windowedWrites);
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        protected final List<KV<FileResult<DestinationT>, ResourceId>> finalizeDestination(@Nullable DestinationT dest, @Nullable BoundedWindow window, @Nullable Integer numShards, Collection<FileResult<DestinationT>> existingResults) throws Exception {
            int effectiveNumShards;
            Collection<FileResult<DestinationT>> completeResults = this.windowedWrites ? existingResults : this.createMissingEmptyShards(dest, numShards, existingResults);
            for (FileResult<DestinationT> res : completeResults) {
                Preconditions.checkArgument((boolean)Objects.equals(dest, res.getDestination()), (String)"File result has wrong destination: expected %s, got %s", dest, res.getDestination());
                Preconditions.checkArgument((boolean)Objects.equals(window, res.getWindow()), (String)"File result has wrong window: expected %s, got %s", (Object)window, (Object)res.getWindow());
            }
            ArrayList outputFilenames = Lists.newArrayList();
            if (numShards != null) {
                effectiveNumShards = numShards;
                for (FileResult<DestinationT> res : completeResults) {
                    Preconditions.checkArgument((res.getShard() != -1 ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but file result %s does not specify a shard", (Object)numShards, res);
                }
            } else {
                effectiveNumShards = Iterables.size(completeResults);
                for (FileResult<DestinationT> res : completeResults) {
                    Preconditions.checkArgument((res.getShard() == -1 ? 1 : 0) != 0, (String)"Runner-chosen sharding was specified, but file result %s explicitly specifies a shard", res);
                }
            }
            ArrayList resultsWithShardNumbers = Lists.newArrayList();
            if (numShards != null) {
                resultsWithShardNumbers = Lists.newArrayList(completeResults);
            } else {
                int i = 0;
                for (FileResult<Object> fileResult : completeResults) {
                    resultsWithShardNumbers.add(fileResult.withShard(i++));
                }
            }
            HashMap distinctFilenames = Maps.newHashMap();
            for (FileResult<Object> fileResult : resultsWithShardNumbers) {
                Preconditions.checkArgument((fileResult.getShard() != -1 ? 1 : 0) != 0, (String)"Should have set shard number on %s", fileResult);
                ResourceId finalFilename = fileResult.getDestinationFile(this.windowedWrites, this.getSink().getDynamicDestinations(), effectiveNumShards, this.getSink().getWritableByteChannelFactory());
                Preconditions.checkArgument((!distinctFilenames.containsKey(finalFilename) ? 1 : 0) != 0, (String)"Filename policy must generate unique filenames, but generated the same name %s for file results %s and %s", (Object)finalFilename, fileResult, distinctFilenames.get(finalFilename));
                distinctFilenames.put(finalFilename, fileResult);
                outputFilenames.add(KV.of(fileResult, finalFilename));
            }
            return outputFilenames;
        }

        private Collection<FileResult<DestinationT>> createMissingEmptyShards(@Nullable DestinationT dest, @Nullable Integer numShards, Collection<FileResult<DestinationT>> existingResults) throws Exception {
            HashSet missingShardNums;
            LOG.info("Finalizing for destination {} num shards {}.", dest, (Object)existingResults.size());
            if (numShards != null) {
                Preconditions.checkArgument((existingResults.size() <= numShards ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but got %s file results", (Object)numShards, (int)existingResults.size());
            }
            if (numShards == null) {
                missingShardNums = existingResults.isEmpty() ? ImmutableSet.of((Object)-1) : ImmutableSet.of();
            } else {
                missingShardNums = Sets.newHashSet();
                for (int i = 0; i < numShards; ++i) {
                    missingShardNums.add(i);
                }
                for (FileResult<DestinationT> res : existingResults) {
                    Preconditions.checkArgument((res.getShard() != -1 ? 1 : 0) != 0, (String)"Fixed sharding into %s shards was specified, but file result %s does not specify a shard", (Object)numShards, res);
                    missingShardNums.remove(res.getShard());
                }
            }
            ArrayList completeResults = Lists.newArrayList(existingResults);
            if (!missingShardNums.isEmpty()) {
                LOG.info("Creating {} empty output shards in addition to {} written for destination {}.", new Object[]{missingShardNums.size(), existingResults.size(), dest});
                Iterator<FileResult<Object>> iterator = missingShardNums.iterator();
                while (iterator.hasNext()) {
                    int shard = (Integer)((Object)iterator.next());
                    String uuid = UUID.randomUUID().toString();
                    LOG.info("Opening empty writer {} for destination {}", (Object)uuid, dest);
                    Writer<DestinationT, OutputT> writer = this.createWriter();
                    writer.setDestination(dest);
                    writer.open(uuid);
                    writer.close();
                    completeResults.add(new FileResult<DestinationT>(writer.getOutputFile(), shard, GlobalWindow.INSTANCE, PaneInfo.ON_TIME_AND_ONLY_FIRING, dest));
                }
                LOG.debug("Done creating extra shards for {}.", dest);
            }
            return completeResults;
        }

        @VisibleForTesting
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        final void moveToOutputFiles(List<KV<FileResult<DestinationT>, ResourceId>> resultsToFinalFilenames) throws IOException {
            int numFiles = resultsToFinalFilenames.size();
            LOG.debug("Copying {} files.", (Object)numFiles);
            ArrayList<ResourceId> srcFiles = new ArrayList<ResourceId>();
            ArrayList<ResourceId> dstFiles = new ArrayList<ResourceId>();
            for (KV<FileResult<DestinationT>, ResourceId> entry : resultsToFinalFilenames) {
                srcFiles.add(entry.getKey().getTempFilename());
                dstFiles.add(entry.getValue());
                LOG.info("Will copy temporary file {} to final location {}", entry.getKey(), (Object)entry.getValue());
            }
            FileSystems.rename(srcFiles, dstFiles, MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES, MoveOptions.StandardMoveOptions.SKIP_IF_DESTINATION_EXISTS);
            this.removeTemporaryFiles(Collections.emptyList());
        }

        @VisibleForTesting
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        final void removeTemporaryFiles(Collection<ResourceId> knownFiles, boolean shouldRemoveTemporaryDirectory) throws IOException {
            HashSet<ResourceId> allMatches = new HashSet<ResourceId>(knownFiles);
            for (ResourceId match : allMatches) {
                LOG.info("Will remove known temporary file {}", (Object)match);
            }
            ResourceId tempDir = this.getTempDirectory();
            if (shouldRemoveTemporaryDirectory) {
                LOG.debug("Removing temporary bundle output files in {}.", (Object)tempDir);
                try {
                    MatchResult singleMatch = (MatchResult)Iterables.getOnlyElement(FileSystems.match(Collections.singletonList(tempDir.toString() + "*")));
                    for (MatchResult.Metadata matchResult : singleMatch.metadata()) {
                        if (!allMatches.add(matchResult.resourceId())) continue;
                        LOG.warn("Will also remove unknown temporary file {}. This might indicate that other process/job is using the same temporary folder and result in data consistency issues.", (Object)matchResult.resourceId());
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to match temporary files under: [{}].", (Object)tempDir);
                }
            }
            FileSystems.delete(allMatches, MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
            if (shouldRemoveTemporaryDirectory) {
                try {
                    FileSystems.delete(Collections.singletonList(tempDir), MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES);
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove temporary directory: [{}].", (Object)tempDir);
                }
            }
        }

        public FileBasedSink<?, DestinationT, OutputT> getSink() {
            return this.sink;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{tempDirectory=" + this.getTempDirectory() + ", windowedWrites=" + this.windowedWrites + '}';
        }

        private static enum TempSubDirType {
            NONE,
            UNIQUE,
            CONSISTENT;

        }
    }

    private static class ExtractDirectory
    implements SerializableFunction<ResourceId, ResourceId> {
        private ExtractDirectory() {
        }

        @Override
        public ResourceId apply(ResourceId input) {
            return input.getCurrentDirectory();
        }
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public static abstract class FilenamePolicy
    implements Serializable {
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public abstract ResourceId windowedFilename(int var1, int var2, BoundedWindow var3, PaneInfo var4, OutputFileHints var5);

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public abstract @Nullable ResourceId unwindowedFilename(int var1, int var2, OutputFileHints var3);

        public void populateDisplayData(DisplayData.Builder builder) {
        }
    }

    @Experimental(value=Experimental.Kind.FILESYSTEM)
    public static abstract class DynamicDestinations<UserT, DestinationT, OutputT>
    implements HasDisplayData,
    Serializable {
        private transient @Nullable SideInputAccessor sideInputAccessor;

        public List<PCollectionView<?>> getSideInputs() {
            return ImmutableList.of();
        }

        protected final <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
            Preconditions.checkState((this.sideInputAccessor != null ? 1 : 0) != 0, (String)"sideInput called on %s but side inputs have not been initialized", (Object)this.getClass().getName());
            return this.sideInputAccessor.sideInput(view);
        }

        final void setSideInputAccessor(SideInputAccessor sideInputAccessor) {
            this.sideInputAccessor = sideInputAccessor;
        }

        final void setSideInputAccessorFromProcessContext(DoFn.ProcessContext context) {
            this.sideInputAccessor = new SideInputAccessorViaProcessContext(context);
        }

        public abstract OutputT formatRecord(UserT var1);

        public abstract DestinationT getDestination(UserT var1);

        public abstract DestinationT getDefaultDestination();

        public @Nullable Coder<DestinationT> getDestinationCoder() {
            return null;
        }

        public abstract FilenamePolicy getFilenamePolicy(DestinationT var1);

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
        }

        final Coder<DestinationT> getDestinationCoderWithDefault(CoderRegistry registry) throws CannotProvideCoderException {
            Coder<DestinationT> destinationCoder = this.getDestinationCoder();
            if (destinationCoder != null) {
                return destinationCoder;
            }
            @Nullable TypeDescriptor<V> descriptor = TypeDescriptors.extractFromTypeParameters(this, DynamicDestinations.class, new TypeDescriptors.TypeVariableExtractor<DynamicDestinations<UserT, DestinationT, OutputT>, DestinationT>(){});
            try {
                return registry.getCoder(descriptor);
            }
            catch (CannotProvideCoderException e) {
                throw new CannotProvideCoderException("Failed to infer coder for DestinationT from type " + descriptor + ", please provide it explicitly by overriding getDestinationCoder()", e);
            }
        }

        static class SideInputAccessorViaProcessContext
        implements SideInputAccessor {
            private DoFn.ProcessContext processContext;

            SideInputAccessorViaProcessContext(DoFn.ProcessContext processContext) {
                this.processContext = processContext;
            }

            @Override
            public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> view) {
                return this.processContext.sideInput(view);
            }
        }

        static interface SideInputAccessor {
            public <SideInputT> SideInputT sideInput(PCollectionView<SideInputT> var1);
        }
    }

    @Deprecated
    public static enum CompressionType implements WritableByteChannelFactory
    {
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZSTD(Compression.ZSTD),
        LZO(Compression.LZO),
        LZOP(Compression.LZOP),
        DEFLATE(Compression.DEFLATE),
        SNAPPY(Compression.SNAPPY);

        private final Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        @Override
        public String getSuggestedFilenameSuffix() {
            return this.canonical.getSuggestedSuffix();
        }

        @Override
        public @Nullable String getMimeType() {
            return this.canonical == Compression.UNCOMPRESSED ? null : "application/octet-stream";
        }

        @Override
        public WritableByteChannel create(WritableByteChannel channel) throws IOException {
            return this.canonical.writeCompressed(channel);
        }

        public static CompressionType fromCanonical(Compression canonical) {
            switch (canonical) {
                case AUTO: {
                    throw new IllegalArgumentException("AUTO is not supported for writing");
                }
                case UNCOMPRESSED: {
                    return UNCOMPRESSED;
                }
                case GZIP: {
                    return GZIP;
                }
                case BZIP2: {
                    return BZIP2;
                }
                case ZIP: {
                    throw new IllegalArgumentException("ZIP is unsupported");
                }
                case ZSTD: {
                    return ZSTD;
                }
                case LZO: {
                    return LZO;
                }
                case LZOP: {
                    return LZOP;
                }
                case DEFLATE: {
                    return DEFLATE;
                }
                case SNAPPY: {
                    return SNAPPY;
                }
            }
            throw new UnsupportedOperationException("Unsupported compression type: " + (Object)((Object)canonical));
        }
    }
}

