/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

@Hidden
@Experimental
public interface ExperimentalOptions
extends PipelineOptions {
    public static final String STATE_CACHE_SIZE = "state_cache_size";
    public static final String STATE_SAMPLING_PERIOD_MILLIS = "state_sampling_period_millis";

    @Description(value="[Experimental] Apache Beam provides a number of experimental features that can be enabled with this flag. If executing against a managed service, please contact the service owners before enabling any experiments.")
    public @Nullable List<String> getExperiments();

    public void setExperiments(@Nullable List<String> var1);

    public static boolean hasExperiment(PipelineOptions options, String experiment) {
        if (options == null) {
            return false;
        }
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        return experiments != null && experiments.contains(experiment);
    }

    public static void addExperiment(ExperimentalOptions options, String experiment) {
        ArrayList experiments = options.getExperiments();
        if (experiments == null) {
            experiments = Lists.newArrayList();
        }
        if (!experiments.contains(experiment)) {
            experiments.add(experiment);
        }
        options.setExperiments(experiments);
    }

    public static String getExperimentValue(PipelineOptions options, String experiment) {
        if (options == null) {
            return null;
        }
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        if (experiments == null) {
            return null;
        }
        for (String experimentEntry : experiments) {
            String[] tokens = experimentEntry.split(experiment + "=", -1);
            if (tokens.length <= 1) continue;
            return tokens[1];
        }
        return null;
    }
}

